/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import net.minecraft.util.math.Vec3d;
import thebetweenlands.util.Vec3UV;

public class RotationMatrix {
    private float[] matrix = new float[9];
    private float rotG;
    private float rotB;
    private float rotA;

    public void setRotations(float rotG, float rotB, float rotA) {
        if (this.rotA == rotA && this.rotB == rotB && this.rotG == rotG) {
            return;
        }
        this.rotA = rotA;
        this.rotB = rotB;
        this.rotG = rotG;
        float sinAlpha = (float)Math.sin(rotA);
        float sinBeta = (float)Math.sin(rotB);
        float sinGamma = (float)Math.sin(rotG);
        float cosAlpha = (float)Math.cos(rotA);
        float cosBeta = (float)Math.cos(rotB);
        float cosGamma = (float)Math.cos(rotG);
        this.matrix[0] = cosAlpha * cosBeta;
        this.matrix[1] = cosAlpha * sinBeta * sinGamma - sinAlpha * cosGamma;
        this.matrix[2] = cosAlpha * sinBeta * cosGamma + sinAlpha * sinGamma;
        this.matrix[3] = sinAlpha * cosBeta;
        this.matrix[4] = sinAlpha * sinBeta * sinGamma + cosAlpha * cosGamma;
        this.matrix[5] = sinAlpha * sinBeta * cosGamma - cosAlpha * sinGamma;
        this.matrix[6] = -sinBeta;
        this.matrix[7] = cosBeta * sinGamma;
        this.matrix[8] = cosBeta * cosGamma;
    }

    public Vec3d transformVec(Vec3d point, Vec3d centerPoint) {
        double px = point.field_72450_a - centerPoint.field_72450_a;
        double py = point.field_72448_b - centerPoint.field_72448_b;
        double pz = point.field_72449_c - centerPoint.field_72449_c;
        return new Vec3d((double)this.matrix[0] * px + (double)this.matrix[1] * py + (double)this.matrix[2] * pz + centerPoint.field_72450_a, (double)this.matrix[3] * px + (double)this.matrix[4] * py + (double)this.matrix[5] * pz + centerPoint.field_72448_b, (double)this.matrix[6] * px + (double)this.matrix[7] * py + (double)this.matrix[8] * pz + centerPoint.field_72449_c);
    }

    public Vec3UV transformVec(Vec3UV point, Vec3UV centerPoint) {
        double px = point.x - centerPoint.x;
        double py = point.y - centerPoint.y;
        double pz = point.z - centerPoint.z;
        Vec3UV result = new Vec3UV(0.0, 0.0, 0.0);
        result.x = (double)this.matrix[0] * px + (double)this.matrix[1] * py + (double)this.matrix[2] * pz;
        result.y = (double)this.matrix[3] * px + (double)this.matrix[4] * py + (double)this.matrix[5] * pz;
        result.z = (double)this.matrix[6] * px + (double)this.matrix[7] * py + (double)this.matrix[8] * pz;
        result.x += centerPoint.x;
        result.y += centerPoint.y;
        result.z += centerPoint.z;
        return result;
    }
}

