/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class Mesh {
    private int vertexBufferID = -1;
    private int colorBufferID = -1;
    private int normalBufferID = -1;
    private int vertices = 0;

    public Mesh(List<Triangle> triangles) {
        if (triangles.size() == 0) {
            return;
        }
        this.vertexBufferID = GL15.glGenBuffers();
        this.colorBufferID = GL15.glGenBuffers();
        this.normalBufferID = GL15.glGenBuffers();
        this.vertices = triangles.size() * 3;
        DoubleBuffer vertexBuffer = BufferUtils.createDoubleBuffer((int)(this.vertices * 3));
        FloatBuffer colorBuffer = BufferUtils.createFloatBuffer((int)(this.vertices * 4));
        FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)(this.vertices * 3));
        for (Triangle tri : triangles) {
            vertexBuffer.put(new double[]{tri.v1.x, tri.v1.y, tri.v1.z});
            vertexBuffer.put(new double[]{tri.v2.x, tri.v2.y, tri.v2.z});
            vertexBuffer.put(new double[]{tri.v3.x, tri.v3.y, tri.v3.z});
            colorBuffer.put(this.getRGBAFromHex(tri.v1.color));
            colorBuffer.put(this.getRGBAFromHex(tri.v2.color));
            colorBuffer.put(this.getRGBAFromHex(tri.v3.color));
            normalBuffer.put(new float[]{(float)tri.v1.normal.x, (float)tri.v1.normal.y, (float)tri.v1.normal.z});
            normalBuffer.put(new float[]{(float)tri.v2.normal.x, (float)tri.v2.normal.y, (float)tri.v2.normal.z});
            normalBuffer.put(new float[]{(float)tri.v3.normal.x, (float)tri.v3.normal.y, (float)tri.v3.normal.z});
        }
        this.createVertexBuffer((DoubleBuffer)vertexBuffer.flip());
        this.createColorBuffer((FloatBuffer)colorBuffer.flip());
        this.createNormalBuffer((FloatBuffer)normalBuffer.flip());
        if (this.vertexBufferID == -1 || this.colorBufferID == -1 || this.normalBufferID == -1) {
            System.err.println("Invalid buffer IDs!");
            return;
        }
    }

    private void createVertexBuffer(DoubleBuffer buffer) {
        GL15.glBindBuffer((int)34962, (int)this.vertexBufferID);
        GL15.glBufferData((int)34962, (DoubleBuffer)buffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    private void createColorBuffer(FloatBuffer buffer) {
        GL15.glBindBuffer((int)34962, (int)this.colorBufferID);
        GL15.glBufferData((int)34962, (FloatBuffer)buffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    private void createNormalBuffer(FloatBuffer buffer) {
        GL15.glBindBuffer((int)34962, (int)this.normalBufferID);
        GL15.glBufferData((int)34962, (FloatBuffer)buffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    private float[] getRGBAFromHex(int hex) {
        float[] rgba = new float[]{(float)(hex >> 16 & 0xFF) / 255.0f, (float)(hex >> 8 & 0xFF) / 255.0f, (float)(hex & 0xFF) / 255.0f, (float)(hex >> 24 & 0xFF) / 255.0f};
        return rgba;
    }

    public void render() {
        if (this.vertexBufferID == -1 || this.colorBufferID == -1 || this.normalBufferID == -1) {
            System.err.println("Invalid buffer IDs!");
            return;
        }
        GL11.glEnableClientState((int)32884);
        GL15.glBindBuffer((int)34962, (int)this.vertexBufferID);
        GL11.glVertexPointer((int)3, (int)5130, (int)0, (long)0L);
        GL11.glEnableClientState((int)32886);
        GL15.glBindBuffer((int)34962, (int)this.colorBufferID);
        GL11.glColorPointer((int)4, (int)5126, (int)0, (long)0L);
        GL11.glEnableClientState((int)32885);
        GL15.glBindBuffer((int)34962, (int)this.normalBufferID);
        GL11.glNormalPointer((int)5126, (int)0, (long)0L);
        GL11.glDrawArrays((int)4, (int)0, (int)this.vertices);
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32885);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void destroy() {
        if (this.vertexBufferID == -1 || this.colorBufferID == -1 || this.normalBufferID == -1) {
            System.err.println("Invalid buffer IDs!");
            return;
        }
        GL15.glDeleteBuffers((int)this.vertexBufferID);
        GL15.glDeleteBuffers((int)this.colorBufferID);
        GL15.glDeleteBuffers((int)this.normalBufferID);
    }

    public static List<Triangle> createBoxOccluded(double x, double y, double z, double x2, double y2, double z2, boolean front, boolean back, boolean bottom, boolean top, boolean right, boolean left, int colorFront, int colorBack, int colorBottom, int colorTop, int colorRight, int colorLeft) {
        double width = x2 - x;
        double height = y2 - y;
        double depth = z2 - z;
        ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        if (front) {
            triangles.add(new Triangle(new Triangle.Vertex(x + width, y + height, z, new Triangle.Vertex.Vector3D(0.0, 0.0, 1.0), colorFront), new Triangle.Vertex(x + width, y, z, new Triangle.Vertex.Vector3D(0.0, 0.0, 1.0), colorFront), new Triangle.Vertex(x, y, z, new Triangle.Vertex.Vector3D(0.0, 0.0, 1.0), colorFront)));
            triangles.add(new Triangle(new Triangle.Vertex(x, y, z, new Triangle.Vertex.Vector3D(0.0, 0.0, 1.0), colorFront), new Triangle.Vertex(x, y + height, z, new Triangle.Vertex.Vector3D(0.0, 0.0, 1.0), colorFront), new Triangle.Vertex(x + width, y + height, z, new Triangle.Vertex.Vector3D(0.0, 0.0, 1.0), colorFront)));
        }
        if (back) {
            triangles.add(new Triangle(new Triangle.Vertex(x, y, z + depth, new Triangle.Vertex.Vector3D(0.0, 0.0, -1.0), colorBack), new Triangle.Vertex(x + width, y, z + depth, new Triangle.Vertex.Vector3D(0.0, 0.0, -1.0), colorBack), new Triangle.Vertex(x + width, y + height, z + depth, new Triangle.Vertex.Vector3D(0.0, 0.0, -1.0), colorBack)));
            triangles.add(new Triangle(new Triangle.Vertex(x + width, y + height, z + depth, new Triangle.Vertex.Vector3D(0.0, 0.0, -1.0), colorBack), new Triangle.Vertex(x, y + height, z + depth, new Triangle.Vertex.Vector3D(0.0, 0.0, -1.0), colorBack), new Triangle.Vertex(x, y, z + depth, new Triangle.Vertex.Vector3D(0.0, 0.0, -1.0), colorBack)));
        }
        if (bottom) {
            triangles.add(new Triangle(new Triangle.Vertex(x, y, z, new Triangle.Vertex.Vector3D(0.0, -1.0, 0.0), colorBottom), new Triangle.Vertex(x + width, y, z, new Triangle.Vertex.Vector3D(0.0, -1.0, 0.0), colorBottom), new Triangle.Vertex(x + width, y, z + depth, new Triangle.Vertex.Vector3D(0.0, -1.0, 0.0), colorBottom)));
            triangles.add(new Triangle(new Triangle.Vertex(x + width, y, z + depth, new Triangle.Vertex.Vector3D(0.0, -1.0, 0.0), colorBottom), new Triangle.Vertex(x, y, z + depth, new Triangle.Vertex.Vector3D(0.0, -1.0, 0.0), colorBottom), new Triangle.Vertex(x, y, z, new Triangle.Vertex.Vector3D(0.0, -1.0, 0.0), colorBottom)));
        }
        if (top) {
            triangles.add(new Triangle(new Triangle.Vertex(x + width, y + height, z + depth, new Triangle.Vertex.Vector3D(0.0, 1.0, 0.0), colorTop), new Triangle.Vertex(x + width, y + height, z, new Triangle.Vertex.Vector3D(0.0, 1.0, 0.0), colorTop), new Triangle.Vertex(x, y + height, z, new Triangle.Vertex.Vector3D(0.0, 1.0, 0.0), colorTop)));
            triangles.add(new Triangle(new Triangle.Vertex(x, y + height, z, new Triangle.Vertex.Vector3D(0.0, 1.0, 0.0), colorTop), new Triangle.Vertex(x, y + height, z + depth, new Triangle.Vertex.Vector3D(0.0, 1.0, 0.0), colorTop), new Triangle.Vertex(x + width, y + height, z + depth, new Triangle.Vertex.Vector3D(0.0, 1.0, 0.0), colorTop)));
        }
        if (right) {
            triangles.add(new Triangle(new Triangle.Vertex(x, y, z, new Triangle.Vertex.Vector3D(-1.0, 0.0, 0.0), colorRight), new Triangle.Vertex(x, y, z + depth, new Triangle.Vertex.Vector3D(-1.0, 0.0, 0.0), colorRight), new Triangle.Vertex(x, y + height, z + depth, new Triangle.Vertex.Vector3D(-1.0, 0.0, 0.0), colorRight)));
            triangles.add(new Triangle(new Triangle.Vertex(x, y + height, z + depth, new Triangle.Vertex.Vector3D(-1.0, 0.0, 0.0), colorRight), new Triangle.Vertex(x, y + height, z, new Triangle.Vertex.Vector3D(-1.0, 0.0, 0.0), colorRight), new Triangle.Vertex(x, y, z, new Triangle.Vertex.Vector3D(-1.0, 0.0, 0.0), colorRight)));
        }
        if (left) {
            triangles.add(new Triangle(new Triangle.Vertex(x + width, y + height, z + depth, new Triangle.Vertex.Vector3D(1.0, 0.0, 0.0), colorLeft), new Triangle.Vertex(x + width, y, z + depth, new Triangle.Vertex.Vector3D(1.0, 0.0, 0.0), colorLeft), new Triangle.Vertex(x + width, y, z, new Triangle.Vertex.Vector3D(1.0, 0.0, 0.0), colorLeft)));
            triangles.add(new Triangle(new Triangle.Vertex(x + width, y, z, new Triangle.Vertex.Vector3D(1.0, 0.0, 0.0), colorLeft), new Triangle.Vertex(x + width, y + height, z, new Triangle.Vertex.Vector3D(1.0, 0.0, 0.0), colorLeft), new Triangle.Vertex(x + width, y + height, z + depth, new Triangle.Vertex.Vector3D(1.0, 0.0, 0.0), colorLeft)));
        }
        return triangles;
    }

    public static class Triangle {
        public final Vertex v1;
        public final Vertex v2;
        public final Vertex v3;

        public Triangle(Vertex v1, Vertex v2, Vertex v3) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }

        public static class Vertex {
            public final double x;
            public final double y;
            public final double z;
            public final Vector3D normal;
            public final int color;

            public Vertex(double x, double y, double z, Vector3D normal, int color) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.normal = normal;
                this.color = color;
            }

            public static class Vector3D {
                public final double x;
                public final double y;
                public final double z;

                public Vector3D(double x, double y, double z) {
                    this.x = x;
                    this.y = y;
                    this.z = z;
                }

                public Vector3D normalized() {
                    double length = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
                    return new Vector3D(this.x / length, this.y / length, this.z / length);
                }
            }
        }
    }
}

