/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.storage.IOfflinePlayerDataHandler;
import thebetweenlands.common.TheBetweenlands;

public class OfflinePlayerHandlerImpl
implements IOfflinePlayerDataHandler {
    private Map<UUID, OfflinePlayerData> offlinePlayerDataCache = new HashMap<UUID, OfflinePlayerData>();
    private WorldServer world;
    private static OfflinePlayerHandlerImpl handler = null;

    public OfflinePlayerHandlerImpl(WorldServer world) {
        this.world = world;
    }

    @Override
    public void updateCache() {
        Iterator<Map.Entry<UUID, OfflinePlayerData>> playerDataIT = this.offlinePlayerDataCache.entrySet().iterator();
        while (playerDataIT.hasNext()) {
            Map.Entry<UUID, OfflinePlayerData> entry = playerDataIT.next();
            OfflinePlayerData data = entry.getValue();
            if (!data.isExpired()) continue;
            if (data.isDirty()) {
                this.saveOfflinePlayerDataSafely(entry.getKey(), data.getData());
            }
            playerDataIT.remove();
        }
    }

    @Override
    @Nullable
    public NBTTagCompound getOfflinePlayerData(UUID playerUuid) {
        OfflinePlayerData data = this.offlinePlayerDataCache.get(playerUuid);
        if (data != null) {
            data.refreshUseTimestamp();
            return data.nbt;
        }
        NBTTagCompound nbt = this.loadOfflinePlayerDataSafely(playerUuid);
        if (nbt != null) {
            data = new OfflinePlayerData();
            data.setData(nbt);
            this.offlinePlayerDataCache.put(playerUuid, data);
            return nbt;
        }
        return null;
    }

    private File getOfflinePlayerDataFolder(WorldServer world) {
        File file = new File(new File(world.func_72860_G().func_75765_b(), "playerdata"), "offline_player_data");
        file.mkdirs();
        return file;
    }

    @Nullable
    private NBTTagCompound loadOfflinePlayerDataSafely(UUID playerUuid) {
        try {
            return this.loadOfflinePlayerData(playerUuid);
        }
        catch (IOException ex) {
            TheBetweenlands.logger.error(String.format("Failed loading offline player data for UUID %s", playerUuid.toString()), (Throwable)ex);
            return null;
        }
    }

    @Nullable
    private NBTTagCompound loadOfflinePlayerData(UUID playerUuid) throws IOException {
        String fileName = playerUuid.toString();
        File file = new File(this.getOfflinePlayerDataFolder(this.world), fileName + ".dat");
        if (file.exists()) {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        }
        return null;
    }

    @Override
    public void setOfflinePlayerData(UUID playerUuid, NBTTagCompound nbt) {
        OfflinePlayerData data = this.offlinePlayerDataCache.get(playerUuid);
        if (data != null) {
            data.setData(nbt);
        } else {
            data = new OfflinePlayerData();
            data.setData(nbt);
            this.offlinePlayerDataCache.put(playerUuid, data);
        }
    }

    private boolean saveOfflinePlayerDataSafely(UUID playerUuid, NBTTagCompound nbt) {
        try {
            this.saveOfflinePlayerData(playerUuid, nbt);
            return true;
        }
        catch (IOException ex) {
            TheBetweenlands.logger.error(String.format("Failed saving offline player data for UUID %s", playerUuid.toString()), (Throwable)ex);
            return false;
        }
    }

    private void saveOfflinePlayerData(UUID playerUuid, NBTTagCompound nbt) throws IOException {
        String fileName = playerUuid.toString();
        File folder = this.getOfflinePlayerDataFolder(this.world);
        File tempFile = new File(folder, fileName + ".dat.tmp");
        File currentFile = new File(folder, fileName + ".dat");
        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(tempFile));
        if (currentFile.exists()) {
            currentFile.delete();
        }
        if (!tempFile.renameTo(currentFile)) {
            throw new IOException(String.format("Failed renaming %s to %s", tempFile, currentFile));
        }
    }

    @Override
    public void saveAllOfflinePlayerData() {
        for (Map.Entry<UUID, OfflinePlayerData> entry : this.offlinePlayerDataCache.entrySet()) {
            if (!entry.getValue().isDirty()) continue;
            this.saveOfflinePlayerDataSafely(entry.getKey(), entry.getValue().getData());
        }
    }

    @Nullable
    public static IOfflinePlayerDataHandler getHandler() {
        return handler;
    }

    private static WorldServer getMainWorld(World world) {
        if (world instanceof WorldServer && world == ((WorldServer)world).func_73046_m().func_130014_f_()) {
            return (WorldServer)world;
        }
        return null;
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        WorldServer world = OfflinePlayerHandlerImpl.getMainWorld(event.getWorld());
        if (world != null) {
            if (handler != null) {
                handler.saveAllOfflinePlayerData();
            }
            handler = new OfflinePlayerHandlerImpl(world);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        WorldServer world = OfflinePlayerHandlerImpl.getMainWorld(event.getWorld());
        if (world != null) {
            if (handler != null) {
                handler.saveAllOfflinePlayerData();
            }
            handler = null;
        }
    }

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save event) {
        WorldServer world = OfflinePlayerHandlerImpl.getMainWorld(event.getWorld());
        if (world != null && handler != null) {
            handler.saveAllOfflinePlayerData();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (handler != null) {
            handler.updateCache();
        }
    }

    private static class OfflinePlayerData {
        private NBTTagCompound nbt;
        private boolean dirty;
        private long timestamp;

        private OfflinePlayerData() {
        }

        protected void setData(NBTTagCompound nbt) {
            this.nbt = nbt;
            this.dirty = true;
            this.refreshUseTimestamp();
        }

        protected NBTTagCompound getData() {
            return this.nbt;
        }

        protected void refreshUseTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        protected boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 30000L;
        }

        protected boolean isDirty() {
            return this.dirty;
        }

        protected void resetDirty() {
            this.dirty = false;
        }
    }
}

