/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootContext;
import thebetweenlands.api.loot.ISharedLootContainer;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.SoilHelper;
import thebetweenlands.common.block.plant.BlockHangingPlant;
import thebetweenlands.common.block.plant.BlockMoss;
import thebetweenlands.common.block.plant.BlockPlant;
import thebetweenlands.common.block.structure.BlockCarvedMudBrick;
import thebetweenlands.common.block.structure.BlockDecayPitGroundChain;
import thebetweenlands.common.block.structure.BlockMudBrickRoof;
import thebetweenlands.common.block.structure.BlockMudTiles;
import thebetweenlands.common.block.structure.BlockSlabBetweenlands;
import thebetweenlands.common.entity.EntityCCGroundSpawner;
import thebetweenlands.common.entity.EntityDecayPitTarget;
import thebetweenlands.common.entity.EntityMovingWall;
import thebetweenlands.common.entity.EntityTriggeredFallingBlock;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityDungeonDoorCombination;
import thebetweenlands.common.tile.TileEntityDungeonDoorRunes;
import thebetweenlands.common.tile.TileEntityItemShelf;
import thebetweenlands.common.tile.TileEntityLootInventory;
import thebetweenlands.common.tile.TileEntityMudBrickAlcove;
import thebetweenlands.common.world.biome.BiomeSludgePlainsClearing;
import thebetweenlands.common.world.gen.feature.structure.DecayPitBuildParts;
import thebetweenlands.common.world.gen.feature.structure.LightTowerBuildParts;
import thebetweenlands.common.world.gen.feature.structure.SludgeWormMazeMicroBuilds;
import thebetweenlands.common.world.gen.feature.structure.utils.PerfectMazeGenerator;
import thebetweenlands.common.world.gen.feature.structure.utils.SludgeWormMazeBlockHelper;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.SharedLootPoolStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationAmbience;
import thebetweenlands.common.world.storage.location.LocationSludgeWormDungeon;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class WorldGenSludgeWormDungeon
extends WorldGenerator {
    private SludgeWormMazeBlockHelper blockHelper = new SludgeWormMazeBlockHelper(this);
    private SludgeWormMazeMicroBuilds microBuild = new SludgeWormMazeMicroBuilds(this);
    private LightTowerBuildParts lightTowerBuild = new LightTowerBuildParts(this);
    private DecayPitBuildParts decayPitBuild = new DecayPitBuildParts(this);
    private SharedLootPoolStorage lootStorage;
    private LocationSludgeWormDungeon location;
    private LocationStorage locationBarrisheeLair;
    private LocationStorage locationCrypt;
    private Random lootRng;
    private static final ThreadLocal<Boolean> CASCADING_GEN_MUTEX = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public WorldGenSludgeWormDungeon() {
        super(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (CASCADING_GEN_MUTEX.get().booleanValue()) {
            return false;
        }
        CASCADING_GEN_MUTEX.set(true);
        try {
            List<LocationSludgeWormDungeon> dungeonLocations;
            Biome biome = world.func_180494_b(pos);
            if (biome instanceof BiomeSludgePlainsClearing) {
                pos = new BlockPos(pos.func_177958_n(), (int)biome.func_185355_j() + 1, pos.func_177952_p());
            }
            if (!(dungeonLocations = BetweenlandsWorldStorage.forWorld(world).getLocalStorageHandler().getLocalStorages(LocationSludgeWormDungeon.class, new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() + 30), (double)(pos.func_177952_p() - 3), (double)(pos.func_177958_n() + 29), (double)(pos.func_177956_o() - 58), (double)(pos.func_177952_p() + 29)), l -> true)).isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.lootRng = new Random(rand.nextLong());
            this.generateLocations(world, rand, pos);
            this.makeMaze(world, rand, pos);
            this.generateTower(world, rand, pos.func_177977_b().func_177982_a(12, 0, 12));
            this.generateCryptCrawlerDungeon(world, rand, pos.func_177979_c(25).func_177982_a(-3, 0, -3));
            this.generateDecayPit(world, rand, pos.func_177979_c(44).func_177982_a(14, 0, 14));
            this.generateDecayPitEntrance(world, rand, pos.func_177979_c(59).func_177982_a(-3, 0, -3));
            this.protectTowerInside(world, rand, pos.func_177977_b().func_177982_a(12, 0, 12));
            boolean bl = true;
            return bl;
        }
        finally {
            CASCADING_GEN_MUTEX.set(false);
        }
    }

    public void generateLocations(World world, Random rand, BlockPos pos) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        this.lootStorage = new SharedLootPoolStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), rand.nextLong());
        worldStorage.getLocalStorageHandler().addLocalStorage(this.lootStorage);
        this.location = new LocationSludgeWormDungeon(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos));
        this.location.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() + 30), (double)(pos.func_177952_p() - 3), (double)(pos.func_177958_n() + 29), (double)(pos.func_177956_o() - 58), (double)(pos.func_177952_p() + 29)));
        this.location.setLayer(0);
        this.location.setSeed(rand.nextLong());
        this.location.setStructurePos(pos);
        this.location.setVisible(true);
        this.location.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(this.location);
        LocationStorage locationMaze = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), "sludge_worm_dungeon_maze", EnumLocationType.SLUDGE_WORM_DUNGEON);
        locationMaze.addBounds(new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 29), (double)(pos.func_177956_o() - 40 - 3), (double)(pos.func_177952_p() + 29)));
        locationMaze.setLayer(1);
        locationMaze.setSeed(rand.nextLong());
        locationMaze.setVisible(true);
        locationMaze.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(locationMaze);
        this.locationBarrisheeLair = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), "sludge_worm_dungeon_barrishee_lair", EnumLocationType.SLUDGE_WORM_DUNGEON);
        this.locationBarrisheeLair.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() + 20), (double)(pos.func_177956_o() - 24), (double)(pos.func_177952_p() - 3), (double)(pos.func_177958_n() + 29), (double)(pos.func_177956_o() - 19), (double)pos.func_177952_p()));
        this.locationBarrisheeLair.setLayer(1);
        this.locationBarrisheeLair.setSeed(rand.nextLong());
        this.locationBarrisheeLair.setVisible(true);
        this.locationBarrisheeLair.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(this.locationBarrisheeLair);
        LocationStorage locationWalkays = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), "sludge_worm_dungeon_winding_walkways", EnumLocationType.SLUDGE_WORM_DUNGEON);
        locationWalkays.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 43), (double)(pos.func_177952_p() - 3), (double)pos.func_177958_n(), (double)(pos.func_177956_o() - 24), (double)(pos.func_177952_p() + 29)), new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - 43), (double)(pos.func_177952_p() - 3), (double)(pos.func_177958_n() + 29), (double)(pos.func_177956_o() - 24), (double)pos.func_177952_p()));
        locationWalkays.setLayer(1);
        locationWalkays.setSeed(rand.nextLong());
        locationWalkays.setVisible(true);
        locationWalkays.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(locationWalkays);
        LocationStorage locationCryptTunnels = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), "sludge_worm_dungeon_crypt_tunnels", EnumLocationType.SLUDGE_WORM_DUNGEON);
        locationCryptTunnels.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() + 4), (double)(pos.func_177956_o() - 50), (double)(pos.func_177952_p() + 28), (double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 43), (double)(pos.func_177952_p() + 23)), new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 45), (double)(pos.func_177952_p() + 23), (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() - 50), (double)(pos.func_177952_p() + 21)), new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 50), (double)(pos.func_177952_p() + 20), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() - 46), (double)(pos.func_177952_p() + 21)), new AxisAlignedBB((double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() - 47), (double)(pos.func_177952_p() + 20), (double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 51), (double)(pos.func_177952_p() + 18)), new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 52), (double)(pos.func_177952_p() + 18), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() - 48), (double)(pos.func_177952_p() + 16)), new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 49), (double)(pos.func_177952_p() + 16), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() - 53), (double)(pos.func_177952_p() + 12)), new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 51), (double)(pos.func_177952_p() + 12), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() + 10)), new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 52), (double)(pos.func_177952_p() + 10), (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() + 7)), new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 53), (double)(pos.func_177952_p() + 7), (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() + 4)), new AxisAlignedBB((double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() + 4), (double)(pos.func_177958_n() + 4), (double)(pos.func_177956_o() - 51), (double)(pos.func_177952_p() - 1)), new AxisAlignedBB((double)(pos.func_177958_n() + 3), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() - 2), (double)(pos.func_177958_n() + 23), (double)(pos.func_177956_o() - 54), (double)(pos.func_177952_p() + 1)), new AxisAlignedBB((double)(pos.func_177958_n() + 22), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 28), (double)(pos.func_177956_o() - 51), (double)(pos.func_177952_p() + 4)), new AxisAlignedBB((double)(pos.func_177958_n() + 28), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() + 4), (double)(pos.func_177958_n() + 25), (double)(pos.func_177956_o() - 54), (double)(pos.func_177952_p() + 22)), new AxisAlignedBB((double)(pos.func_177958_n() + 28), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() + 22), (double)(pos.func_177958_n() + 22), (double)(pos.func_177956_o() - 51), (double)(pos.func_177952_p() + 27)), new AxisAlignedBB((double)(pos.func_177958_n() + 23), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() + 28), (double)(pos.func_177958_n() + 3), (double)(pos.func_177956_o() - 54), (double)(pos.func_177952_p() + 25)), new AxisAlignedBB((double)(pos.func_177958_n() + 4), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() + 27), (double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() - 51), (double)(pos.func_177952_p() + 22)));
        locationCryptTunnels.setLayer(1);
        locationCryptTunnels.setSeed(rand.nextLong());
        locationCryptTunnels.setVisible(true);
        locationCryptTunnels.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(locationCryptTunnels);
        this.locationCrypt = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), "sludge_worm_dungeon_crypt", EnumLocationType.SLUDGE_WORM_DUNGEON);
        this.locationCrypt.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 57), (double)(pos.func_177952_p() + 22), (double)(pos.func_177958_n() + 7), (double)(pos.func_177956_o() - 54), (double)(pos.func_177952_p() + 12)));
        this.locationCrypt.setLayer(1);
        this.locationCrypt.setSeed(rand.nextLong());
        this.locationCrypt.setVisible(true);
        this.locationCrypt.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(this.locationCrypt);
        LocationStorage locationPit = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), "sludge_worm_dungeon_pit", EnumLocationType.SLUDGE_WORM_DUNGEON);
        locationPit.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() - 43), (double)(pos.func_177952_p() + 1), (double)(pos.func_177958_n() + 9), (double)(pos.func_177956_o() - 48), (double)(pos.func_177952_p() + 4)), new AxisAlignedBB((double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() - 49), (double)(pos.func_177952_p() + 1), (double)(pos.func_177958_n() + 28), (double)(pos.func_177956_o() - 43), (double)(pos.func_177952_p() + 22)), new AxisAlignedBB((double)(pos.func_177958_n() + 4), (double)(pos.func_177956_o() - 49), (double)(pos.func_177952_p() + 22), (double)(pos.func_177958_n() + 25), (double)(pos.func_177956_o() - 43), (double)(pos.func_177952_p() + 28)), new AxisAlignedBB((double)(pos.func_177958_n() + 3), (double)(pos.func_177956_o() - 54), (double)(pos.func_177952_p() + 19), (double)(pos.func_177958_n() + 26), (double)(pos.func_177956_o() - 49), (double)(pos.func_177952_p() + 9)), new AxisAlignedBB((double)(pos.func_177958_n() + 4), (double)(pos.func_177956_o() - 49), (double)(pos.func_177952_p() + 9), (double)(pos.func_177958_n() + 24), (double)(pos.func_177956_o() - 54), (double)(pos.func_177952_p() + 4)), new AxisAlignedBB((double)(pos.func_177958_n() + 8), (double)(pos.func_177956_o() - 49), (double)(pos.func_177952_p() + 3), (double)(pos.func_177958_n() + 21), (double)(pos.func_177956_o() - 52), (double)(pos.func_177952_p() + 4)), new AxisAlignedBB((double)(pos.func_177958_n() + 3), (double)(pos.func_177956_o() - 49), (double)(pos.func_177952_p() + 19), (double)(pos.func_177958_n() + 26), (double)(pos.func_177956_o() - 54), (double)(pos.func_177952_p() + 22)), new AxisAlignedBB((double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() - 49), (double)(pos.func_177952_p() + 22), (double)(pos.func_177958_n() + 22), (double)(pos.func_177956_o() - 54), (double)(pos.func_177952_p() + 26)), new AxisAlignedBB((double)(pos.func_177958_n() + 22), (double)(pos.func_177956_o() - 49), (double)(pos.func_177952_p() + 22), (double)(pos.func_177958_n() + 23), (double)(pos.func_177956_o() - 51), (double)(pos.func_177952_p() + 23)), new AxisAlignedBB((double)(pos.func_177958_n() + 21), (double)(pos.func_177956_o() - 54), (double)(pos.func_177952_p() + 8), (double)(pos.func_177958_n() + 8), (double)(pos.func_177956_o() - 58), (double)(pos.func_177952_p() + 21)));
        locationPit.setLayer(1);
        locationPit.setAmbience(new LocationAmbience(LocationAmbience.EnumLocationAmbience.SLUDGE_WORM_DUNGEON).setFogColor(new int[]{120, 120, 120}).setFogRange(4.0f, 45.0f).setCaveFog(false));
        locationPit.setSeed(rand.nextLong());
        locationPit.setVisible(true);
        locationPit.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(locationPit);
    }

    private void protectTowerInside(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int height = 16;
        int radius = 9;
        for (int yy = y; y + height >= yy; ++yy) {
            for (int i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) > (long)radius) continue;
                    this.location.getGuard().setGuarded(world, new BlockPos(x + i, yy, z + j), true);
                }
            }
        }
    }

    private void generateCryptCrawlerDungeon(World world, Random rand, BlockPos pos) {
        int y;
        int y2;
        int z;
        int x;
        for (x = 0; x < 32; ++x) {
            for (z = 0; z < 3; ++z) {
                for (y2 = -18; y2 < 0; ++y2) {
                    this.func_175903_a(world, pos.func_177982_a(x, y2, z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (x = 0; x < 3; ++x) {
            for (z = 3; z < 32; ++z) {
                for (y2 = -18; y2 < 0; ++y2) {
                    this.func_175903_a(world, pos.func_177982_a(x, y2, z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (x = 1; x < 32; ++x) {
            for (z = 1; z < 3; ++z) {
                this.func_175903_a(world, pos.func_177982_a(x, 0, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -6, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -12, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -18, z), this.blockHelper.COMPACTED_MUD);
                if (rand.nextBoolean()) {
                    this.func_175903_a(world, pos.func_177982_a(x, -1, z), this.blockHelper.COMPACTED_MUD);
                }
                if (rand.nextBoolean()) {
                    this.func_175903_a(world, pos.func_177982_a(x, -7, z), this.blockHelper.COMPACTED_MUD);
                }
                if (rand.nextBoolean()) {
                    this.func_175903_a(world, pos.func_177982_a(x, -13, z), this.blockHelper.COMPACTED_MUD);
                }
                this.func_175903_a(world, pos.func_177982_a(x, -5, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -11, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -17, z), this.blockHelper.COMPACTED_MUD);
            }
        }
        for (x = 1; x < 3; ++x) {
            for (z = 3; z < 32; ++z) {
                this.func_175903_a(world, pos.func_177982_a(x, 0, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -6, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -12, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -18, z), this.blockHelper.COMPACTED_MUD);
                if (rand.nextBoolean()) {
                    this.func_175903_a(world, pos.func_177982_a(x, -1, z), this.blockHelper.COMPACTED_MUD);
                }
                if (rand.nextBoolean()) {
                    this.func_175903_a(world, pos.func_177982_a(x, -7, z), this.blockHelper.COMPACTED_MUD);
                }
                if (rand.nextBoolean()) {
                    this.func_175903_a(world, pos.func_177982_a(x, -13, z), this.blockHelper.COMPACTED_MUD);
                }
                this.func_175903_a(world, pos.func_177982_a(x, -5, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -11, z), this.blockHelper.COMPACTED_MUD);
                this.func_175903_a(world, pos.func_177982_a(x, -17, z), this.blockHelper.COMPACTED_MUD);
            }
        }
        this.microBuild.buildCryptCrawlerWalkways(world, pos, EnumFacing.SOUTH, rand);
        this.addHangingPlants(world, pos.func_177982_a(1, 0, 1), rand, 32, 0, 3);
        this.addHangingPlants(world, pos.func_177982_a(1, 0, 1), rand, 32, -6, 3);
        this.addHangingPlants(world, pos.func_177982_a(1, 0, 1), rand, 32, -12, 3);
        this.addGroundPlants(world, pos.func_177982_a(1, 0, 1), rand, 32, -5, 3, true, false, true, true);
        this.addGroundPlants(world, pos.func_177982_a(1, 0, 1), rand, 32, -11, 3, true, false, true, true);
        this.addGroundPlants(world, pos.func_177982_a(1, 0, 1), rand, 32, -17, 3, true, false, true, true);
        this.addEdgePlant(world, pos.func_177982_a(1, 0, 1), rand, 32, -5, 3);
        this.addEdgePlant(world, pos.func_177982_a(1, 0, 1), rand, 32, -11, 3);
        this.addEdgePlant(world, pos.func_177982_a(1, 0, 1), rand, 32, -17, 3);
        this.addWallPlants(world, pos.func_177982_a(0, -3, 0), rand, 32, 2, 1, EnumFacing.SOUTH);
        this.addWallPlants(world, pos.func_177982_a(0, -9, 0), rand, 32, 2, 1, EnumFacing.SOUTH);
        this.addWallPlants(world, pos.func_177982_a(0, -15, 0), rand, 32, 2, 1, EnumFacing.SOUTH);
        this.addWallPlants(world, pos.func_177982_a(0, -3, 3), rand, 32, 2, 1, EnumFacing.NORTH);
        this.addWallPlants(world, pos.func_177982_a(0, -9, 3), rand, 32, 2, 1, EnumFacing.NORTH);
        this.addWallPlants(world, pos.func_177982_a(0, -15, 3), rand, 32, 2, 1, EnumFacing.NORTH);
        this.addHangingPlants(world, pos.func_177982_a(1, 0, 3), rand, 3, 0, 32);
        this.addHangingPlants(world, pos.func_177982_a(1, 0, 3), rand, 3, -6, 32);
        this.addHangingPlants(world, pos.func_177982_a(1, 0, 3), rand, 32, -12, 3);
        this.addGroundPlants(world, pos.func_177982_a(1, 0, 3), rand, 3, -5, 32, true, false, true, true);
        this.addGroundPlants(world, pos.func_177982_a(1, 0, 3), rand, 3, -11, 32, true, false, true, true);
        this.addGroundPlants(world, pos.func_177982_a(1, 0, 3), rand, 3, -17, 32, true, false, true, true);
        this.addEdgePlant(world, pos.func_177982_a(1, 0, 3), rand, 3, -5, 32);
        this.addEdgePlant(world, pos.func_177982_a(1, 0, 3), rand, 3, -11, 32);
        this.addEdgePlant(world, pos.func_177982_a(1, 0, 3), rand, 3, -17, 32);
        this.addWallPlants(world, pos.func_177982_a(0, -3, 0), rand, 1, 2, 32, EnumFacing.EAST);
        this.addWallPlants(world, pos.func_177982_a(0, -9, 0), rand, 1, 2, 32, EnumFacing.EAST);
        this.addWallPlants(world, pos.func_177982_a(0, -15, 0), rand, 1, 2, 32, EnumFacing.EAST);
        this.addWallPlants(world, pos.func_177982_a(3, -3, 3), rand, 1, 2, 32, EnumFacing.WEST);
        this.addWallPlants(world, pos.func_177982_a(3, -9, 3), rand, 1, 2, 32, EnumFacing.WEST);
        this.addWallPlants(world, pos.func_177982_a(3, -15, 3), rand, 1, 2, 32, EnumFacing.WEST);
        this.addSphericalChamber(world, rand, pos.func_177982_a(4, -29, 27));
        this.addSphericalChamber(world, rand, pos.func_177982_a(4, -29, 4));
        this.addSphericalChamber(world, rand, pos.func_177982_a(27, -29, 4));
        this.addSphericalChamber(world, rand, pos.func_177982_a(27, -29, 27));
        this.microBuild.buildCryptCrawlerBottomTunnels(world, pos.func_177982_a(0, -33, 0), EnumFacing.SOUTH, rand);
        this.microBuild.buildCryptCrawlerBottomTunnels(world, pos.func_177982_a(0, -33, 31), EnumFacing.EAST, rand);
        this.microBuild.buildCryptCrawlerBottomTunnels(world, pos.func_177982_a(31, -33, 0), EnumFacing.WEST, rand);
        this.microBuild.buildCryptCrawlerBottomTunnels(world, pos.func_177982_a(31, -33, 31), EnumFacing.NORTH, rand);
        this.microBuild.buildCryptCrawlerTunnelsConnect(world, pos.func_177982_a(0, -33, 0), EnumFacing.SOUTH, rand);
        for (y = -33; y < -23; ++y) {
            this.addGroundPlants(world, pos.func_177982_a(1, y, 1), rand, 32, 0, 32, false, false, true, true);
            this.addEdgePlant(world, pos.func_177982_a(1, y, 1), rand, 32, 0, 32);
        }
        for (y = -26; y < -18; ++y) {
            this.addHangingPlants(world, pos.func_177982_a(1, y, 1), rand, 32, 0, 32);
        }
    }

    public void addGroundPlants(World world, BlockPos pos, Random rand, int x, int y, int z, boolean addMudNoise, boolean addMoss, boolean addWeeds, boolean addMushrooms) {
        for (int horizontalX = 0; horizontalX < x; ++horizontalX) {
            for (int horizontalZ = 0; horizontalZ < z; ++horizontalZ) {
                if (addMudNoise && this.plantingChance(rand) && this.isPlantableAbove(world, pos.func_177982_a(horizontalX, y, horizontalZ))) {
                    this.func_175903_a(world, pos.func_177982_a(horizontalX, y, horizontalZ), this.blockHelper.COMPACTED_MUD_SLAB);
                }
                if (!this.isPlantableAbove(world, pos.func_177982_a(horizontalX, y, horizontalZ))) continue;
                if (addWeeds && this.plantingChance(rand)) {
                    this.func_175903_a(world, pos.func_177982_a(horizontalX, y + 1, horizontalZ), this.getRandomFloorPlant(rand));
                    continue;
                }
                if (addMushrooms && this.plantingChance(rand)) {
                    this.func_175903_a(world, pos.func_177982_a(horizontalX, y + 1, horizontalZ), this.getRandomMushroom(rand));
                    continue;
                }
                if (!addMoss || !rand.nextBoolean()) continue;
                this.func_175903_a(world, pos.func_177982_a(horizontalX, y + 1, horizontalZ), this.blockHelper.MOSS.func_177226_a((IProperty)BlockMoss.field_176387_N, (Comparable)EnumFacing.UP));
            }
        }
    }

    public void addHangingPlants(World world, BlockPos pos, Random rand, int x, int y, int z) {
        for (int horizontalX = 0; horizontalX < x; ++horizontalX) {
            for (int horizontalZ = 0; horizontalZ < z; ++horizontalZ) {
                if (!this.plantingChance(rand) || !this.isPlantableBelow(world, pos.func_177982_a(horizontalX, y, horizontalZ))) continue;
                IBlockState plant = this.getRandomHangingPlant(rand);
                this.func_175903_a(world, pos.func_177982_a(horizontalX, y - 1, horizontalZ), plant);
                if (!this.plantingChance(rand) || !world.func_175623_d(pos.func_177982_a(horizontalX, y - 2, horizontalZ))) continue;
                this.func_175903_a(world, pos.func_177982_a(horizontalX, y - 2, horizontalZ), plant);
                if (!this.plantingChance(rand) || !world.func_175623_d(pos.func_177982_a(horizontalX, y - 3, horizontalZ))) continue;
                this.func_175903_a(world, pos.func_177982_a(horizontalX, y - 3, horizontalZ), plant);
            }
        }
    }

    public void addWallPlants(World world, BlockPos pos, Random rand, int x, int y, int z, EnumFacing facing) {
        for (int horizontalX = 0; horizontalX < x; ++horizontalX) {
            for (int horizontalZ = 0; horizontalZ < z; ++horizontalZ) {
                for (int vertical = 0; vertical < y; ++vertical) {
                    if (!this.plantingChance(rand) || !this.isPlantableWall(world, pos.func_177982_a(horizontalX, vertical, horizontalZ), facing)) continue;
                    this.func_175903_a(world, pos.func_177982_a(horizontalX, vertical, horizontalZ).func_177972_a(facing), this.blockHelper.MOSS.func_177226_a((IProperty)BlockMoss.field_176387_N, (Comparable)facing));
                }
            }
        }
    }

    public void addEdgePlant(World world, BlockPos pos, Random rand, int x, int y, int z) {
        for (int horizontalX = 0; horizontalX < x; ++horizontalX) {
            for (int horizontalZ = 0; horizontalZ < z; ++horizontalZ) {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    if (!world.func_180495_p(pos.func_177982_a(horizontalX, y + 1, horizontalZ).func_177972_a(facing)).isSideSolid((IBlockAccess)world, pos.func_177982_a(horizontalX, y + 1, horizontalZ).func_177972_a(facing), facing.func_176734_d()) || !this.plantingChance(rand) || !this.isPlantableAbove(world, pos.func_177982_a(horizontalX, y, horizontalZ))) continue;
                    this.func_175903_a(world, pos.func_177982_a(horizontalX, y + 1, horizontalZ), this.blockHelper.getRandomEdgePlant(rand, facing.func_176734_d()));
                }
            }
        }
    }

    public void addSphericalChamber(World world, Random rand, BlockPos pos) {
        for (int xx = -4; xx <= 4; ++xx) {
            for (int zz = -4; zz <= 4; ++zz) {
                for (int yy = -4; yy <= 4; ++yy) {
                    double dSqSphere = Math.pow(xx, 2.0) + Math.pow(zz, 2.0) + Math.pow(yy, 2.0);
                    if (Math.round(Math.sqrt(dSqSphere)) > 4L) continue;
                    if (dSqSphere >= Math.pow(3.0, 2.0)) {
                        this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.blockHelper.COMPACTED_MUD);
                        continue;
                    }
                    this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        this.func_175903_a(world, pos.func_177982_a(0, -4, 0), this.blockHelper.COMPACTED_MUD);
        this.func_175903_a(world, pos.func_177982_a(0, -3, 0), this.blockHelper.AIR);
        this.func_175903_a(world, pos.func_177982_a(0, 2, 0), this.blockHelper.HANGER);
        this.func_175903_a(world, pos.func_177982_a(0, 1, 0), this.blockHelper.HANGER);
        this.func_175903_a(world, pos, this.blockHelper.getRandomBeam(EnumFacing.NORTH, rand, 0, 2, false));
        this.func_175903_a(world, pos.func_177982_a(-1, -3, -1), this.blockHelper.MUD_BRICK_ROOF.func_177226_a((IProperty)BlockMudBrickRoof.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockMudBrickRoof.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
        this.func_175903_a(world, pos.func_177982_a(0, -3, -1), this.blockHelper.MUD_BRICK_ROOF.func_177226_a((IProperty)BlockMudBrickRoof.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockMudBrickRoof.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
        this.func_175903_a(world, pos.func_177982_a(1, -3, -1), this.blockHelper.MUD_BRICK_ROOF.func_177226_a((IProperty)BlockMudBrickRoof.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockMudBrickRoof.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
        this.func_175903_a(world, pos.func_177982_a(-1, -3, 1), this.blockHelper.MUD_BRICK_ROOF.func_177226_a((IProperty)BlockMudBrickRoof.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockMudBrickRoof.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
        this.func_175903_a(world, pos.func_177982_a(0, -3, 1), this.blockHelper.MUD_BRICK_ROOF.func_177226_a((IProperty)BlockMudBrickRoof.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockMudBrickRoof.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
        this.func_175903_a(world, pos.func_177982_a(1, -3, 1), this.blockHelper.MUD_BRICK_ROOF.func_177226_a((IProperty)BlockMudBrickRoof.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockMudBrickRoof.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
        this.func_175903_a(world, pos.func_177982_a(-1, -3, 0), this.blockHelper.MUD_BRICK_ROOF.func_177226_a((IProperty)BlockMudBrickRoof.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockMudBrickRoof.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
        this.func_175903_a(world, pos.func_177982_a(1, -3, 0), this.blockHelper.MUD_BRICK_ROOF.func_177226_a((IProperty)BlockMudBrickRoof.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockMudBrickRoof.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM));
        this.addHangingBlockEntity(world, pos);
        this.addCCGroundSpawnerEntity(world, pos.func_177982_a(0, -3, 0));
    }

    public boolean plantingChance(Random rand) {
        return rand.nextBoolean() && rand.nextBoolean();
    }

    public boolean isPlantableAbove(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return SoilHelper.canSustainPlant(state) && world.func_175623_d(pos.func_177984_a());
    }

    public boolean isPlantableBelow(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return SoilHelper.canSustainPlant(state) && world.func_175623_d(pos.func_177977_b());
    }

    public boolean isPlantableWall(World world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_185913_b() && world.func_175623_d(pos.func_177972_a(facing));
    }

    public void generateTower(World world, Random rand, BlockPos pos) {
        int i;
        int yy;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int height = 16;
        int radius = 9;
        int radiusMud = 15;
        int level1 = 0;
        int level2 = 8;
        int level3 = 16;
        for (yy = y + 1; y + 1 + height >= yy; ++yy) {
            for (i = radiusMud * -1; i <= radiusMud; ++i) {
                for (int j = radiusMud * -1; j <= radiusMud; ++j) {
                    this.func_175903_a(world, new BlockPos(x + i, yy, z + j), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (int i2 = radiusMud * -1; i2 <= radiusMud; ++i2) {
            for (int j = radiusMud * -1; j <= radiusMud; ++j) {
                double dSq = i2 * i2 + j * j;
                if (Math.round(Math.sqrt(dSq)) == (long)(radiusMud - 1)) {
                    this.func_175903_a(world, new BlockPos(x + i2, y, z + j), this.blockHelper.getMudBricksForLevel(rand, 0, 1));
                }
                if (Math.round(Math.sqrt(dSq)) != (long)radiusMud) continue;
                this.func_175903_a(world, new BlockPos(x + i2, y, z + j), rand.nextInt(3) == 0 ? this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM) : this.blockHelper.getMudBricksForLevel(rand, 0, 1));
            }
        }
        for (yy = y; y + height >= yy; ++yy) {
            for (i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) == (long)radius && yy - y < level2) {
                        this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.blockHelper.PITSTONE_BRICKS);
                    }
                    if (Math.round(Math.sqrt(dSq)) == (long)radius && yy - y > level2 && yy - y < level3) {
                        if (yy == y + level2 + 1) {
                            this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.blockHelper.getMudBricksForLevel(rand, 0, 2));
                        } else if (yy == y + level2 + 6) {
                            this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.blockHelper.getMudBricksForLevel(rand, 0, 3));
                        } else {
                            this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.blockHelper.getMudBricksForLevel(rand, 0, 1));
                        }
                    }
                    if (yy == y + level1 && Math.round(Math.sqrt(dSq)) <= (long)(radius - 8)) {
                        this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.blockHelper.PITSTONE_TILES);
                    }
                    if (yy == y + level2) {
                        if (Math.round(Math.sqrt(dSq)) == (long)(radius - 8)) {
                            this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.blockHelper.PITSTONE_TILES);
                        }
                        if (Math.round(Math.sqrt(dSq)) == (long)radius) {
                            this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.blockHelper.getRandomBeam(EnumFacing.SOUTH, rand, 0, 0, false));
                        }
                    }
                    if (yy != y + level3 || Math.round(Math.sqrt(dSq)) != (long)radius) continue;
                    this.func_175903_a(world, new BlockPos(x + i, yy, z + j), this.blockHelper.getRandomBeam(EnumFacing.SOUTH, rand, 0, 0, false));
                }
            }
        }
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.SOUTH, rand, level1, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.EAST, rand, level1, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.NORTH, rand, level1, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.WEST, rand, level1, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.SOUTH, rand, level2, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.EAST, rand, level2, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.NORTH, rand, level2, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.WEST, rand, level2, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.SOUTH, rand, level3, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.EAST, rand, level3, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.NORTH, rand, level3, 0);
        this.lightTowerBuild.addTowerFloor(world, pos, EnumFacing.WEST, rand, level3, 0);
        this.lightTowerBuild.addTowerDoorways(world, pos, EnumFacing.SOUTH, rand, level1, 0);
        this.lightTowerBuild.addTowerDoorways(world, pos, EnumFacing.SOUTH, rand, level2, 0);
        this.lightTowerBuild.addTowerDoorways(world, pos, EnumFacing.EAST, rand, level1, 0);
        this.lightTowerBuild.addTowerDoorways(world, pos, EnumFacing.EAST, rand, level2, 0);
        this.lightTowerBuild.addTowerDoorways(world, pos, EnumFacing.NORTH, rand, level1, 0);
        this.lightTowerBuild.addTowerDoorways(world, pos, EnumFacing.NORTH, rand, level2, 0);
        this.lightTowerBuild.addTowerDoorways(world, pos, EnumFacing.WEST, rand, level1, 0);
        this.lightTowerBuild.addTowerDoorways(world, pos, EnumFacing.WEST, rand, level2, 0);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.SOUTH, rand, level1, 0, false);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.EAST, rand, level2, 0, false);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.NORTH, rand, level3, 0, true);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.EAST, rand, level1, 0, false);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.NORTH, rand, level2, 0, false);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.WEST, rand, level3, 0, true);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.NORTH, rand, level1, 0, false);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.WEST, rand, level2, 0, false);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.SOUTH, rand, level3, 0, true);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.WEST, rand, level1, 0, false);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.SOUTH, rand, level2, 0, false);
        this.lightTowerBuild.buildsSpiralStairPart(world, pos, EnumFacing.EAST, rand, level3, 0, true);
        this.lightTowerBuild.addLightBeams(world, pos, EnumFacing.SOUTH, rand, level1, 0);
        this.lightTowerBuild.addLightBeams(world, pos, EnumFacing.SOUTH, rand, level2, 0);
        this.lightTowerBuild.addLightBeams(world, pos, EnumFacing.SOUTH, rand, level3, 0);
        this.lightTowerBuild.buildsMazeGate(world, pos.func_177982_a(12, 0, 10), EnumFacing.WEST, rand, level1, 0);
    }

    public void generateDecayPit(World world, Random rand, BlockPos pos) {
        for (int xx = -14; xx <= 14; ++xx) {
            for (int zz = -14; zz <= 14; ++zz) {
                for (int yy = 0; yy > -16; --yy) {
                    double dSqDome = Math.pow(xx, 2.0) + Math.pow(zz, 2.0) + Math.pow(yy, 2.0);
                    if (Math.round(Math.sqrt(dSqDome)) >= 15L) continue;
                    BlockPos offsetPos = pos.func_177982_a(xx, yy, zz);
                    this.func_175903_a(world, offsetPos, Blocks.field_150350_a.func_176223_P());
                    this.location.getGuard().setGuarded(world, offsetPos, true);
                }
            }
        }
        this.decayPitBuild.buildMainAreaPart(world, pos.func_177979_c(14), EnumFacing.SOUTH, rand, 0, 0);
        this.decayPitBuild.buildMainAreaPart(world, pos.func_177979_c(14), EnumFacing.EAST, rand, 0, 0);
        this.decayPitBuild.buildMainAreaPart(world, pos.func_177979_c(14), EnumFacing.NORTH, rand, 0, 0);
        this.decayPitBuild.buildMainAreaPart(world, pos.func_177979_c(14), EnumFacing.WEST, rand, 0, 0);
        this.decayPitBuild.addSpikes(world, pos.func_177979_c(14), EnumFacing.SOUTH, rand, 0, 0);
        this.decayPitBuild.addSpikes(world, pos.func_177979_c(14), EnumFacing.EAST, rand, 0, 0);
        this.decayPitBuild.addSpikes(world, pos.func_177979_c(14), EnumFacing.NORTH, rand, 0, 0);
        this.decayPitBuild.addSpikes(world, pos.func_177979_c(14), EnumFacing.WEST, rand, 0, 0);
        this.func_175903_a(world, pos.func_177979_c(14), BlockRegistry.DECAY_PIT_CONTROL.func_176223_P());
        this.func_175903_a(world, pos.func_177981_b(1), BlockRegistry.DECAY_PIT_HANGING_CHAIN.func_176223_P());
        for (int y = 0; y < 7; ++y) {
            this.addGroundPlants(world, pos.func_177979_c(11).func_177982_a(-11, y, -11), rand, 22, 0, 22, false, false, true, false);
            this.addEdgePlant(world, pos.func_177979_c(11).func_177982_a(-11, y, -11), rand, 22, 0, 22);
        }
        this.addHangingPlants(world, pos.func_177982_a(-11, 1, -11), rand, 22, 0, 22);
        this.func_175903_a(world, pos.func_177963_a(0.0, -4.0, -12.0), BlockRegistry.DECAY_PIT_GROUND_CHAIN.func_176223_P().func_177226_a((IProperty)BlockDecayPitGroundChain.field_185512_D, (Comparable)EnumFacing.SOUTH));
        this.func_175903_a(world, pos.func_177982_a(12, -4, 0), BlockRegistry.DECAY_PIT_GROUND_CHAIN.func_176223_P().func_177226_a((IProperty)BlockDecayPitGroundChain.field_185512_D, (Comparable)EnumFacing.WEST));
        this.func_175903_a(world, pos.func_177982_a(0, -4, 12), BlockRegistry.DECAY_PIT_GROUND_CHAIN.func_176223_P().func_177226_a((IProperty)BlockDecayPitGroundChain.field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_175903_a(world, pos.func_177982_a(-12, -4, 0), BlockRegistry.DECAY_PIT_GROUND_CHAIN.func_176223_P().func_177226_a((IProperty)BlockDecayPitGroundChain.field_185512_D, (Comparable)EnumFacing.EAST));
        EntityDecayPitTarget target = new EntityDecayPitTarget(world);
        target.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177979_c(6).func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        world.func_72838_d((Entity)target);
    }

    public void generateDecayPitEntrance(World world, Random rand, BlockPos pos) {
        this.lightTowerBuild.buildPitEntrance(world, pos, EnumFacing.EAST, rand, 0, 0);
    }

    public void makeMaze(World world, Random rand, BlockPos pos) {
        for (int level = 0; level <= 7; ++level) {
            int yy = -6 - level * 6;
            if (level == 7) {
                this.buildRoof(world, pos.func_177982_a(0, yy - 3, 0).func_177981_b(8), rand, 7, 7, level);
            }
            if (level < 7 && level >= 0) {
                this.generateMaze(world, rand, pos.func_177982_a(0, yy, 0), level);
            }
            if (level > 7) continue;
            if (level == 1 || level == 3 || level == 5 || level == 7) {
                this.func_175903_a(world, pos.func_177982_a(1, yy + 5, 0), this.blockHelper.MUD_BRICKS_CLIMBABLE_SOUTH);
                if (level != 7) {
                    this.func_175903_a(world, pos.func_177982_a(27, yy + 0, 28), this.blockHelper.MUD_BRICKS_CLIMBABLE_NORTH);
                    this.func_175903_a(world, pos.func_177982_a(27, yy + 1, 28), this.blockHelper.MUD_BRICKS_CLIMBABLE_NORTH);
                    this.func_175903_a(world, pos.func_177982_a(27, yy + 2, 28), this.blockHelper.MUD_BRICKS_CLIMBABLE_NORTH);
                    this.func_175903_a(world, pos.func_177982_a(27, yy + 3, 28), this.blockHelper.MUD_BRICKS_CLIMBABLE_NORTH);
                    this.func_175903_a(world, pos.func_177982_a(27, yy + 4, 28), this.blockHelper.MUD_BRICKS_CLIMBABLE_NORTH);
                }
                this.func_175903_a(world, pos.func_177982_a(1, yy + 1, 1), this.getMudBricksForLevel(rand, level, 1));
                this.func_175903_a(world, pos.func_177982_a(1, yy + 2, 1), this.getMudBricksForLevel(rand, level, 2));
                this.func_175903_a(world, pos.func_177982_a(1, yy + 3, 1), this.getMudBricksForLevel(rand, level, 3));
                this.func_175903_a(world, pos.func_177982_a(1, yy + 4, 1), this.getStairsForLevel(rand, level, EnumFacing.NORTH, BlockStairs.EnumHalf.BOTTOM));
                if (world.func_175623_d(pos.func_177982_a(1, yy + 1, 2))) {
                    this.func_175903_a(world, pos.func_177982_a(1, yy + 1, 2), this.getMudBricksForLevel(rand, level, 1));
                }
                this.placeRuneCombination(world, pos.func_177982_a(0, yy + 2, 0), level, rand);
                this.func_175903_a(world, pos.func_177982_a(1, yy + 3, 2), this.getStairsForLevel(rand, level, EnumFacing.NORTH, BlockStairs.EnumHalf.BOTTOM));
                this.func_175903_a(world, pos.func_177982_a(1, yy + 2, 3), this.getStairsForLevel(rand, level, EnumFacing.WEST, BlockStairs.EnumHalf.BOTTOM));
                this.func_175903_a(world, pos.func_177982_a(1, yy + 1, 3), this.getMudBricksForLevel(rand, level, 1));
                this.func_175903_a(world, pos.func_177982_a(2, yy + 1, 3), this.getStairsForLevel(rand, level, EnumFacing.WEST, BlockStairs.EnumHalf.BOTTOM));
            } else {
                this.func_175903_a(world, pos.func_177982_a(27, yy + 5, 28), this.blockHelper.MUD_BRICKS_CLIMBABLE_NORTH);
                this.func_175903_a(world, pos.func_177982_a(1, yy + 0, 0), this.blockHelper.MUD_BRICKS_CLIMBABLE_SOUTH);
                this.func_175903_a(world, pos.func_177982_a(1, yy + 1, 0), this.blockHelper.MUD_BRICKS_CLIMBABLE_SOUTH);
                this.func_175903_a(world, pos.func_177982_a(1, yy + 2, 0), this.blockHelper.MUD_BRICKS_CLIMBABLE_SOUTH);
                this.func_175903_a(world, pos.func_177982_a(1, yy + 3, 0), this.blockHelper.MUD_BRICKS_CLIMBABLE_SOUTH);
                this.func_175903_a(world, pos.func_177982_a(1, yy + 4, 0), this.blockHelper.MUD_BRICKS_CLIMBABLE_SOUTH);
                this.func_175903_a(world, pos.func_177982_a(27, yy + 1, 27), this.getMudBricksForLevel(rand, level, 1));
                this.func_175903_a(world, pos.func_177982_a(27, yy + 2, 27), this.getMudBricksForLevel(rand, level, 2));
                this.func_175903_a(world, pos.func_177982_a(27, yy + 3, 27), this.getMudBricksForLevel(rand, level, 3));
                this.func_175903_a(world, pos.func_177982_a(27, yy + 4, 27), this.getStairsForLevel(rand, level, EnumFacing.SOUTH, BlockStairs.EnumHalf.BOTTOM));
                if (world.func_175623_d(pos.func_177982_a(27, yy + 1, 26))) {
                    this.func_175903_a(world, pos.func_177982_a(27, yy + 1, 26), this.getMudBricksForLevel(rand, level, 1));
                }
                this.placeRuneCombination(world, pos.func_177982_a(0, yy + 2, 0), level, rand);
                this.func_175903_a(world, pos.func_177982_a(27, yy + 3, 26), this.getStairsForLevel(rand, level, EnumFacing.SOUTH, BlockStairs.EnumHalf.BOTTOM));
                this.func_175903_a(world, pos.func_177982_a(27, yy + 2, 25), this.getStairsForLevel(rand, level, EnumFacing.EAST, BlockStairs.EnumHalf.BOTTOM));
                this.func_175903_a(world, pos.func_177982_a(27, yy + 1, 25), this.getMudBricksForLevel(rand, level, 1));
                this.func_175903_a(world, pos.func_177982_a(26, yy + 1, 25), this.getStairsForLevel(rand, level, EnumFacing.EAST, BlockStairs.EnumHalf.BOTTOM));
            }
            if (level != 7) {
                this.addCeilingSlabs(world, pos.func_177982_a(0, yy + 4, 0), 7, 7, rand, level);
            }
            this.stairsAir(world, rand, pos.func_177982_a(0, yy, 0), level);
            this.addHangingPlants(world, pos.func_177982_a(1, yy + 5, 1), rand, 28, 0, 28);
            this.addEdgePlant(world, pos.func_177982_a(1, yy, 1), rand, 28, 0, 28);
        }
    }

    public void generateMaze(World world, Random rand, BlockPos pos, int level) {
        int sizeY = 6;
        int mazeWidth = 7;
        int mazeHeight = 7;
        int[][] maze = null;
        PerfectMazeGenerator generator = new PerfectMazeGenerator(mazeWidth, mazeHeight);
        maze = generator.generateMaze();
        block8: for (int layer = 0; layer < sizeY; ++layer) {
            switch (layer) {
                case 0: {
                    continue block8;
                }
                case 1: {
                    this.buildLevel(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                    this.createAir(world, pos.func_177982_a(0, layer, 0), rand, mazeWidth, mazeHeight, level);
                    this.addFeature(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                    continue block8;
                }
                case 2: {
                    this.buildLevel(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                    this.addFeature(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                    continue block8;
                }
                case 3: {
                    this.buildLevel(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                    this.addFeature(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                    continue block8;
                }
                case 4: {
                    this.buildLevel(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                    this.addFeature(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                    continue block8;
                }
                case 5: {
                    this.buildRoof(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, level);
                    this.addMazeCellFeature(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                    this.buildFloor(world, pos, rand, mazeWidth, mazeHeight, true, false, level);
                    this.addFeature(world, pos.func_177981_b(layer), rand, mazeWidth, mazeHeight, maze, level, layer);
                }
            }
        }
    }

    private void buildLevel(World world, BlockPos pos, Random rand, int w, int h, int[][] maze, int level, int layer) {
        for (int i = 0; i < h; ++i) {
            int j;
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 1) == 0) {
                    this.func_175903_a(world, pos.func_177982_a(j * 4, 0, i * 4), layer == 1 || layer == 2 || layer == 3 ? this.getPillarsForLevel(rand, level, layer) : this.getMudBricksForLevel(rand, level, layer));
                    this.func_175903_a(world, pos.func_177982_a(j * 4 + 1, 0, i * 4), this.getMudBricksForLevel(rand, level, layer));
                    this.func_175903_a(world, pos.func_177982_a(j * 4 + 2, 0, i * 4), this.getMudBricksForLevel(rand, level, layer));
                    this.func_175903_a(world, pos.func_177982_a(j * 4 + 3, 0, i * 4), this.getMudBricksForLevel(rand, level, layer));
                    if (layer == 3) {
                        this.addBeamSupports(world, pos.func_177982_a(j * 4, 0, i * 4), rand, pos);
                    }
                    if (layer != 4) continue;
                    this.addBeams(world, pos.func_177982_a(j * 4, 0, i * 4), rand, level, pos);
                    continue;
                }
                this.func_175903_a(world, pos.func_177982_a(j * 4, 0, i * 4), this.getMudBricksForLevel(rand, level, layer));
            }
            for (j = 0; j < w; ++j) {
                if ((maze[j][i] & 8) == 0) {
                    this.func_175903_a(world, pos.func_177982_a(j * 4, 0, i * 4), layer == 1 || layer == 2 || layer == 3 ? this.getPillarsForLevel(rand, level, layer) : this.getMudBricksForLevel(rand, level, layer));
                    this.func_175903_a(world, pos.func_177982_a(j * 4, 0, i * 4 + 1), this.getMudBricksForLevel(rand, level, layer));
                    this.func_175903_a(world, pos.func_177982_a(j * 4, 0, i * 4 + 2), this.getMudBricksForLevel(rand, level, layer));
                    this.func_175903_a(world, pos.func_177982_a(j * 4, 0, i * 4 + 3), this.getMudBricksForLevel(rand, level, layer));
                    if (layer == 3) {
                        this.addBeamSupports(world, pos.func_177982_a(j * 4, 0, i * 4), rand, pos);
                    }
                    if (layer == 4) {
                        this.addBeams(world, pos.func_177982_a(j * 4, 0, i * 4), rand, level, pos);
                    }
                }
                if ((maze[j][i] & 4) == 0) {
                    this.func_175903_a(world, pos.func_177982_a(j * 4, 0, i * 4), layer == 1 || layer == 2 || layer == 3 ? this.getPillarsForLevel(rand, level, layer) : this.getMudBricksForLevel(rand, level, layer));
                    if (layer == 3) {
                        this.addBeamSupports(world, pos.func_177982_a(j * 4, 0, i * 4), rand, pos);
                    }
                    if (layer == 4) {
                        this.addBeams(world, pos.func_177982_a(j * 4, 0, i * 4), rand, level, pos);
                    }
                }
                if ((maze[j][i] & 2) == 0) {
                    this.func_175903_a(world, pos.func_177982_a(j * 4, 0, i * 4), layer == 1 || layer == 2 || layer == 3 ? this.getPillarsForLevel(rand, level, layer) : this.getMudBricksForLevel(rand, level, layer));
                    if (layer == 3) {
                        this.addBeamSupports(world, pos.func_177982_a(j * 4, 0, i * 4), rand, pos);
                    }
                    if (layer == 4) {
                        this.addBeams(world, pos.func_177982_a(j * 4, 0, i * 4), rand, level, pos);
                    }
                }
                this.func_175903_a(world, pos.func_177982_a(w * 4, 0, i * 4), layer == 1 || layer == 2 || layer == 3 ? this.getPillarsForLevel(rand, level, layer) : this.getMudBricksForLevel(rand, level, layer));
                this.func_175903_a(world, pos.func_177982_a(w * 4, 0, i * 4 + 1), this.getMudBricksForLevel(rand, level, layer));
                this.func_175903_a(world, pos.func_177982_a(w * 4, 0, i * 4 + 2), this.getMudBricksForLevel(rand, level, layer));
                this.func_175903_a(world, pos.func_177982_a(w * 4, 0, i * 4 + 3), this.getMudBricksForLevel(rand, level, layer));
                if (layer == 3) {
                    this.addBeamSupports(world, pos.func_177982_a(w * 4, 0, i * 4), rand, pos);
                }
                if (layer != 4) continue;
                this.addBeams(world, pos.func_177982_a(w * 4, 0, i * 4), rand, level, pos);
            }
        }
        for (int j = 0; j <= w * 4; ++j) {
            this.func_175903_a(world, pos.func_177982_a(j, 0, h * 4), j % 4 == 0 && (layer == 1 || layer == 2 || layer == 3) ? this.getPillarsForLevel(rand, level, layer) : this.getMudBricksForLevel(rand, level, layer));
            if (layer == 3 && j % 4 == 0) {
                this.addBeamSupports(world, pos.func_177982_a(j, 0, h * 4), rand, pos);
            }
            if (layer != 4 || j % 4 != 0) continue;
            this.addBeams(world, pos.func_177982_a(j, 0, h * 4), rand, level, pos);
        }
    }

    private void addBeamSupports(World world, BlockPos pos, Random rand, BlockPos posOrigin) {
        EnumFacing[] sides;
        for (EnumFacing facing : sides = EnumFacing.field_176754_o) {
            if (this.isSolidStructureBlock(world.func_180495_p(pos.func_177972_a(facing))) || !world.func_175623_d(pos.func_177972_a(facing)) || !this.isWithinMazeAreaForGen(posOrigin, pos.func_177972_a(facing))) continue;
            this.func_175903_a(world, pos.func_177972_a(facing), this.getRandomSupportBeam(facing, true, rand));
        }
    }

    private void addBeams(World world, BlockPos pos, Random rand, int level, BlockPos posOrigin) {
        EnumFacing[] sides;
        for (EnumFacing facing : sides = EnumFacing.field_176754_o) {
            for (int count = 1; count <= 2; ++count) {
                if (this.isSolidStructureBlock(world.func_180495_p(pos.func_177967_a(facing, count))) || !world.func_175623_d(pos.func_177967_a(facing, count)) || !this.isWithinMazeAreaForGen(posOrigin, pos.func_177967_a(facing, count))) continue;
                this.func_175903_a(world, pos.func_177967_a(facing, count), this.getRandomBeam(facing.func_176746_e(), rand, level, count, false));
            }
            if (!this.isWithinMazeAreaForGen(posOrigin, pos.func_177967_a(facing, 3))) continue;
            if (level >= 5 && rand.nextInt(level == 5 ? 30 : 25) == 0) {
                this.addFallingBlockEntity(world, pos.func_177967_a(facing, 1));
            }
            if (level >= 5 && rand.nextInt(level == 5 ? 30 : 25) == 0) {
                this.addFallingBlockEntity(world, pos.func_177967_a(facing, 2));
            }
            if (level < 5 || rand.nextInt(level == 5 ? 30 : 25) != 0) continue;
            this.addFallingBlockEntity(world, pos.func_177967_a(facing, 3));
        }
    }

    private void addFallingBlockEntity(World world, BlockPos pos) {
        EntityTriggeredFallingBlock falling_block = new EntityTriggeredFallingBlock(world);
        falling_block.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        world.func_72838_d((Entity)falling_block);
    }

    private void addHangingBlockEntity(World world, BlockPos pos) {
        EntityTriggeredFallingBlock falling_block = new EntityTriggeredFallingBlock(world);
        falling_block.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        falling_block.setHanging(true);
        world.func_72838_d((Entity)falling_block);
    }

    private void addCCGroundSpawnerEntity(World world, BlockPos pos) {
        EntityCCGroundSpawner ground_spawner = new EntityCCGroundSpawner(world);
        ground_spawner.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        ground_spawner.setIsWorldSpawned(false);
        world.func_72838_d((Entity)ground_spawner);
    }

    private void addCeilingSlabs(World world, BlockPos pos, int w, int h, Random rand, int level) {
        for (int i = 0; i <= h * 4; ++i) {
            for (int j = 0; j <= w * 4; ++j) {
                if (j % 4 == 0 || i % 4 == 0 || !world.func_175623_d(pos.func_177982_a(j, 0, i)) || this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(j, 0, i)))) continue;
                if (level == 0) {
                    this.func_175903_a(world, pos.func_177982_a(j, 0, i), this.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
                }
                if (level == 0 || rand.nextInt(level) != 0) continue;
                this.func_175903_a(world, pos.func_177982_a(j, 0, i), this.getMudSlabsForLevel(rand, level, BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
            }
        }
    }

    private void addMazeCellFeature(World world, BlockPos pos, Random rand, int w, int h, int[][] maze, int level, int layer) {
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                if (!((maze[j][i] & 2) != 0 || (maze[j][i] & 4) != 0 || (maze[j][i] & 8) != 0 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) || this.isBlackListedForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), level == 3) || this.isBlackListedForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), level == 5) || this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(2 + j * 4, -4, 3 + i * 4))))) {
                    this.microBuild.selectFeature(world, pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), EnumFacing.NORTH, rand, level, layer);
                }
                if (!((maze[j][i] & 1) != 0 || (maze[j][i] & 4) != 0 || (maze[j][i] & 8) != 0 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) || this.isBlackListedForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), level == 3) || this.isBlackListedForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), level == 5) || this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(2 + j * 4, -4, 1 + i * 4))))) {
                    this.microBuild.selectFeature(world, pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), EnumFacing.SOUTH, rand, level, layer);
                }
                if (!((maze[j][i] & 1) != 0 || (maze[j][i] & 2) != 0 || (maze[j][i] & 4) != 0 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) || this.isBlackListedForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), level == 3) || this.isBlackListedForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), level == 5) || this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(3 + j * 4, -4, 2 + i * 4))))) {
                    this.microBuild.selectFeature(world, pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), EnumFacing.WEST, rand, level, layer);
                }
                if (!((maze[j][i] & 1) != 0 || (maze[j][i] & 2) != 0 || (maze[j][i] & 8) != 0 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) || this.isBlackListedForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), level == 3) || this.isBlackListedForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), level == 5) || this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(1 + j * 4, -4, 2 + i * 4))))) {
                    this.microBuild.selectFeature(world, pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), EnumFacing.EAST, rand, level, layer);
                }
                if (level == 2) {
                    if ((maze[j][i] & 1) == 0 && (maze[j][i] & 2) == 0 && (maze[j][i] & 4) != 0 && (maze[j][i] & 8) != 0 && !this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) && !this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4))) {
                        this.microBuild.spikeFeature(world, pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), EnumFacing.WEST, rand, level, layer);
                    }
                    if ((maze[j][i] & 1) != 0 && (maze[j][i] & 2) != 0 && (maze[j][i] & 4) == 0 && (maze[j][i] & 8) == 0 && !this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) && !this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4))) {
                        this.microBuild.spikeFeature(world, pos.func_177982_a(2 + j * 4, -4, 2 + i * 4), EnumFacing.NORTH, rand, level, layer);
                    }
                }
                if (level != 6) continue;
                if ((maze[j][i] & 1) == 0 && (maze[j][i] & 2) == 0 && (maze[j][i] & 4) != 0 && (maze[j][i] & 8) != 0 && !this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) && !this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4))) {
                    this.spawnMovingWall(world, pos.func_177982_a(2 + j * 4, -3, 2 + i * 4));
                }
                if ((maze[j][i] & 1) == 0 || (maze[j][i] & 2) == 0 || (maze[j][i] & 4) != 0 || (maze[j][i] & 8) != 0 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -4, 2 + i * 4))) continue;
                this.spawnMovingWall(world, pos.func_177982_a(2 + j * 4, -3, 2 + i * 4));
            }
        }
    }

    private void spawnMovingWall(World world, BlockPos pos) {
        EntityMovingWall wall = new EntityMovingWall(world, true);
        wall.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        world.func_72838_d((Entity)wall);
    }

    private boolean isBlackListedForGen(BlockPos pos, BlockPos posIn) {
        return posIn.func_177958_n() == pos.func_177958_n() && posIn.func_177952_p() == pos.func_177952_p();
    }

    private boolean isBlackListedForGenSpecial(BlockPos pos, BlockPos posIn, boolean crapCheck) {
        return posIn.func_177958_n() == pos.func_177958_n() && posIn.func_177952_p() == pos.func_177952_p() && crapCheck;
    }

    private boolean isBlackListedAreaForGen(BlockPos pos, BlockPos posIn, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (posIn.func_177958_n() != pos.func_177982_a(x, 0, z).func_177958_n() || posIn.func_177952_p() != pos.func_177982_a(x, 0, z).func_177952_p()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBlackListedAreaForGenSpecial(BlockPos pos, BlockPos posIn, int radius, boolean crapCheck) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (posIn.func_177958_n() != pos.func_177982_a(x, 0, z).func_177958_n() || posIn.func_177952_p() != pos.func_177982_a(x, 0, z).func_177952_p() || !crapCheck) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isWithinMazeAreaForGen(BlockPos posOrigin, BlockPos posIn) {
        for (int x = 0; x <= 28; ++x) {
            for (int z = 0; z <= 28; ++z) {
                if (posIn.func_177958_n() != posOrigin.func_177982_a(x, 0, z).func_177958_n() || posIn.func_177952_p() != posOrigin.func_177982_a(x, 0, z).func_177952_p()) continue;
                return true;
            }
        }
        return false;
    }

    private void addFeature(World world, BlockPos pos, Random rand, int w, int h, int[][] maze, int level, int layer) {
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                if ((maze[j][i] & 1) == 0) {
                    if (!(layer != 2 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4)) || this.isBlackListedForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4), level == 3) || this.isBlackListedForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4), level == 5))) {
                        if (rand.nextInt(25) == 0 && !this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(2 + j * 4, 0, 1 + i * 4))) && world.func_180495_p(pos.func_177982_a(2 + j * 4, 0, i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                            this.func_175903_a(world, pos.func_177982_a(2 + j * 4, 0, 1 + i * 4), this.blockHelper.DUNGEON_WALL_CANDLE_SOUTH);
                        } else {
                            if (rand.nextInt(5) == 0 && level != 2 && world.func_180495_p(pos.func_177982_a(2 + j * 4, 0, i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                                this.setAlcoveForLevel(world, pos.func_177982_a(2 + j * 4, 0, i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_SOUTH, rand, level);
                            }
                            if (rand.nextInt(5) == 0 && world.func_180495_p(pos.func_177982_a(1 + j * 4, 0, i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                                this.setAlcoveForLevel(world, pos.func_177982_a(1 + j * 4, 0, i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_SOUTH, rand, level);
                            }
                            if (rand.nextInt(5) == 0 && world.func_180495_p(pos.func_177982_a(3 + j * 4, 0, i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                                this.setAlcoveForLevel(world, pos.func_177982_a(3 + j * 4, 0, i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_SOUTH, rand, level);
                            }
                        }
                    }
                    if (layer == 4) {
                        if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(1 + j * 4, 0, 1 + i * 4)))) {
                            this.func_175903_a(world, pos.func_177982_a(1 + j * 4, 0, 1 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.NORTH, BlockStairs.EnumHalf.TOP));
                        }
                        if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(2 + j * 4, 0, 1 + i * 4)))) {
                            this.func_175903_a(world, pos.func_177982_a(2 + j * 4, 0, 1 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.NORTH, BlockStairs.EnumHalf.TOP));
                        }
                        if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(3 + j * 4, 0, 1 + i * 4)))) {
                            this.func_175903_a(world, pos.func_177982_a(3 + j * 4, 0, 1 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.NORTH, BlockStairs.EnumHalf.TOP));
                        }
                    }
                    if (!(layer != 5 || rand.nextInt(3) != 0 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -6, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -6, 2 + i * 4)) || this.isBlackListedForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(2 + j * 4, -6, 2 + i * 4), level == 3) || this.isBlackListedForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(2 + j * 4, -6, 2 + i * 4), level == 5) || !world.func_175623_d(pos.func_177982_a(1 + j * 4, -4, 1 + rand.nextInt(2) + i * 4)))) {
                        this.setRandomRoot(world, pos.func_177982_a(1 + j * 4, -4, 1 + rand.nextInt(2) + i * 4), rand);
                    }
                }
                if ((maze[j][i] & 8) == 0) {
                    if (!(layer != 2 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4)) || this.isBlackListedForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4), level == 3) || this.isBlackListedForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4), level == 5))) {
                        if (rand.nextInt(25) == 0 && !this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(1 + j * 4, 0, 2 + i * 4))) && world.func_180495_p(pos.func_177982_a(j * 4, 0, 2 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                            this.func_175903_a(world, pos.func_177982_a(1 + j * 4, 0, 2 + i * 4), this.blockHelper.DUNGEON_WALL_CANDLE_EAST);
                        } else {
                            if (rand.nextInt(5) == 0 && level != 2 && world.func_180495_p(pos.func_177982_a(j * 4, 0, 2 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                                this.setAlcoveForLevel(world, pos.func_177982_a(j * 4, 0, 2 + i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_EAST, rand, level);
                            }
                            if (rand.nextInt(5) == 0 && world.func_180495_p(pos.func_177982_a(j * 4, 0, 1 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                                this.setAlcoveForLevel(world, pos.func_177982_a(j * 4, 0, 1 + i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_EAST, rand, level);
                            }
                            if (rand.nextInt(5) == 0 && world.func_180495_p(pos.func_177982_a(j * 4, 0, 3 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                                this.setAlcoveForLevel(world, pos.func_177982_a(j * 4, 0, 3 + i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_EAST, rand, level);
                            }
                        }
                    }
                    if (layer == 4) {
                        if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(1 + j * 4, 0, 1 + i * 4)))) {
                            this.func_175903_a(world, pos.func_177982_a(1 + j * 4, 0, 1 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.WEST, BlockStairs.EnumHalf.TOP));
                        }
                        if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(1 + j * 4, 0, 2 + i * 4)))) {
                            this.func_175903_a(world, pos.func_177982_a(1 + j * 4, 0, 2 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.WEST, BlockStairs.EnumHalf.TOP));
                        }
                        if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(1 + j * 4, 0, 3 + i * 4)))) {
                            this.func_175903_a(world, pos.func_177982_a(1 + j * 4, 0, 3 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.WEST, BlockStairs.EnumHalf.TOP));
                        }
                    }
                }
                if ((maze[j][i] & 4) == 0) {
                    if (!(layer != 2 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4)) || this.isBlackListedForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4), level == 3) || this.isBlackListedForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4), level == 5))) {
                        if (rand.nextInt(25) == 0 && !this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(3 + j * 4, 0, 2 + i * 4))) && world.func_180495_p(pos.func_177982_a(4 + j * 4, 0, 2 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                            this.func_175903_a(world, pos.func_177982_a(3 + j * 4, 0, 2 + i * 4), this.blockHelper.DUNGEON_WALL_CANDLE_WEST);
                        } else {
                            if (rand.nextInt(5) == 0 && level != 2 && world.func_180495_p(pos.func_177982_a(4 + j * 4, 0, 2 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                                this.setAlcoveForLevel(world, pos.func_177982_a(4 + j * 4, 0, 2 + i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_WEST, rand, level);
                            }
                            if (rand.nextInt(5) == 0 && world.func_180495_p(pos.func_177982_a(4 + j * 4, 0, 1 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                                this.setAlcoveForLevel(world, pos.func_177982_a(4 + j * 4, 0, 1 + i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_WEST, rand, level);
                            }
                            if (rand.nextInt(5) == 0 && world.func_180495_p(pos.func_177982_a(4 + j * 4, 0, 3 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                                this.setAlcoveForLevel(world, pos.func_177982_a(4 + j * 4, 0, 3 + i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_WEST, rand, level);
                            }
                        }
                    }
                    if (layer == 4) {
                        if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(3 + j * 4, 0, 1 + i * 4)))) {
                            this.func_175903_a(world, pos.func_177982_a(3 + j * 4, 0, 1 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.EAST, BlockStairs.EnumHalf.TOP));
                        }
                        if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(3 + j * 4, 0, 2 + i * 4)))) {
                            this.func_175903_a(world, pos.func_177982_a(3 + j * 4, 0, 2 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.EAST, BlockStairs.EnumHalf.TOP));
                        }
                        if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(3 + j * 4, 0, 3 + i * 4)))) {
                            this.func_175903_a(world, pos.func_177982_a(3 + j * 4, 0, 3 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.EAST, BlockStairs.EnumHalf.TOP));
                        }
                    }
                }
                if ((maze[j][i] & 2) != 0) continue;
                if (!(layer != 2 || this.isBlackListedForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4)) || this.isBlackListedForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4)) || this.isBlackListedForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4), level == 3) || this.isBlackListedForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(2 + j * 4, -3, 2 + i * 4), level == 5))) {
                    if (rand.nextInt(25) == 0 && !this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(2 + j * 4, 0, 3 + i * 4))) && world.func_180495_p(pos.func_177982_a(2 + j * 4, 0, 4 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                        this.func_175903_a(world, pos.func_177982_a(2 + j * 4, 0, 3 + i * 4), this.blockHelper.DUNGEON_WALL_CANDLE_NORTH);
                    } else {
                        if (rand.nextInt(5) == 0 && level != 2 && world.func_180495_p(pos.func_177982_a(2 + j * 4, 0, 4 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                            this.setAlcoveForLevel(world, pos.func_177982_a(2 + j * 4, 0, 4 + i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_NORTH, rand, level);
                        }
                        if (rand.nextInt(5) == 0 && world.func_180495_p(pos.func_177982_a(1 + j * 4, 0, 4 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                            this.setAlcoveForLevel(world, pos.func_177982_a(1 + j * 4, 0, 4 + i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_NORTH, rand, level);
                        }
                        if (rand.nextInt(5) == 0 && world.func_180495_p(pos.func_177982_a(3 + j * 4, 0, 4 + i * 4)).func_177230_c() instanceof BlockCarvedMudBrick) {
                            this.setAlcoveForLevel(world, pos.func_177982_a(3 + j * 4, 0, 4 + i * 4), this.blockHelper.MUD_BRICKS_ALCOVE_NORTH, rand, level);
                        }
                    }
                }
                if (layer != 4) continue;
                if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(1 + j * 4, 0, 3 + i * 4)))) {
                    this.func_175903_a(world, pos.func_177982_a(1 + j * 4, 0, 3 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.SOUTH, BlockStairs.EnumHalf.TOP));
                }
                if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(2 + j * 4, 0, 3 + i * 4)))) {
                    this.func_175903_a(world, pos.func_177982_a(2 + j * 4, 0, 3 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.SOUTH, BlockStairs.EnumHalf.TOP));
                }
                if (this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(3 + j * 4, 0, 3 + i * 4)))) continue;
                this.func_175903_a(world, pos.func_177982_a(3 + j * 4, 0, 3 + i * 4), this.getStairsForLevel(rand, level, EnumFacing.SOUTH, BlockStairs.EnumHalf.TOP));
            }
        }
    }

    private void placeRuneCombination(World world, BlockPos pos, int level, Random rand) {
        if (level <= 6) {
            if (level == 1 || level == 3 || level == 5) {
                int y;
                this.func_175903_a(world, pos.func_177982_a(1, 0, 2), this.blockHelper.DUNGEON_DOOR_COMBINATION_EAST);
                this.func_175903_a(world, pos.func_177982_a(27, 0, 26), this.blockHelper.DUNGEON_DOOR_WEST);
                this.setRandomCombinations(world, pos.func_177982_a(1, 0, 2), pos.func_177982_a(27, 0, 26), rand, false);
                if (level == 3) {
                    this.func_175903_a(world, pos.func_177982_a(26, 0, 1), this.blockHelper.DUNGEON_DOOR_MIMIC_SOUTH);
                    this.setRandomCombinations(world, pos.func_177982_a(1, 0, 2), pos.func_177982_a(26, 0, 1), rand, true);
                    for (int x = -1; x <= 1; ++x) {
                        for (y = -1; y <= 1; ++y) {
                            this.func_175903_a(world, pos.func_177982_a(26 + x, y, 0), Blocks.field_150350_a.func_176223_P());
                        }
                    }
                    this.microBuild.addBarrisheeCubby(world, pos.func_177982_a(20, -2, -3), EnumFacing.SOUTH, rand, level);
                }
                if (level == 5) {
                    this.func_175903_a(world, pos.func_177982_a(1, 0, 26), this.blockHelper.DUNGEON_DOOR_CRAWLER_EAST);
                    this.setRandomCombinations(world, pos.func_177982_a(1, 0, 2), pos.func_177982_a(1, 0, 26), rand, true);
                    for (int z = -1; z <= 1; ++z) {
                        for (y = -1; y <= 1; ++y) {
                            this.func_175903_a(world, pos.func_177982_a(0, y, 26 + z), Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
            } else {
                this.func_175903_a(world, pos.func_177982_a(27, 0, 26), this.blockHelper.DUNGEON_DOOR_COMBINATION_WEST);
                this.func_175903_a(world, pos.func_177982_a(1, 0, 2), this.blockHelper.DUNGEON_DOOR_EAST);
                this.setRandomCombinations(world, pos.func_177982_a(27, 0, 26), pos.func_177982_a(1, 0, 2), rand, false);
            }
        }
        if (level == 7) {
            this.func_175903_a(world, pos.func_177982_a(1, 0, 2), this.getMudBricksForLevel(rand, level, 2));
        }
    }

    public void setRandomCombinations(World world, BlockPos codePos, BlockPos lockPos, Random rand, boolean isMimic) {
        IBlockState codeState = world.func_180495_p(codePos);
        IBlockState lockState = world.func_180495_p(lockPos);
        TileEntityDungeonDoorCombination tileCode = (TileEntityDungeonDoorCombination)world.func_175625_s(codePos);
        if (tileCode instanceof TileEntityDungeonDoorCombination) {
            TileEntityDungeonDoorRunes tileLock;
            if (!isMimic) {
                tileCode.top_code = world.field_73012_v.nextInt(8);
                tileCode.mid_code = world.field_73012_v.nextInt(8);
                tileCode.bottom_code = world.field_73012_v.nextInt(8);
            }
            if ((tileLock = (TileEntityDungeonDoorRunes)world.func_175625_s(lockPos)) instanceof TileEntityDungeonDoorRunes) {
                tileLock.top_code = tileCode.top_code;
                tileLock.mid_code = tileCode.mid_code;
                tileLock.bottom_code = tileCode.bottom_code;
                tileLock.is_in_dungeon = true;
            }
        }
        world.func_184138_a(codePos, codeState, codeState, 3);
        world.func_184138_a(lockPos, lockState, lockState, 3);
    }

    private void stairsAir(World world, Random rand, BlockPos pos, int level) {
        if (level == 1 || level == 3 || level == 5 || level == 7) {
            this.func_175903_a(world, pos.func_177982_a(1, 5, 1), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(1, 5, 2), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(1, 5, 3), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(1, 4, 2), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(1, 4, 3), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(1, 3, 3), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(2, 4, 3), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(2, 3, 3), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(1, 6, 1), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(1, 6, 2), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(1, 6, 3), Blocks.field_150350_a.func_176223_P());
        } else if (level == 0 || level == 2 || level == 4 || level == 6) {
            this.func_175903_a(world, pos.func_177982_a(27, 5, 27), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(27, 5, 26), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(27, 5, 25), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(27, 4, 26), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(27, 4, 25), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(27, 3, 25), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(26, 4, 25), Blocks.field_150350_a.func_176223_P());
            this.func_175903_a(world, pos.func_177982_a(26, 3, 25), Blocks.field_150350_a.func_176223_P());
            if (level != 0) {
                this.func_175903_a(world, pos.func_177982_a(27, 6, 27), Blocks.field_150350_a.func_176223_P());
                this.func_175903_a(world, pos.func_177982_a(27, 6, 26), Blocks.field_150350_a.func_176223_P());
                this.func_175903_a(world, pos.func_177982_a(27, 6, 25), Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    private void createAir(World world, BlockPos pos, Random rand, int w, int h, int level) {
        for (int i = 0; i < h * 4; ++i) {
            for (int j = 0; j < w * 4; ++j) {
                for (int k = 0; k <= 3; ++k) {
                    if (this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(j, k, i)))) continue;
                    this.func_175903_a(world, pos.func_177982_a(j, k, i), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private void buildFloor(World world, BlockPos pos, Random rand, int w, int h, boolean addFeature, boolean addSpawners, int level) {
        for (int i = 0; i <= h * 4; ++i) {
            for (int j = 0; j <= w * 4; ++j) {
                if (!this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(j, 0, i)))) {
                    this.func_175903_a(world, pos.func_177982_a(j, 0, i), this.getTilesForLevel(rand, level));
                }
                if (!(rand.nextInt(15) != 0 || !addFeature || this.isSolidStructureBlock(world.func_180495_p(pos.func_177982_a(j, 1, i))) || !(world.func_180495_p(pos.func_177982_a(j, 0, i)).func_177230_c() instanceof BlockMudTiles) || this.isBlackListedAreaForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(j, 0, i), 1) || this.isBlackListedAreaForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(j, 0, i), 1) || this.isBlackListedAreaForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(j, 0, i), 1, level == 3) || this.isBlackListedAreaForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(j, 0, i), 1, level == 5))) {
                    if (rand.nextBoolean() && rand.nextBoolean()) {
                        this.func_175903_a(world, pos.func_177982_a(j, 0, i), this.blockHelper.getMudTilesWater(rand));
                    } else if (rand.nextBoolean() && rand.nextBoolean() && level >= 4) {
                        this.func_175903_a(world, pos.func_177982_a(j, 0, i), this.blockHelper.PUFFSHROOM);
                    }
                }
                if (!(world.func_180495_p(pos.func_177982_a(j, 0, i)).func_177230_c() instanceof BlockMudTiles) || !world.func_175623_d(pos.func_177982_a(j, 1, i)) || rand.nextInt(15) != 0 || this.isBlackListedAreaForGen(pos.func_177982_a(2, 0, 2), pos.func_177982_a(j, 0, i), 1) || this.isBlackListedAreaForGen(pos.func_177982_a(26, 0, 26), pos.func_177982_a(j, 0, i), 1) || this.isBlackListedAreaForGenSpecial(pos.func_177982_a(26, 0, 2), pos.func_177982_a(j, 0, i), 1, level == 3) || this.isBlackListedAreaForGenSpecial(pos.func_177982_a(2, 0, 26), pos.func_177982_a(j, 0, i), 1, level == 5)) continue;
                this.func_175903_a(world, pos.func_177982_a(j, 1, i), rand.nextBoolean() ? this.getRandomMushroom(rand) : this.getRandomFloorPlant(rand));
            }
        }
    }

    private void buildRoof(World world, BlockPos pos, Random rand, int w, int h, int level) {
        for (int i = 0; i <= h * 4; ++i) {
            for (int j = 0; j <= w * 4; ++j) {
                this.func_175903_a(world, pos.func_177982_a(j, 0, i), this.blockHelper.COMPACTED_MUD);
            }
        }
    }

    public void setAlcoveForLevel(World world, BlockPos pos, IBlockState state, Random rand, int level) {
        this.func_175903_a(world, pos, state);
        TileEntityMudBrickAlcove alcove = (TileEntityMudBrickAlcove)world.func_175625_s(pos);
        if (alcove != null) {
            alcove.setDungeonLevel(level);
        }
    }

    @Nullable
    public IBlockState getMudBricksForLevel(Random rand, int level, int layer) {
        return this.blockHelper.getMudBricksForLevel(rand, level, layer);
    }

    @Nullable
    public IBlockState getPillarsForLevel(Random rand, int level, int layer) {
        return this.blockHelper.getPillarsForLevel(rand, level, layer);
    }

    @Nullable
    public IBlockState getTilesForLevel(Random rand, int level) {
        return this.blockHelper.getTilesForLevel(rand, level);
    }

    @Nullable
    public IBlockState getStairsForLevel(Random rand, int level, EnumFacing facing, BlockStairs.EnumHalf half) {
        return this.blockHelper.getStairsForLevel(rand, level, facing, half);
    }

    @Nullable
    public IBlockState getMudSlabsForLevel(Random rand, int level, BlockSlabBetweenlands.EnumBlockHalfBL half) {
        return this.blockHelper.getMudSlabsForLevel(rand, level, half);
    }

    public IBlockState getRandomMushroom(Random rand) {
        return this.blockHelper.getRandomMushroom(rand);
    }

    public IBlockState getRandomFloorPlant(Random rand) {
        return this.blockHelper.getRandomFloorPlant(rand);
    }

    public IBlockState getRandomHangingPlant(Random rand) {
        return this.blockHelper.getRandomHangingPlant(rand);
    }

    public IBlockState getRandomBeam(EnumFacing facing, Random rand, int level, int count, boolean randomiseLine) {
        return this.blockHelper.getRandomBeam(facing, rand, level, count, randomiseLine);
    }

    public IBlockState getRandomSupportBeam(EnumFacing facing, boolean isTop, Random rand) {
        return this.blockHelper.getRandomSupportBeam(facing, isTop, rand);
    }

    public void setRandomRoot(World world, BlockPos pos, Random rand) {
        this.blockHelper.setRandomRoot(world, pos, rand);
    }

    public boolean isSolidStructureBlock(IBlockState state) {
        return this.blockHelper.STRUCTURE_BLOCKS.get(state) != null;
    }

    protected boolean isProtectedBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return block != Blocks.field_150350_a && block != BlockRegistry.MOB_SPAWNER && block != BlockRegistry.LOOT_POT && block != BlockRegistry.ROOT && !(block instanceof BlockPlant) && !(block instanceof BlockHangingPlant) && block != BlockRegistry.VALONITE_BLOCK && block != BlockRegistry.SYRMORITE_BLOCK && block != BlockRegistry.OCTINE_BLOCK && block != BlockRegistry.WEEDWOOD_CHEST && block != BlockRegistry.POSSESSED_BLOCK && block != BlockRegistry.WEAK_POLISHED_LIMESTONE && block != BlockRegistry.WEAK_BETWEENSTONE_TILES && block != BlockRegistry.WEAK_MOSSY_BETWEENSTONE_TILES && block != BlockRegistry.LOOT_URN && block != BlockRegistry.PUFFSHROOM && block != BlockRegistry.STAGNANT_WATER && block != BlockRegistry.ROPE && block != BlockRegistry.DEAD_MOSS && block != BlockRegistry.DEAD_LICHEN && block != BlockRegistry.MUD_TILES_WATER && block != BlockRegistry.HANGER;
    }

    public void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
        ResourceLocation lootTable;
        if (this.isProtectedBlock(state)) {
            this.location.getGuard().setGuarded(worldIn, pos, true);
        } else {
            this.location.getGuard().setGuarded(worldIn, pos, false);
        }
        super.func_175903_a(worldIn, pos, state);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof ISharedLootContainer && (lootTable = this.getLootTableForBlock(worldIn, pos, state)) != null) {
            ((ISharedLootContainer)tile).setSharedLootTable(this.lootStorage, lootTable, this.lootRng.nextLong());
        }
        if (worldIn instanceof WorldServer && tile instanceof TileEntityItemShelf) {
            lootTable = worldIn.func_184146_ak().func_186521_a(LootTableRegistry.SLUDGE_WORM_DUNGEON_ITEM_SHELF);
            Random random = new Random(this.lootRng.nextLong());
            LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)worldIn);
            List loot = lootTable.func_186462_a(random, lootBuilder.func_186471_a());
            TileEntityLootInventory.fillInventoryRandomly(random, loot, (IInventory)((TileEntityItemShelf)tile));
        }
    }

    @Nullable
    protected ResourceLocation getLootTableForBlock(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == BlockRegistry.LOOT_URN || block == BlockRegistry.MUD_BRICK_ALCOVE) {
            if (this.locationCrypt.isInside((Vec3i)pos)) {
                return LootTableRegistry.SLUDGE_WORM_DUNGEON_CRYPT_URN;
            }
            return LootTableRegistry.SLUDGE_WORM_DUNGEON_URN;
        }
        if (block == BlockRegistry.WEEDWOOD_CHEST) {
            if (this.locationBarrisheeLair.isInside((Vec3i)pos)) {
                return LootTableRegistry.SLUDGE_WORM_DUNGEON_BARRISHEE_CHEST;
            }
            return LootTableRegistry.SLUDGE_WORM_DUNGEON_CHEST;
        }
        return null;
    }
}

