/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBlockReplacementCluster
extends WorldGenerator {
    private final IBlockState blockState;
    private final int offset;
    private final int attempts;
    private Predicate<IBlockState> matcher;
    private boolean inheritProperties;

    public WorldGenBlockReplacementCluster(IBlockState blockState, int offset, int attempts, Predicate<IBlockState> matcher) {
        this.blockState = blockState;
        this.offset = offset;
        this.attempts = attempts;
        this.matcher = matcher;
    }

    public WorldGenBlockReplacementCluster(IBlockState blockState, Predicate<IBlockState> matcher) {
        this(blockState, 8, 128, matcher);
    }

    public WorldGenBlockReplacementCluster setInheritProperties(boolean inherit) {
        this.inheritProperties = inherit;
        return this;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        boolean generated = false;
        IBlockState iblockstate = worldIn.func_180495_p(position);
        while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, position) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, position)) && position.func_177956_o() > 0) {
            position = position.func_177977_b();
            iblockstate = worldIn.func_180495_p(position);
        }
        for (int i = 0; i < this.attempts; ++i) {
            IBlockState state;
            BlockPos blockpos = position.func_177982_a(rand.nextInt(this.offset) - rand.nextInt(this.offset), rand.nextInt(this.offset / 2 + 1) - rand.nextInt(this.offset / 2 + 1), rand.nextInt(this.offset) - rand.nextInt(this.offset));
            if (!worldIn.func_175667_e(blockpos) || !this.matcher.apply((Object)(state = worldIn.func_180495_p(blockpos)))) continue;
            IBlockState setState = this.blockState;
            if (this.inheritProperties) {
                ImmutableMap properties = state.func_177228_b();
                for (Map.Entry property : properties.entrySet()) {
                    IProperty sourceProperty = (IProperty)property.getKey();
                    IProperty targetProperty = setState.func_177230_c().func_176194_O().func_185920_a(sourceProperty.func_177701_a());
                    if (targetProperty == null || sourceProperty.func_177699_b() != targetProperty.func_177699_b()) continue;
                    setState = setState.func_177226_a(targetProperty, (Comparable)property.getValue());
                }
            }
            this.func_175903_a(worldIn, blockpos, setState);
            generated = true;
        }
        return generated;
    }
}

