/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.world.gen.IBlockStateAccessOnly;
import thebetweenlands.common.world.gen.biome.feature.CoarseIslandsFeature;
import thebetweenlands.common.world.gen.feature.WorldGenGiantRoot;

public class MapGenGiantRoots
extends MapGenBase {
    protected CoarseIslandsFeature coarseIslandsFeature = new CoarseIslandsFeature();
    protected List<WorldGenGiantRoot> giantRootGens = new ArrayList<WorldGenGiantRoot>();

    public MapGenGiantRoots(long worldSeed) {
        this.field_75040_a = 5;
        this.coarseIslandsFeature.initializeGenerators(worldSeed, BiomeRegistry.COARSE_ISLANDS);
    }

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
        this.giantRootGens.clear();
        super.func_186125_a(worldIn, x, z, primer);
        for (WorldGenGiantRoot root : this.giantRootGens) {
            root.setGenBounds(new AxisAlignedBB((double)(x * 16), 0.0, (double)(z * 16), (double)(x * 16 + 15), 256.0, (double)(z * 16 + 15)));
            Random rootRand = new Random();
            rootRand.setSeed((long)(root.start.func_177958_n() ^ root.start.func_177956_o() ^ root.start.func_177952_p()) ^ worldIn.func_72905_C());
            root.generate(IBlockStateAccessOnly.from(x, z, primer), x, z, true, rootRand, root.start);
        }
    }

    protected void func_180701_a(World worldIn, int chunkX, int chunkZ, int originalX, int originalZ, ChunkPrimer chunkPrimerIn) {
        int subDivs = 2;
        int step = 16 / subDivs;
        ArrayList<BlockPos> startCandidates = new ArrayList<BlockPos>();
        int inChunkX = 0;
        int inChunkZ = 0;
        for (int xs = 0; xs < subDivs; ++xs) {
            for (int zs = 0; zs < subDivs; ++zs) {
                if (worldIn.func_72959_q().func_180631_a(new BlockPos(chunkX * 16 + inChunkX, 64, chunkZ * 16 + inChunkZ)) == BiomeRegistry.COARSE_ISLANDS && this.field_75038_b.nextInt(28) == 0) {
                    BlockPos candidate = new BlockPos(chunkX * 16 + inChunkX, 114, chunkZ * 16 + inChunkZ);
                    startCandidates.add(candidate);
                }
                inChunkZ += step;
            }
            inChunkX += step;
        }
        Collections.shuffle(startCandidates, this.field_75038_b);
        for (BlockPos startCandidate : startCandidates) {
            BlockPos endCandidate = this.findEndpoint(startCandidate.func_177958_n() >> 4, startCandidate.func_177952_p() >> 4, startCandidate, 2);
            if (endCandidate == null) continue;
            WorldGenGiantRoot gen = new WorldGenGiantRoot(startCandidate, endCandidate, this.field_75038_b.nextInt(11) == 0 ? 35 : 14);
            if (gen.start.func_177951_i((Vec3i)gen.end) >= 3600.0 && this.field_75038_b.nextInt(15) == 0) {
                gen.setMaxWidth(4).setMinWidth(4);
            }
            this.giantRootGens.add(gen);
        }
    }

    @Nullable
    protected BlockPos findEndpoint(int chunkX, int chunkZ, BlockPos start, int chunkRange) {
        ArrayList<BlockPos> endCandidates = new ArrayList<BlockPos>();
        int subDivs = 4;
        int step = 16 / subDivs;
        for (int newChunkX = chunkX - chunkRange; newChunkX <= chunkX + chunkRange; ++newChunkX) {
            for (int newChunkZ = chunkZ - chunkRange; newChunkZ <= chunkZ + chunkRange; ++newChunkZ) {
                int inChunkX = 0;
                int inChunkZ = 0;
                for (int xs = 0; xs < subDivs; ++xs) {
                    for (int zs = 0; zs < subDivs; ++zs) {
                        if (this.field_75038_b.nextInt(100) == 0) {
                            endCandidates.add(new BlockPos(newChunkX * 16 + inChunkX, 114, newChunkZ * 16 + inChunkZ));
                        }
                        inChunkZ += step;
                    }
                    inChunkX += step;
                }
            }
        }
        if (!endCandidates.isEmpty()) {
            Collections.shuffle(endCandidates, this.field_75038_b);
            for (BlockPos endCandidate : endCandidates) {
                if (!(endCandidate.func_177951_i((Vec3i)start) >= 1600.0)) continue;
                return endCandidate;
            }
        }
        return null;
    }
}

