/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.SplittableRandom;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.decorator.BiomeDecoratorBetweenlands;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;

public class BiomeGenerator {
    protected final Biome biome;
    protected IBlockState bottomBlockState = BlockRegistry.BETWEENLANDS_BEDROCK.func_176223_P();
    protected IBlockState underLayerTopBlockState = BlockRegistry.MUD.func_176223_P();
    protected IBlockState baseBlockState = BlockRegistry.BETWEENSTONE.func_176223_P();
    protected int bottomBlockHeight = 0;
    protected int bottomBlockFuzz = 5;
    protected int fillerBlockHeight = 2;
    protected int underLayerBlockHeight = 2;
    protected boolean hasBaseBlockPatches = true;
    private NoiseGeneratorPerlin baseBlockLayerVariationNoiseGen;
    protected double[] baseBlockLayerVariationNoise = new double[256];
    private final List<BiomeFeature> biomeFeatures = new ArrayList<BiomeFeature>();
    protected IChunkGenerator chunkGenerator;
    protected Biome[] biomesForGeneration;
    protected boolean noiseGeneratorsInitialized = false;
    protected boolean noiseGenerated = false;
    protected BiomeDecoratorBetweenlands decorator;

    public BiomeGenerator(Biome biome) {
        this.biome = biome;
        this.decorator = new BiomeDecoratorBetweenlands(biome);
    }

    public Biome getBiome() {
        return this.biome;
    }

    public BiomeGenerator setDecorator(BiomeDecoratorBetweenlands decorator) {
        if (decorator.getBiome() != this.getBiome()) {
            throw new RuntimeException("Decorator was assigned to a different biome!");
        }
        this.decorator = decorator;
        return this;
    }

    public BiomeDecoratorBetweenlands getDecorator() {
        return this.decorator;
    }

    public BiomeGenerator addFeature(BiomeFeature feature) {
        this.biomeFeatures.add(feature);
        return this;
    }

    public BiomeGenerator setTopBlockState(IBlockState state) {
        this.biome.field_76752_A = state;
        return this;
    }

    public BiomeGenerator setFillerBlockState(IBlockState state) {
        this.biome.field_76753_B = state;
        return this;
    }

    public BiomeGenerator setBottomBlockState(IBlockState state) {
        this.bottomBlockState = state;
        return this;
    }

    public BiomeGenerator setBottomBlockHeightAndFuzz(int height, int fuzz) {
        this.bottomBlockHeight = height;
        this.bottomBlockFuzz = fuzz;
        return this;
    }

    public BiomeGenerator setUnderLayerBlockState(IBlockState state) {
        this.underLayerTopBlockState = state;
        return this;
    }

    public BiomeGenerator setUnderLayerBlockHeight(int height) {
        this.underLayerBlockHeight = height;
        return this;
    }

    public BiomeGenerator setFillerBlockHeight(int height) {
        this.fillerBlockHeight = height;
        return this;
    }

    public BiomeGenerator setBaseBlockPatches(boolean hasPatches) {
        this.hasBaseBlockPatches = hasPatches;
        return this;
    }

    public void initializeGenerators(long seed) {
        if (!this.noiseGeneratorsInitialized) {
            this.baseBlockLayerVariationNoiseGen = new NoiseGeneratorPerlin(new Random(seed), 4);
            for (BiomeFeature feature : this.biomeFeatures) {
                feature.initializeGenerators(seed, this.biome);
            }
            this.noiseGeneratorsInitialized = true;
        }
    }

    public void generateNoise(int chunkX, int chunkZ) {
        if (!this.noiseGenerated) {
            this.baseBlockLayerVariationNoise = this.baseBlockLayerVariationNoiseGen.func_151599_a(this.baseBlockLayerVariationNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.16, 0.16, 1.0);
            for (BiomeFeature feature : this.biomeFeatures) {
                feature.generateNoise(chunkX, chunkZ, this.biome);
            }
            this.noiseGenerated = true;
        }
    }

    public void resetNoiseGenerators() {
        this.noiseGeneratorsInitialized = false;
    }

    public void resetNoise() {
        this.noiseGenerated = false;
    }

    public final void runBiomeFeatures(int blockX, int blockZ, int inChunkX, int inChunkZ, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, BiomeWeights biomeWeights, EnumGeneratorPass pass) {
        for (BiomeFeature feature : this.biomeFeatures) {
            feature.replaceStackBlocks(inChunkX, inChunkZ, baseBlockNoise, chunkPrimer, chunkGenerator, biomesForGeneration, this.biome, biomeWeights, pass);
        }
    }

    public final void replaceBiomeBlocks(int blockX, int blockZ, int inChunkX, int inChunkZ, double baseBlockNoise, Random rng, long seed, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, BiomeWeights biomeWeights) {
        this.chunkGenerator = chunkGenerator;
        this.biomesForGeneration = biomesForGeneration;
        if (!this.replaceStackBlocks(blockX, blockZ, inChunkX, inChunkZ, baseBlockNoise, chunkPrimer, chunkGenerator, biomesForGeneration, biomeWeights, EnumGeneratorPass.PRE_REPLACE_BIOME_BLOCKS)) {
            return;
        }
        SplittableRandom fastRng = new SplittableRandom((long)blockX * 341873128712L + (long)blockZ * 132897987541L);
        int baseBlockNoiseRN = (int)(baseBlockNoise / 3.0 + 3.0 + fastRng.nextDouble() * 0.25);
        int blocksBelow = -1;
        int blocksBelowLayer = -1;
        for (int y = 255; y >= 0; --y) {
            if (y <= this.bottomBlockHeight + this.bottomBlockFuzz && y >= this.bottomBlockHeight && y - this.bottomBlockHeight <= fastRng.nextInt(this.bottomBlockFuzz)) {
                chunkPrimer.func_177855_a(inChunkX, y, inChunkZ, this.bottomBlockState);
                continue;
            }
            IBlockState currentBlockState = chunkPrimer.func_177856_a(inChunkX, y, inChunkZ);
            if (currentBlockState == null || currentBlockState.func_185904_a() == Material.field_151579_a || currentBlockState.func_177230_c() == chunkGenerator.layerBlock) {
                blocksBelow = -1;
                continue;
            }
            ++blocksBelow;
            if (currentBlockState.func_177230_c() != chunkGenerator.baseBlock) continue;
            int baseBlockVariationLayer = (int)Math.abs(this.baseBlockLayerVariationNoise[inChunkX * 16 + inChunkZ] * (double)0.7f);
            int layerBlockY = y - baseBlockVariationLayer;
            if (layerBlockY < 0) {
                layerBlockY = 0;
            }
            if (this.hasBaseBlockPatches && baseBlockNoiseRN <= 0) {
                chunkPrimer.func_177855_a(inChunkX, y, inChunkZ, this.getBaseBlockState(layerBlockY));
                continue;
            }
            IBlockState blockAboveState = chunkPrimer.func_177856_a(inChunkX, y + 1, inChunkZ);
            if (blocksBelowLayer >= 0) {
                ++blocksBelowLayer;
            }
            if (currentBlockState.func_177230_c() == chunkGenerator.baseBlock && blockAboveState.func_177230_c() == chunkGenerator.layerBlock) {
                ++blocksBelowLayer;
            }
            if (blocksBelowLayer <= this.underLayerBlockHeight && blocksBelowLayer >= 0) {
                chunkPrimer.func_177855_a(inChunkX, y, inChunkZ, this.underLayerTopBlockState);
                continue;
            }
            if (blocksBelow == 0 && currentBlockState.func_177230_c() == chunkGenerator.baseBlock) {
                chunkPrimer.func_177855_a(inChunkX, y, inChunkZ, this.biome.field_76752_A);
                continue;
            }
            if (blocksBelow > 0 && blocksBelow <= this.fillerBlockHeight && currentBlockState.func_177230_c() == chunkGenerator.baseBlock) {
                chunkPrimer.func_177855_a(inChunkX, y, inChunkZ, this.biome.field_76753_B);
                continue;
            }
            if (currentBlockState.func_177230_c() != chunkGenerator.baseBlock) continue;
            chunkPrimer.func_177855_a(inChunkX, y, inChunkZ, this.getBaseBlockState(layerBlockY));
        }
        this.replaceStackBlocks(blockX, blockZ, inChunkX, inChunkZ, baseBlockNoise, chunkPrimer, chunkGenerator, biomesForGeneration, biomeWeights, EnumGeneratorPass.POST_REPLACE_BIOME_BLOCKS);
    }

    public IBlockState getBaseBlockState(int y) {
        return y > 45 ? this.baseBlockState : BlockRegistry.PITSTONE.func_176223_P();
    }

    protected boolean replaceStackBlocks(int blockX, int blockZ, int inChunkX, int inChunkZ, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, BiomeWeights biomeWeights, EnumGeneratorPass pass) {
        return true;
    }

    public static enum EnumGeneratorPass {
        PRE_REPLACE_BIOME_BLOCKS,
        POST_REPLACE_BIOME_BLOCKS,
        POST_GEN_CAVES;

    }
}

