/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;

public class PatchFeature
extends BiomeFeature {
    private NoiseGeneratorPerlin mudNoiseGen;
    private double[] mudNoise = new double[256];
    private double scaleX;
    private double scaleY;
    private double mult = 0.625;
    private double offset = 1.5;
    private IBlockState block;

    public PatchFeature(double scaleX, double scaleY, IBlockState block) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.block = block;
    }

    public PatchFeature(double scaleX, double scaleY, IBlockState block, double mult, double offset) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.block = block;
        this.mult = mult;
        this.offset = offset;
    }

    @Override
    public void initializeGenerators(long seed, Biome biome) {
        Random rng = new Random(seed);
        this.mudNoiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, Biome biome) {
        this.mudNoise = this.mudNoiseGen.func_151599_a(this.mudNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, this.scaleX, this.scaleY, 1.0);
    }

    @Override
    public void replaceStackBlocks(int x, int z, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, Biome biome, BiomeWeights biomeWeights, BiomeGenerator.EnumGeneratorPass pass) {
        float biomeWeight;
        if (pass == BiomeGenerator.EnumGeneratorPass.POST_GEN_CAVES && this.mudNoise[x * 16 + z] * this.mult * (double)(biomeWeight = biomeWeights.get(x, z)) + this.offset <= 0.0) {
            int y = 140;
            for (int yo = 0; yo < 140; ++yo) {
                Block currentBlock = chunkPrimer.func_177856_a(x, y - yo, z).func_177230_c();
                Block blockAbove = chunkPrimer.func_177856_a(x, y - yo + 1, z).func_177230_c();
                if (currentBlock != biome.field_76752_A.func_177230_c() || blockAbove != Blocks.field_150350_a && blockAbove != null) continue;
                chunkPrimer.func_177855_a(x, y - yo, z, this.block);
                break;
            }
        }
    }
}

