/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.TheBetweenlands;

public class PacketParticle
implements IMessage,
IMessageHandler<PacketParticle, IMessage> {
    public byte particleType;
    public float posX;
    public float posY;
    public float posZ;
    public float scale;
    private static Random rand = new Random();
    private static int counter = 0;

    public PacketParticle() {
    }

    public PacketParticle(ParticleType particleType, float posX, float posY, float posZ, float scale) {
        this.particleType = (byte)particleType.ordinal();
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.scale = scale;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte((int)this.particleType);
        buffer.writeFloat(this.posX).writeFloat(this.posY).writeFloat(this.posZ).writeFloat(this.scale);
    }

    public void fromBytes(ByteBuf buffer) {
        this.particleType = buffer.readByte();
        this.posX = buffer.readFloat();
        this.posY = buffer.readFloat();
        this.posZ = buffer.readFloat();
        this.scale = buffer.readFloat();
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketParticle message, MessageContext ctx) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        if (world == null) {
            return null;
        }
        if (world.field_72995_K) {
            if (message.particleType < 0 || message.particleType >= ParticleType.values.length) {
                return null;
            }
            switch (ParticleType.values[message.particleType]) {
                case SPORE_JET: {
                    for (double yy = (double)message.posY; yy < (double)message.posY + 2.0; yy += 0.5) {
                        double d0 = message.posX - 0.075f;
                        double d1 = yy;
                        double d2 = message.posZ - 0.075f;
                        double d3 = message.posX + 0.075f;
                        double d4 = message.posZ + 0.075f;
                        double d5 = message.posX;
                        double d6 = yy + 0.25;
                        double d7 = message.posZ;
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create((World)world, d0, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f))).withColor(105.0f, 70.0f, 40.0f, 1.0f)).withScale(1.5f)).withData(100)));
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create((World)world, d0, d1, d4, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f))).withColor(105.0f, 70.0f, 40.0f, 1.0f)).withScale(1.5f)).withData(100)));
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create((World)world, d3, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f))).withColor(105.0f, 70.0f, 40.0f, 1.0f)).withScale(1.5f)).withData(100)));
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create((World)world, d3, d1, d4, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f))).withColor(105.0f, 70.0f, 40.0f, 1.0f)).withScale(1.5f)).withData(100)));
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create((World)world, d0, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f))).withColor(105.0f, 70.0f, 40.0f, 1.0f)).withScale(1.5f)).withData(100)));
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create((World)world, d5, d6, d7, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f))).withColor(105.0f, 70.0f, 40.0f, 1.0f)).withScale(1.5f)).withData(100)));
                        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create((World)world, d0, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f))).withColor(105.0f, 70.0f, 40.0f, 1.0f)).withScale(1.5f)).withData(100)));
                    }
                    break;
                }
                case SLUDGE_JET: {
                    for (double yy = (double)message.posY; yy < (double)message.posY + 2.5; yy += 0.5) {
                        double d0 = message.posX - 0.075f;
                        double d1 = yy;
                        double d2 = message.posZ - 0.075f;
                        double d3 = message.posX + 0.075f;
                        double d4 = message.posZ + 0.075f;
                        double d5 = message.posX;
                        double d6 = yy + 0.25;
                        double d7 = message.posZ;
                        double d8 = message.posY;
                        BLParticles.TAR_BEAST_DRIP.spawn((World)world, d0, d1, d4, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f), 4.0 * (yy - d8), 10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
                        BLParticles.TAR_BEAST_DRIP.spawn((World)world, d3, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f), 4.0 * (yy - d8), 10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
                        BLParticles.TAR_BEAST_DRIP.spawn((World)world, d3, d1, d4, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f), 4.0 * (yy - d8), 10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
                        BLParticles.TAR_BEAST_DRIP.spawn((World)world, d0, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f), 4.0 * (yy - d8), 10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
                        BLParticles.TAR_BEAST_DRIP.spawn((World)world, d5, d6, d7, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f), 4.0 * (yy - d8), 10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
                        BLParticles.TAR_BEAST_DRIP.spawn((World)world, d0, d1, d2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f), 4.0 * (yy - d8), 10.0 * (yy - d8) * (double)(rand.nextFloat() - 0.5f))).withScale(2.5f)).withData(100)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
                    }
                    break;
                }
                case FLAME: {
                    TheBetweenlands.proxy.spawnCustomParticle("flame", (World)world, message.posX, message.posY, message.posZ, 0.0, 0.0, 0.0);
                    break;
                }
                case BEAM: {
                    if ((counter += rand.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
                        // empty if block
                    }
                    BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create((World)world, message.posX, message.posY, message.posZ, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f))).withColor(57.0f, 255.0f, 56.0f, 1.0f)).withScale(0.5f + message.scale)).withData(100)));
                    break;
                }
                case BEAM_YELLOW: {
                    if ((counter += rand.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
                        // empty if block
                    }
                    BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create((World)world, message.posX, message.posY, message.posZ, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f), 0.0125f * (rand.nextFloat() - 0.5f))).withColor(255.0f, 102.0f, 0.0f, 1.0f)).withScale(0.5f + message.scale)).withData(100)));
                    break;
                }
                case GOOP_SPLAT: {
                    for (int count = 0; count <= 200; ++count) {
                        TheBetweenlands.proxy.spawnCustomParticle("egg_sac", (World)world, (double)message.posX + (world.field_73012_v.nextDouble() - 0.5), (double)message.posY + world.field_73012_v.nextDouble(), (double)message.posZ + (world.field_73012_v.nextDouble() - 0.5), 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case SPLODE_SHROOM: {
                    for (int count = 0; count <= 200; ++count) {
                        TheBetweenlands.proxy.spawnCustomParticle("splode_shroom", (World)world, (double)message.posX + (world.field_73012_v.nextDouble() - 0.5), (double)message.posY + world.field_73012_v.nextDouble(), (double)message.posZ + (world.field_73012_v.nextDouble() - 0.5), 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case FLAME_JET: {
                    for (double yy = (double)message.posY; yy < (double)message.posY + 2.0; yy += 0.5) {
                        double d0 = message.posX - 0.075f;
                        double d1 = yy;
                        double d2 = message.posZ - 0.075f;
                        double d3 = message.posX + 0.075f;
                        double d4 = message.posZ + 0.075f;
                        double d5 = message.posX;
                        double d6 = yy + 0.25;
                        double d7 = message.posZ;
                        TheBetweenlands.proxy.spawnCustomParticle("flame", (World)world, d0, d1, d2, 0.0, 0.01, 0.0);
                        TheBetweenlands.proxy.spawnCustomParticle("flame", (World)world, d0, d1, d4, 0.0, 0.01, 0.0);
                        TheBetweenlands.proxy.spawnCustomParticle("flame", (World)world, d3, d1, d2, 0.0, 0.01, 0.0);
                        TheBetweenlands.proxy.spawnCustomParticle("flame", (World)world, d3, d1, d4, 0.0, 0.01, 0.0);
                        TheBetweenlands.proxy.spawnCustomParticle("flame", (World)world, d5, d6, d7, 0.0, 0.01, 0.0);
                    }
                    break;
                }
            }
        }
        return null;
    }

    public static enum ParticleType {
        SPORE_JET,
        SLUDGE_JET,
        FLAME,
        BEAM,
        BEAM_YELLOW,
        GOOP_SPLAT,
        SPLODE_SHROOM,
        FLAME_JET;

        static final ParticleType[] values;

        static {
            values = ParticleType.values();
        }
    }
}

