/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.storage.IChunkStorage;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.world.storage.WorldStorageImpl;

public class MessageSyncChunkStorage
extends MessageBase {
    private NBTTagCompound nbt;
    private ChunkPos pos;

    public MessageSyncChunkStorage() {
    }

    public MessageSyncChunkStorage(IChunkStorage storage) {
        this.nbt = storage.writeToNBT(new NBTTagCompound(), true);
        this.pos = storage.getChunk().func_76632_l();
    }

    public MessageSyncChunkStorage(IChunkStorage storage, NBTTagCompound nbt) {
        this.nbt = nbt;
        this.pos = storage.getChunk().func_76632_l();
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        try {
            this.pos = new ChunkPos(buf.readInt(), buf.readInt());
            this.nbt = buf.func_150793_b();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.pos.field_77276_a);
        buf.writeInt(this.pos.field_77275_b);
        buf.func_150786_a(this.nbt);
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        Chunk chunk;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (chunk = world.func_72964_e(this.pos.field_77276_a, this.pos.field_77275_b)) != null) {
            IWorldStorage worldStorage = WorldStorageImpl.getCapability((World)world);
            IChunkStorage chunkStorage = worldStorage.getChunkStorage(chunk);
            chunkStorage.readFromNBT(this.nbt, true);
        }
    }
}

