/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.handler.AttackDamageHandler;
import thebetweenlands.common.network.MessageEntity;

public class MessageDamageReductionParticle
extends MessageEntity {
    private Vec3d offset;
    private Vec3d dir;

    public MessageDamageReductionParticle() {
    }

    public MessageDamageReductionParticle(Entity entity, Vec3d offset, Vec3d dir) {
        this.addEntity(entity);
        this.offset = offset;
        this.dir = dir;
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.writeDouble(this.offset.field_72450_a);
        buf.writeDouble(this.offset.field_72448_b);
        buf.writeDouble(this.offset.field_72449_c);
        buf.writeDouble(this.dir.field_72450_a);
        buf.writeDouble(this.dir.field_72448_b);
        buf.writeDouble(this.dir.field_72449_c);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        super.deserialize(buf);
        this.offset = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.dir = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    @Override
    public IMessage process(MessageContext ctx) {
        super.process(ctx);
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        Entity entityHit = this.getEntity(0);
        if (entityHit != null) {
            AttackDamageHandler.spawnDamageReductionParticle(entityHit, this.offset, this.dir);
        }
    }
}

