/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.properties.EntityProperty;
import thebetweenlands.api.entity.IEntityWithLootModifier;

public class EntityPropertyLootModifier
implements EntityProperty {
    private final float min;
    private final float max;
    private final String key;
    private final boolean invert;

    public EntityPropertyLootModifier(String key, float min, float max, boolean invert) {
        this.key = key;
        this.min = min;
        this.max = max;
        this.invert = invert;
    }

    public boolean func_186657_a(Random random, Entity entity) {
        Map<String, Float> map;
        if (entity instanceof IEntityWithLootModifier && (map = ((IEntityWithLootModifier)entity).getLootModifiers(null, true)) != null && map.containsKey(this.key)) {
            float value = map.get(this.key).floatValue();
            return (value >= this.min && value <= this.max) == !this.invert;
        }
        return false;
    }

    public static class Serializer
    extends EntityProperty.Serializer<EntityPropertyLootModifier> {
        public Serializer() {
            super(new ResourceLocation("thebetweenlands", "loot_modifier"), EntityPropertyLootModifier.class);
        }

        public JsonElement serialize(EntityPropertyLootModifier property, JsonSerializationContext serializationContext) {
            JsonObject obj = new JsonObject();
            obj.add("min", (JsonElement)new JsonPrimitive((Number)Float.valueOf(property.min)));
            obj.add("max", (JsonElement)new JsonPrimitive((Number)Float.valueOf(property.max)));
            obj.add("key", (JsonElement)new JsonPrimitive(property.key));
            obj.add("invert", (JsonElement)new JsonPrimitive(Boolean.valueOf(property.invert)));
            return obj;
        }

        public EntityPropertyLootModifier deserialize(JsonElement element, JsonDeserializationContext deserializationContext) {
            JsonObject obj = JsonUtils.func_151210_l((JsonElement)element, (String)this.func_186649_a().func_110623_a());
            float min = obj.has("min") ? JsonUtils.func_151220_d((JsonElement)obj.get("min"), (String)"min") : -3.4028235E38f;
            float max = obj.has("max") ? JsonUtils.func_151220_d((JsonElement)obj.get("max"), (String)"max") : Float.MAX_VALUE;
            String key = JsonUtils.func_151206_a((JsonElement)obj.get("key"), (String)"key");
            boolean invert = obj.has("invert") ? JsonUtils.func_151216_b((JsonElement)obj.get("invert"), (String)"invert") : false;
            return new EntityPropertyLootModifier(key, min, max, invert);
        }
    }
}

