/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IRingOfGatheringMinion;
import thebetweenlands.api.storage.IOfflinePlayerDataHandler;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.KeyBindRegistry;
import thebetweenlands.common.world.storage.OfflinePlayerHandlerImpl;

public class ItemRingOfGathering
extends ItemRing {
    public static final String NBT_OFFLINE_PLAYER_DATA_EQUIPMENT_KEY = "GatheringRingEquipped";
    public static final String NBT_OFFLINE_PLAYER_DATA_LIST_KEY = "GatheringRingList";
    public static final String NBT_SYNC_COUNT_KEY = "GatheringRingCountSync";
    public static final String NBT_LAST_USER_UUID_KEY = "LastUserUuid";
    public static final String NBT_LAST_TELEPORT_TICKS = "LastTeleportTicks";

    @Nullable
    public UUID getLastUserUuid(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_186855_b(NBT_LAST_USER_UUID_KEY)) {
            return nbt.func_186857_a(NBT_LAST_USER_UUID_KEY);
        }
        return null;
    }

    public boolean isRingEquipped(UUID playerUuid) {
        NBTTagCompound nbt;
        IOfflinePlayerDataHandler handler = OfflinePlayerHandlerImpl.getHandler();
        if (handler != null && (nbt = handler.getOfflinePlayerData(playerUuid)) != null && nbt.func_150297_b(NBT_OFFLINE_PLAYER_DATA_EQUIPMENT_KEY, 1)) {
            return nbt.func_74767_n(NBT_OFFLINE_PLAYER_DATA_EQUIPMENT_KEY);
        }
        return false;
    }

    public boolean setRingEquipped(UUID playerUuid, boolean equipped) {
        IOfflinePlayerDataHandler handler = OfflinePlayerHandlerImpl.getHandler();
        if (handler != null) {
            NBTTagCompound nbt = handler.getOfflinePlayerData(playerUuid);
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74757_a(NBT_OFFLINE_PLAYER_DATA_EQUIPMENT_KEY, equipped);
            handler.setOfflinePlayerData(playerUuid, nbt);
            return true;
        }
        return false;
    }

    public boolean hasSpace(UUID playerUuid) {
        return this.getEntryCount(playerUuid) < this.getCapacity();
    }

    public int getEntryCount(UUID playerUuid) {
        NBTTagCompound nbt;
        IOfflinePlayerDataHandler handler = OfflinePlayerHandlerImpl.getHandler();
        if (handler != null && (nbt = handler.getOfflinePlayerData(playerUuid)) != null && nbt.func_150297_b(NBT_OFFLINE_PLAYER_DATA_LIST_KEY, 9)) {
            NBTTagList list = nbt.func_150295_c(NBT_OFFLINE_PLAYER_DATA_LIST_KEY, 10);
            return list.func_74745_c();
        }
        return 0;
    }

    public boolean addEntry(UUID playerUuid, RingEntityEntry entry) {
        IOfflinePlayerDataHandler handler = OfflinePlayerHandlerImpl.getHandler();
        if (handler != null) {
            NBTTagCompound nbt = handler.getOfflinePlayerData(playerUuid);
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            NBTTagList list = nbt.func_150295_c(NBT_OFFLINE_PLAYER_DATA_LIST_KEY, 10);
            NBTTagCompound entryNbt = new NBTTagCompound();
            entryNbt.func_74778_a("id", entry.id.toString());
            entryNbt.func_74782_a("data", (NBTBase)entry.nbt);
            entryNbt.func_74757_a("respawnByAnimator", entry.respawnByAnimator);
            if (entry.respawnByAnimator) {
                entryNbt.func_74768_a("animatorLifeCrystalCost", entry.animatorLifeCrystalCost);
                entryNbt.func_74768_a("animatorSulfurCost", entry.animatorSulfurCost);
            }
            list.func_74742_a((NBTBase)entryNbt);
            nbt.func_74782_a(NBT_OFFLINE_PLAYER_DATA_LIST_KEY, (NBTBase)list);
            handler.setOfflinePlayerData(playerUuid, nbt);
            return true;
        }
        return false;
    }

    @Nullable
    public RingEntityEntry getEntry(UUID playerUuid, boolean fromAnimator, Predicate<RingEntityEntry> predicate, boolean remove) {
        NBTTagList list;
        NBTTagCompound nbt;
        IOfflinePlayerDataHandler handler = OfflinePlayerHandlerImpl.getHandler();
        if (handler != null && (nbt = handler.getOfflinePlayerData(playerUuid)) != null && nbt.func_150297_b(NBT_OFFLINE_PLAYER_DATA_LIST_KEY, 9) && (list = nbt.func_150295_c(NBT_OFFLINE_PLAYER_DATA_LIST_KEY, 10)).func_74745_c() > 0) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                RingEntityEntry entry;
                NBTTagCompound entryNbt = list.func_150305_b(i);
                if (!entryNbt.func_150297_b("id", 8) || entryNbt.func_74767_n("respawnByAnimator") != fromAnimator || !predicate.test(entry = fromAnimator ? new RingEntityEntry(new ResourceLocation(entryNbt.func_74779_i("id")), entryNbt.func_74775_l("data"), entryNbt.func_74762_e("animatorLifeCrystalCost"), entryNbt.func_74762_e("animatorSulfurCost")) : new RingEntityEntry(new ResourceLocation(entryNbt.func_74779_i("id")), entryNbt.func_74775_l("data")))) continue;
                if (remove) {
                    list.func_74744_a(i);
                    nbt.func_74782_a(NBT_OFFLINE_PLAYER_DATA_LIST_KEY, (NBTBase)list);
                    handler.setOfflinePlayerData(playerUuid, nbt);
                }
                return entry;
            }
        }
        return null;
    }

    @Nullable
    public Entity returnEntityFromRing(double x, double y, double z, Entity user, UUID playerUuid, boolean fromAnimator) {
        ArrayList returnedEntity = new ArrayList();
        this.getEntry(playerUuid, fromAnimator, entry -> {
            Entity entity = EntityList.func_188429_b((ResourceLocation)entry.id, (World)user.field_70170_p);
            entity.func_70012_b(x, y, z, user.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof IRingOfGatheringMinion && ((IRingOfGatheringMinion)entity).returnFromRing(user, entry.nbt)) {
                returnedEntity.add(entity);
                return true;
            }
            return false;
        }, true);
        return returnedEntity.isEmpty() ? null : (Entity)returnedEntity.get(0);
    }

    public int getCapacity() {
        return 6;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.ring.gathering.bonus", (Object[])new Object[0]), 0));
        if (GuiScreen.func_146272_n()) {
            String toolTip = I18n.func_135052_a((String)"tooltip.bl.ring.gathering", (Object[])new Object[]{KeyBindRegistry.RADIAL_MENU.getDisplayName(), KeyBindRegistry.USE_RING.getDisplayName(), KeyBindRegistry.USE_SECONDARY_RING.getDisplayName()});
            list.addAll(ItemTooltipHandler.splitTooltip(toolTip, 1));
        } else {
            list.add(I18n.func_135052_a((String)"tooltip.bl.press.shift", (Object[])new Object[0]));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b(NBT_SYNC_COUNT_KEY, 1)) {
            return nbt.func_74771_c(NBT_SYNC_COUNT_KEY) > 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b(NBT_SYNC_COUNT_KEY, 1)) {
            return 1.0f - (float)nbt.func_74771_c(NBT_SYNC_COUNT_KEY) / (float)this.getCapacity();
        }
        return 1.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        int maxCount;
        NBTTagCompound nbt = stack.func_77978_p();
        int count = 0;
        if (nbt != null && nbt.func_150297_b(NBT_SYNC_COUNT_KEY, 1)) {
            count = nbt.func_74771_c(NBT_SYNC_COUNT_KEY);
        }
        if (count == (maxCount = this.getCapacity()) - 1) {
            return 0xFFAA00;
        }
        if (count == maxCount) {
            return 0xFF2020;
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean canEquipOnRightClick(ItemStack stack, EntityPlayer player, Entity target) {
        return stack.func_77978_p() == null || stack.func_77978_p().func_74771_c(NBT_SYNC_COUNT_KEY) <= 0 || player.func_70093_af();
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityPlayer player, Entity target) {
        return player == target;
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, IInventory inventory) {
        if (entity instanceof EntityPlayer) {
            this.setRingEquipped(entity.func_110124_au(), true);
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
        if (entity instanceof EntityPlayer) {
            this.setRingEquipped(entity.func_110124_au(), false);
        }
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
        if (entity.field_70173_aa % 5 == 0) {
            this.updateStackEntryCount(entity.field_70170_p, stack, entity);
        }
        this.updateLastUserUuid(entity.field_70170_p, stack, entity);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn.field_70173_aa % 5 == 0) {
            this.updateStackEntryCount(worldIn, stack, entityIn);
        }
        this.updateLastUserUuid(worldIn, stack, entityIn);
    }

    protected void updateLastUserUuid(World world, ItemStack stack, Entity entity) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_186854_a(NBT_LAST_USER_UUID_KEY, entity.func_110124_au());
        stack.func_77982_d(nbt);
    }

    protected void updateStackEntryCount(World worldIn, ItemStack stack, Entity entityIn) {
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayer) {
            byte syncCounter;
            int count = this.getEntryCount(entityIn.func_110124_au());
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
            }
            if ((syncCounter = nbt.func_74771_c(NBT_SYNC_COUNT_KEY)) != count) {
                nbt.func_74774_a(NBT_SYNC_COUNT_KEY, (byte)count);
                stack.func_77982_d(nbt);
            }
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (this.activateEffect(playerIn, stack)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    @Override
    public void onKeybindState(EntityPlayer player, ItemStack stack, IInventory inventory, boolean active) {
        if (active) {
            this.activateEffect(player, stack);
        }
    }

    protected boolean activateEffect(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            if (nbt.func_74771_c(NBT_SYNC_COUNT_KEY) > 0) {
                if (this.getEntry(player.func_110124_au(), false, e -> true, false) != null) {
                    if (!player.field_70170_p.field_72995_K) {
                        if (ItemRingOfGathering.removeXp(player, 15) >= 15) {
                            if (this.returnEntityFromRing(player.field_70165_t, player.field_70163_u, player.field_70161_v, (Entity)player, player.func_110124_au(), false) != null) {
                                return true;
                            }
                        } else {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.ring_of_gathering.not_enough_xp", new Object[0]), true);
                        }
                    }
                } else if (!player.field_70170_p.field_72995_K && this.getEntryCount(player.func_110124_au()) > 0) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.ring_of_gathering.animator", new Object[0]), true);
                }
            }
            boolean teleported = false;
            boolean missingTeleportXp = false;
            long lastTeleportTicks = nbt.func_74763_f(NBT_LAST_TELEPORT_TICKS);
            if (Math.abs(player.field_70170_p.func_82737_E() - lastTeleportTicks) > 20L) {
                nbt.func_74772_a(NBT_LAST_TELEPORT_TICKS, player.field_70170_p.func_82737_E());
                UUID thisPlayerUuid = player.func_110124_au();
                List ownedEntities = player.field_70170_p.func_175647_a(Entity.class, player.func_174813_aQ().func_186662_g(256.0), e -> e instanceof IRingOfGatheringMinion);
                for (Entity ownedEntity : ownedEntities) {
                    IRingOfGatheringMinion minion = (IRingOfGatheringMinion)ownedEntity;
                    UUID playerUuid = minion.getRingOwnerId();
                    if (playerUuid == null || !playerUuid.equals(thisPlayerUuid) || !minion.shouldReturnOnCall()) continue;
                    if (ItemRingOfGathering.removeXp(player, 5) >= 5) {
                        minion.returnToCall((Entity)player);
                        teleported = true;
                        continue;
                    }
                    missingTeleportXp = true;
                }
            }
            if (missingTeleportXp) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.ring_of_gathering.not_enough_xp", new Object[0]), true);
            }
            if (teleported) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        IRingOfGatheringMinion minion;
        UUID playerUuid;
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K && entity instanceof IRingOfGatheringMinion && (playerUuid = (minion = (IRingOfGatheringMinion)entity).getRingOwnerId()) != null && minion.shouldReturnOnDeath(entity.field_70170_p.func_152378_a(playerUuid) != null) && ItemRingOfGathering.returnMinionToRing(minion)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            Chunk chunk = event.getChunk();
            ArrayList entities = new ArrayList();
            int bx = chunk.field_76635_g * 16;
            int bz = chunk.field_76647_h * 16;
            chunk.func_177430_a(Entity.class, new AxisAlignedBB((double)(bx - 1), -999999.0, (double)(bz - 1), (double)(bx + 17), 999999.0, (double)(bz + 17)), entities, e -> e instanceof IRingOfGatheringMinion);
            for (Entity entity : entities) {
                IRingOfGatheringMinion minion = (IRingOfGatheringMinion)entity;
                UUID playerUuid = minion.getRingOwnerId();
                if (playerUuid == null || !minion.shouldReturnOnUnload(entity.field_70170_p.func_152378_a(playerUuid) != null)) continue;
                ItemRingOfGathering.returnMinionToRing(minion);
            }
        }
    }

    private static boolean returnMinionToRing(IRingOfGatheringMinion minion) {
        UUID playerUuid;
        ResourceLocation id;
        Entity entity = (Entity)minion;
        if (!entity.field_70170_p.field_72995_K && (id = EntityList.func_191301_a((Entity)entity)) != null && (playerUuid = minion.getRingOwnerId()) != null && ItemRegistry.RING_OF_GATHERING.isRingEquipped(playerUuid) && ItemRegistry.RING_OF_GATHERING.hasSpace(playerUuid)) {
            NBTTagCompound entityNbt = minion.returnToRing(playerUuid);
            RingEntityEntry entry = minion.isRespawnedByAnimator() ? new RingEntityEntry(id, entityNbt, minion.getAnimatorLifeCrystalCost(), minion.getAnimatorSulfurCost()) : new RingEntityEntry(id, entityNbt);
            if (ItemRegistry.RING_OF_GATHERING.addEntry(playerUuid, entry)) {
                entity.func_184226_ay();
                entity.func_184174_b(false);
                entity.func_70106_y();
                return true;
            }
        }
        return false;
    }

    public static class RingEntityEntry {
        public final ResourceLocation id;
        public final NBTTagCompound nbt;
        public final boolean respawnByAnimator;
        public final int animatorLifeCrystalCost;
        public final int animatorSulfurCost;

        public RingEntityEntry(ResourceLocation id, NBTTagCompound nbt) {
            this.id = id;
            this.nbt = nbt;
            this.respawnByAnimator = false;
            this.animatorLifeCrystalCost = 0;
            this.animatorSulfurCost = 0;
        }

        public RingEntityEntry(ResourceLocation id, NBTTagCompound nbt, int animatorLifeCrystalCost, int animatorSulfurCost) {
            this.id = id;
            this.nbt = nbt;
            this.respawnByAnimator = true;
            this.animatorLifeCrystalCost = animatorLifeCrystalCost;
            this.animatorSulfurCost = animatorSulfurCost;
        }
    }
}

