/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.registries.KeyBindRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.NBTHelper;
import thebetweenlands.util.PlayerUtil;

public class ItemRingOfDispersion
extends ItemRing {
    public static final String NBT_ACTIVE = "ring_of_dispersion.active";
    public static final String NBT_TIMER = "ring_of_dispersion.timer";
    public static final String NBT_LAST_VALID_POS = "ring_of_dispersion.last_valid_pos";

    public ItemRingOfDispersion() {
        this.func_77656_e(300);
    }

    public void setActive(ItemStack stack, boolean active) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a(NBT_ACTIVE, active);
    }

    public boolean isActive(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(NBT_ACTIVE);
    }

    public void setTimer(ItemStack stack, int ticks) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74768_a(NBT_TIMER, ticks);
    }

    public int getTimer(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e(NBT_TIMER) : 0;
    }

    public void setLastValidPos(ItemStack stack, @Nullable BlockPos pos) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        if (pos != null) {
            nbt.func_74772_a(NBT_LAST_VALID_POS, pos.func_177986_g());
        } else {
            nbt.func_82580_o(NBT_LAST_VALID_POS);
        }
    }

    @Nullable
    public BlockPos getLastValidPos(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b(NBT_LAST_VALID_POS, 4) ? BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f(NBT_LAST_VALID_POS)) : null;
    }

    public int getMaxPhasingDuration(ItemStack stack) {
        return 300;
    }

    public boolean canPhase(EntityPlayer player, ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k() && !player.func_175149_v() && player.func_70093_af() && !player.func_184811_cZ().func_185141_a((Item)this);
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.isActive(stack) && entity.field_70173_aa % 20 == 0) {
                this.drainPower(stack, entity);
            }
            BlockPos currentPos = new BlockPos(entity);
            BlockPos storedPos = this.getLastValidPos(stack);
            int storedTimer = this.getTimer(stack);
            boolean requiresTeleport = false;
            if (!this.isActive(stack)) {
                if (!currentPos.equals((Object)storedPos)) {
                    this.setLastValidPos(stack, currentPos);
                }
                if (storedTimer != 0) {
                    if (entity instanceof EntityPlayer && !this.canPhase((EntityPlayer)entity, stack)) {
                        requiresTeleport = true;
                    }
                    this.setTimer(stack, 0);
                }
            } else {
                int maxDuration = this.getMaxPhasingDuration(stack);
                if (storedTimer >= maxDuration) {
                    requiresTeleport = true;
                    if (entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).func_184811_cZ().func_185145_a((Item)this, 300);
                    }
                } else {
                    this.setTimer(stack, storedTimer + 1);
                }
            }
            if (requiresTeleport && storedPos != null) {
                PlayerUtil.teleport(entity, (double)storedPos.func_177958_n() + 0.5, storedPos.func_177956_o(), (double)storedPos.func_177952_p() + 0.5);
                this.setLastValidPos(stack, null);
                this.setTimer(stack, 0);
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundRegistry.RING_OF_DISPERSION_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a(NBT_ACTIVE, false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isActive(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.ring.dispersion.bonus", (Object[])new Object[0]), 0));
        if (GuiScreen.func_146272_n()) {
            String toolTip = I18n.func_135052_a((String)"tooltip.bl.ring.dispersion", (Object[])new Object[]{KeyBindRegistry.RADIAL_MENU.getDisplayName(), Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName()});
            list.addAll(ItemTooltipHandler.splitTooltip(toolTip, 1));
        } else {
            list.add(I18n.func_135052_a((String)"tooltip.bl.press.shift", (Object[])new Object[0]));
        }
    }

    @Override
    protected float getXPConversionRate(ItemStack stack, EntityPlayer player) {
        return 2.0f;
    }
}

