/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.herblore.book.widgets.ManualWidgetBase;

@SideOnly(value=Side.CLIENT)
public class ItemWidget
extends ManualWidgetBase {
    public int width;
    public int height;
    public List<ItemStack> stacks = new ArrayList<ItemStack>();
    public float scale = 1.0f;
    private int currentDisplayItem = 0;

    public ItemWidget(int xStart, int yStart, ItemStack stack, float scale) {
        super(xStart, yStart);
        this.stacks.add(stack);
        this.scale = scale;
        this.width = (int)(16.0f * scale);
        this.height = (int)(16.0f * scale);
    }

    public ItemWidget(int xStart, int yStart, List<ItemStack> stacks, float scale) {
        super(xStart, yStart);
        this.stacks = stacks;
        this.scale = scale;
        this.width = (int)(16.0f * scale);
        this.height = (int)(16.0f * scale);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
        RenderItem render = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        render.func_180450_b(this.stacks.get(this.currentDisplayItem), (int)((float)this.xStart / this.scale), (int)((float)this.yStart / this.scale));
        render.func_180453_a(Minecraft.func_71410_x().field_71466_p, this.stacks.get(this.currentDisplayItem), (int)((float)this.xStart / this.scale), (int)((float)this.yStart / this.scale), null);
        RenderHelper.func_74518_a();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        if (this.mouseX >= this.xStart && (float)this.mouseX <= (float)this.xStart + 16.0f * this.scale && this.mouseY >= this.yStart && (float)this.mouseY <= (float)this.yStart + 16.0f * this.scale && this.stacks.get(this.currentDisplayItem) != null) {
            List tooltipData = this.stacks.get(this.currentDisplayItem).func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            ArrayList<String> parsedTooltip = new ArrayList<String>();
            boolean first = true;
            Iterator iterator = tooltipData.iterator();
            while (iterator.hasNext()) {
                String s;
                String s_ = s = (String)iterator.next();
                if (!first) {
                    s_ = TextFormatting.GRAY + s;
                }
                parsedTooltip.add(s_);
                first = false;
            }
            ItemWidget.renderTooltip(this.mouseX, this.mouseY, parsedTooltip, 0xFFFFFF, -267386864);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + this.width && y >= this.yStart && y <= this.yStart + this.height) {
            this.currentDisplayItem = this.currentDisplayItem + 1 < this.stacks.size() ? ++this.currentDisplayItem : 0;
            this.drawForeGround();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual != null && this.manual.untilUpdate % 200 == 0) {
            this.currentDisplayItem = this.currentDisplayItem + 1 < this.stacks.size() ? ++this.currentDisplayItem : 0;
            this.drawForeGround();
        }
    }
}

