/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.aspect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.AspectItem;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.aspect.IItemStackMatcher;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class AspectManager {
    private static final List<AspectEntry> REGISTERED_ASPECTS = new ArrayList<AspectEntry>();
    private static final Map<AspectItem, List<AspectItemEntry>> REGISTERED_ITEMS = new LinkedHashMap<AspectItem, List<AspectItemEntry>>();
    private static final Map<Item, List<AspectItem>> ITEM_TO_ASPECT_ITEMS = new HashMap<Item, List<AspectItem>>();
    private final Map<AspectItem, List<Aspect>> matchedAspects = new LinkedHashMap<AspectItem, List<Aspect>>();

    public Map<AspectItem, List<Aspect>> getMatchedAspects() {
        return Collections.unmodifiableMap(this.matchedAspects);
    }

    public static Map<AspectItem, List<AspectItemEntry>> getRegisteredItems() {
        return REGISTERED_ITEMS;
    }

    public static void registerAspect(IAspectType aspect, AspectTier tier, AspectGroup type, int baseAmount) {
        AspectManager.registerAspect(aspect, tier.id, type.id, baseAmount);
    }

    public static void registerAspect(IAspectType aspect, int tier, int type, int baseAmount) {
        REGISTERED_ASPECTS.add(new AspectEntry(aspect, tier, type, baseAmount));
    }

    public static void addStaticAspectsToItem(ItemStack item, IItemStackMatcher matcher, AspectTier tier, AspectGroup type, float amountMultiplier, float amountVariation) {
        AspectManager.addStaticAspectsToItem(item, matcher, tier, type, amountMultiplier, amountVariation, 1);
    }

    public static void addStaticAspectsToItem(ItemStack item, IItemStackMatcher matcher, AspectTier tier, AspectGroup type, float amountMultiplier, float amountVariation, int aspectCount) {
        AspectManager.addStaticAspectsToItem(item, matcher, tier.id, type.id, amountMultiplier, amountVariation, aspectCount);
    }

    public static void addStaticAspectsToItem(ItemStack item, IItemStackMatcher matcher, int tier, int type, float amountMultiplier, float amountVariation) {
        AspectManager.addStaticAspectsToItem(item, matcher, tier, type, amountMultiplier, amountVariation, 1);
    }

    public static void addStaticAspectsToItem(ItemStack item, IItemStackMatcher matcher, int tier, int type, float amountMultiplier, float amountVariation, int aspectCount) {
        List<AspectItemEntry> entryList;
        AspectItemEntry entry = new AspectItemEntry(item, matcher, tier, type, amountMultiplier, amountVariation);
        AspectItem itemEntry = entry.item;
        List<AspectItem> aspectItems = ITEM_TO_ASPECT_ITEMS.get(item.func_77973_b());
        if (aspectItems != null) {
            for (AspectItem aspectItem : aspectItems) {
                if (!aspectItem.matches(item)) continue;
                itemEntry = aspectItem;
                break;
            }
        }
        if ((entryList = REGISTERED_ITEMS.get(itemEntry)) == null) {
            entryList = new ArrayList<AspectItemEntry>();
            REGISTERED_ITEMS.put(itemEntry, entryList);
        }
        for (int i = 0; i < aspectCount; ++i) {
            entryList.add(entry);
        }
        if (aspectItems == null) {
            aspectItems = new ArrayList<AspectItem>();
            ITEM_TO_ASPECT_ITEMS.put(item.func_77973_b(), aspectItems);
        }
        aspectItems.add(entry.item);
    }

    public static long getAspectsSeed(long worldSeed) {
        Random rnd = new Random();
        rnd.setSeed(worldSeed);
        return rnd.nextLong();
    }

    public static AspectManager get(World world) {
        return BetweenlandsWorldStorage.forWorld(world).getAspectManager();
    }

    public void loadAndPopulateStaticAspects(NBTTagCompound nbt, long aspectSeed) {
        if (nbt != null && nbt.func_74764_b("entries")) {
            this.loadStaticAspects(nbt);
            this.updateAspects(aspectSeed);
        } else {
            this.generateStaticAspects(aspectSeed);
        }
    }

    private void updateMatchedAspects(AspectItem item, List<Aspect> aspects) {
        Collections.sort(aspects);
        this.matchedAspects.put(item, aspects);
    }

    public void loadStaticAspects(NBTTagCompound nbt) {
        this.matchedAspects.clear();
        NBTTagList entryList = (NBTTagList)nbt.func_74781_a("entries");
        block0: for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound entryCompound = entryList.func_150305_b(i);
            AspectItem itemEntry = AspectManager.readAspectItemFromNBT(entryCompound);
            if (itemEntry == null) continue;
            NBTTagList aspectList = (NBTTagList)entryCompound.func_74781_a("aspects");
            ArrayList<Aspect> itemAspects = new ArrayList<Aspect>();
            for (int c = 0; c < aspectList.func_74745_c(); ++c) {
                NBTTagCompound aspectCompound = aspectList.func_150305_b(c);
                Aspect aspect = Aspect.readFromNBT(aspectCompound);
                if (aspect == null) continue block0;
                itemAspects.add(aspect);
            }
            this.updateMatchedAspects(itemEntry, itemAspects);
        }
    }

    public void saveStaticAspects(NBTTagCompound nbt) {
        NBTTagList entryList = new NBTTagList();
        for (Map.Entry<AspectItem, List<Aspect>> entry : this.matchedAspects.entrySet()) {
            AspectItem itemEntry = entry.getKey();
            List<Aspect> itemAspects = entry.getValue();
            NBTTagCompound entryCompound = new NBTTagCompound();
            AspectManager.writeAspectItemToNbt(itemEntry, entryCompound);
            NBTTagList aspectList = new NBTTagList();
            for (Aspect aspect : itemAspects) {
                aspectList.func_74742_a((NBTBase)aspect.writeToNBT(new NBTTagCompound()));
            }
            entryCompound.func_74782_a("aspects", (NBTBase)aspectList);
            entryList.func_74742_a((NBTBase)entryCompound);
        }
        nbt.func_74782_a("entries", (NBTBase)entryList);
    }

    public static NBTTagCompound writeAspectItemToNbt(AspectItem aspectItem, NBTTagCompound nbt) {
        nbt.func_74782_a("item", (NBTBase)aspectItem.getOriginal().func_77955_b(new NBTTagCompound()));
        return nbt;
    }

    @Nullable
    public static AspectItem readAspectItemFromNBT(NBTTagCompound nbt) {
        ItemStack item;
        ItemStack itemStack = item = nbt.func_74764_b("item") ? new ItemStack(nbt.func_74775_l("item")) : null;
        if (item == null) {
            return null;
        }
        return AspectManager.getAspectItem(item);
    }

    public void resetStaticAspects(long aspectSeed) {
        this.generateStaticAspects(aspectSeed);
    }

    private void generateStaticAspects(long seed) {
        this.matchedAspects.clear();
        this.updateAspects(seed);
    }

    private void updateAspects(long seed) {
        Random rnd = new Random();
        rnd.setSeed(seed);
        ArrayList<AspectEntry> availableAspects = new ArrayList<AspectEntry>(REGISTERED_ASPECTS.size());
        availableAspects.addAll(REGISTERED_ASPECTS);
        ArrayList<AspectEntry> possibleAspects = new ArrayList<AspectEntry>();
        for (Map.Entry<AspectItem, List<AspectItemEntry>> item : REGISTERED_ITEMS.entrySet()) {
            AspectItem itemStack = item.getKey();
            if (this.matchedAspects.containsKey(itemStack)) continue;
            LinkedHashMap<Integer, ArrayList<AspectItemEntry>> itemEntriesByGroup = new LinkedHashMap<Integer, ArrayList<AspectItemEntry>>();
            for (AspectItemEntry itemEntry : item.getValue()) {
                ArrayList<AspectItemEntry> groupItemEntries = (ArrayList<AspectItemEntry>)itemEntriesByGroup.get(itemEntry.group);
                if (groupItemEntries == null) {
                    groupItemEntries = new ArrayList<AspectItemEntry>();
                    itemEntriesByGroup.put(itemEntry.group, groupItemEntries);
                }
                groupItemEntries.add(itemEntry);
            }
            for (List itemEntries : itemEntriesByGroup.values()) {
                ArrayList<Aspect> itemAspects = new ArrayList<Aspect>(itemEntries.size());
                if (!this.fillItemAspects(itemAspects, itemEntries.size(), itemEntries, possibleAspects, availableAspects, rnd)) {
                    this.fillItemAspects(itemAspects, itemEntries.size(), itemEntries, possibleAspects, REGISTERED_ASPECTS, rnd);
                }
                for (Aspect itemAspect : itemAspects) {
                    this.removeAvailableAspect(itemAspect, availableAspects);
                }
                List<Aspect> mergedAspects = this.matchedAspects.get(itemStack);
                if (mergedAspects == null) {
                    mergedAspects = new ArrayList<Aspect>(itemAspects.size());
                }
                for (Aspect aspect : itemAspects) {
                    Aspect mergedAspect = null;
                    for (Aspect ma : mergedAspects) {
                        if (ma.type != aspect.type) continue;
                        mergedAspect = ma;
                        break;
                    }
                    if (mergedAspect == null) {
                        mergedAspects.add(aspect);
                        continue;
                    }
                    mergedAspects.remove(mergedAspect);
                    mergedAspects.add(new Aspect(mergedAspect.type, mergedAspect.amount + aspect.amount));
                }
                this.updateMatchedAspects(itemStack, mergedAspects);
            }
        }
    }

    private void removeAvailableAspect(Aspect itemAspect, List<AspectEntry> availableAspects) {
        Iterator<AspectEntry> it = availableAspects.iterator();
        AspectEntry availableAspect = null;
        while (it.hasNext() && (availableAspect = it.next()) != null) {
            if (!availableAspect.aspect.equals(itemAspect.type)) continue;
            it.remove();
        }
    }

    private boolean fillItemAspects(List<Aspect> itemAspects, int itemAspectsSize, List<AspectItemEntry> itemEntries, List<AspectEntry> possibleAspects, List<AspectEntry> availableAspects, Random rnd) {
        boolean foundMatches = false;
        int possibleAspectCount = this.fillPossibleAspects(itemEntries, possibleAspects, availableAspects, null);
        if (possibleAspectCount == 0) {
            return false;
        }
        for (int i = 0; i < itemAspectsSize; ++i) {
            if (possibleAspects.size() == 0) {
                this.fillPossibleAspects(itemEntries, possibleAspects, availableAspects, itemAspectsSize < possibleAspectCount ? itemAspects : null);
            }
            AspectEntry randomAspect = possibleAspects.get(rnd.nextInt(possibleAspects.size()));
            possibleAspects.remove(randomAspect);
            AspectItemEntry matchingItemEntry = null;
            Collections.shuffle(itemEntries, rnd);
            for (AspectItemEntry itemEntry : itemEntries) {
                if (!itemEntry.matchEntry(randomAspect)) continue;
                matchingItemEntry = itemEntry;
                break;
            }
            float baseAmount = (float)randomAspect.baseAmount * matchingItemEntry.amountMultiplier;
            itemAspects.add(new Aspect(randomAspect.aspect, (int)(baseAmount + baseAmount * matchingItemEntry.amountVaration * (rnd.nextFloat() * 2.0f - 1.0f))));
            foundMatches = true;
        }
        return foundMatches;
    }

    private int fillPossibleAspects(List<AspectItemEntry> itemEntries, List<AspectEntry> possibleAspects, List<AspectEntry> availableAspects, List<Aspect> takenAspects) {
        possibleAspects.clear();
        for (AspectItemEntry itemEntry : itemEntries) {
            for (AspectEntry availableAspect : availableAspects) {
                if (!itemEntry.matchEntry(availableAspect) || possibleAspects.contains(availableAspect)) continue;
                if (takenAspects == null) {
                    possibleAspects.add(availableAspect);
                    continue;
                }
                boolean isTaken = false;
                for (Aspect takenAspect : takenAspects) {
                    if (takenAspect.type != availableAspect.aspect) continue;
                    isTaken = true;
                    break;
                }
                if (isTaken) continue;
                possibleAspects.add(availableAspect);
            }
        }
        return possibleAspects.size();
    }

    @Nonnull
    public List<Aspect> getStaticAspects(ItemStack stack) {
        AspectItem item = AspectManager.getAspectItem(stack);
        if (item != null) {
            return this.getStaticAspects(item);
        }
        return new ArrayList<Aspect>();
    }

    @Nonnull
    public List<Aspect> getStaticAspects(AspectItem item) {
        List<Aspect> aspects = this.matchedAspects.get(item);
        if (aspects == null) {
            aspects = new ArrayList<Aspect>();
        }
        return aspects;
    }

    @Nullable
    public static AspectItem getAspectItem(ItemStack stack) {
        List<AspectItem> potentialMatches = ITEM_TO_ASPECT_ITEMS.get(stack.func_77973_b());
        if (potentialMatches != null) {
            for (AspectItem aspectItem : potentialMatches) {
                if (!aspectItem.matches(stack)) continue;
                return aspectItem;
            }
        }
        return null;
    }

    public List<Aspect> getDiscoveredStaticAspects(AspectItem item, @Nullable DiscoveryContainer<?> discoveryContainer) {
        ArrayList<Aspect> aspects = new ArrayList<Aspect>();
        if (discoveryContainer == null) {
            aspects.addAll(this.getStaticAspects(item));
        } else {
            aspects.addAll(discoveryContainer.getDiscoveredStaticAspects(this, item));
        }
        return aspects;
    }

    public List<IAspectType> getDiscoveredAspectTypes(AspectItem item, DiscoveryContainer<?> discoveryContainer) {
        ArrayList<IAspectType> aspects = new ArrayList<IAspectType>();
        for (Aspect aspect : this.getDiscoveredStaticAspects(item, discoveryContainer)) {
            aspects.add(aspect.type);
        }
        return aspects;
    }

    public static final class AspectItemEntry {
        public final AspectItem item;
        public final int tier;
        public final int group;
        public final float amountMultiplier;
        public final float amountVaration;
        public final ResourceLocation itemName;

        private AspectItemEntry(ItemStack item, IItemStackMatcher matcher, AspectTier tier, AspectGroup group, float amountMultiplier, float amountVariation) {
            this(item, matcher, tier.id, group.id, amountMultiplier, amountVariation);
        }

        private AspectItemEntry(ItemStack item, IItemStackMatcher matcher, int tier, int group, float amountMultiplier, float amountVariation) {
            this.item = new AspectItem(item, matcher);
            this.tier = tier;
            this.group = group;
            this.amountMultiplier = amountMultiplier;
            this.amountVaration = amountVariation;
            this.itemName = item.func_77973_b().getRegistryName();
        }

        public boolean matchEntry(AspectEntry aspectEntry) {
            return aspectEntry.tier == this.tier && aspectEntry.group == this.group;
        }
    }

    public static final class AspectEntry {
        public final IAspectType aspect;
        public final int tier;
        public final int group;
        public final int baseAmount;
        public final String aspectName;

        private AspectEntry(IAspectType aspect, AspectTier tier, AspectGroup group, int baseAmount) {
            this(aspect, tier.id, group.id, baseAmount);
        }

        private AspectEntry(IAspectType aspect, int tier, int group, int baseAmount) {
            this.aspect = aspect;
            this.tier = tier;
            this.group = group;
            this.baseAmount = baseAmount;
            this.aspectName = this.aspect.getName();
        }

        public String toString() {
            return "AspectEntry[Aspect=" + this.aspectName + ", Tier=" + this.tier + ", Group=" + this.group + ", BaseAmount=" + this.baseAmount + "]";
        }
    }

    public static enum AspectGroup {
        HERB(0),
        GEM_BYRGINAZ(1),
        GEM_FIRNALAZ(2),
        GEM_FERGALAZ(3),
        SAP_SPIT(4),
        SLUDGE_WORM_DUNGEON(5);

        public final int id;

        private AspectGroup(int id) {
            this.id = id;
        }
    }

    public static enum AspectTier {
        COMMON(0),
        UNCOMMON(1),
        RARE(2);

        public final int id;

        private AspectTier(int id) {
            this.id = id;
        }
    }
}

