/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IPuppetCapability;
import thebetweenlands.api.capability.IPuppeteerCapability;
import thebetweenlands.api.capability.ProtectionShield;
import thebetweenlands.client.handler.WorldRenderHandler;
import thebetweenlands.client.render.entity.RenderFortressBoss;
import thebetweenlands.client.render.entity.RenderSwordEnergy;
import thebetweenlands.client.render.entity.layer.LayerPuppetOverlay;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.ai.EntityAIFollowTarget;
import thebetweenlands.common.entity.ai.puppet.EntityAIGoTo;
import thebetweenlands.common.entity.ai.puppet.EntityAIGuardHome;
import thebetweenlands.common.entity.ai.puppet.EntityAIPuppet;
import thebetweenlands.common.entity.ai.puppet.EntityAIStay;
import thebetweenlands.common.entity.mobs.EntityFortressBoss;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.item.equipment.ItemRingOfRecruitment;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.util.RenderUtils;

public class PuppetHandler {
    private PuppetHandler() {
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ItemStack ring;
        Entity owner;
        IPuppetCapability cap;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityLiving && (cap = (IPuppetCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) != null && (owner = cap.getPuppeteer()) != null && !(ring = ItemRingOfRecruitment.getActiveRing(owner, null)).func_190926_b()) {
            ring.func_77964_b(ring.func_77952_i() - cap.getRecruitmentCost());
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        ProtectionShield shield;
        IPuppeteerCapability shieldCap;
        Entity controller;
        EntityLivingBase target = event.getEntityLiving();
        DamageSource source = event.getSource();
        IPuppetCapability cap = (IPuppetCapability)target.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
        if (cap != null && cap.hasPuppeteer() && (controller = cap.getPuppeteer()) != null && (source.func_76364_f() == controller || source.func_76346_g() == controller)) {
            event.setCanceled(true);
            return;
        }
        if (target.func_70093_af() && (shieldCap = (IPuppeteerCapability)target.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) != null && (shield = shieldCap.getShield()) != null && shield.hasShield()) {
            EntityFortressBoss.AttackShieldResult result = EntityFortressBoss.attackShield(target.field_70170_p, shield, target.func_174791_d().func_72441_c(0.0, 1.0, 0.0), shield.getYaw(shieldCap.getShieldRotationTicks() + 1), shield.getPitch(shieldCap.getShieldRotationTicks() + 1), shield.getRoll(shieldCap.getShieldRotationTicks() + 1), 0.15f, (Object2IntMap<Entity>)new Object2IntOpenHashMap(), source, false);
            if (result.deflected && result.shieldHit >= 0) {
                shield.setActive(result.shieldHit, false);
                event.setCanceled(true);
            }
        }
        if (!PuppetHandler.checkValidAttack(source.func_76364_f(), (Entity)target) && !PuppetHandler.checkValidAttack(source.func_76346_g(), (Entity)target)) {
            event.setCanceled(true);
        } else {
            HashSet<Entity> attackers = new HashSet<Entity>();
            attackers.add(source.func_76364_f());
            attackers.add(source.func_76346_g());
            for (Entity attacker : attackers) {
                IPuppetCapability attackerCap;
                if (attacker == null) continue;
                if (attacker instanceof EntityLiving && (attackerCap = (IPuppetCapability)attacker.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) != null && attackerCap.hasPuppeteer() && attacker.field_70170_p.field_73012_v.nextInt(4) == 0) {
                    target.func_70604_c((EntityLivingBase)((EntityLiving)attacker));
                }
                if (!(event.getAmount() > 1.0f)) continue;
                PuppetHandler.consumeAttackXp(attacker);
            }
        }
    }

    private static boolean checkValidAttack(Entity attacker, Entity target) {
        IPuppetCapability cap;
        if (attacker instanceof EntityLiving && (cap = (IPuppetCapability)attacker.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) != null && cap.hasPuppeteer()) {
            return ((EntityLiving)attacker).func_70638_az() == target;
        }
        return true;
    }

    private static void consumeAttackXp(Entity attacker) {
        Entity controller;
        IPuppetCapability cap = (IPuppetCapability)attacker.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
        if (cap != null && cap.hasPuppeteer() && (controller = cap.getPuppeteer()) instanceof EntityPlayer) {
            ItemRing.removeXp((EntityPlayer)controller, 1 + attacker.field_70170_p.field_73012_v.nextInt(2));
        }
    }

    private static void cycleAiState(EntityLiving entity, IPuppetCapability cap, EntityPlayer player, BlockPos pos) {
        if (!cap.getStay() && !cap.getGuard()) {
            cap.setStay(false);
            cap.setGuard(true, pos);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.ring_of_recruitment.state.guard", new Object[]{entity.func_145748_c_()}), true);
        } else if (cap.getGuard()) {
            cap.setStay(true);
            cap.setGuard(false, null);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.ring_of_recruitment.state.stay", new Object[]{entity.func_145748_c_()}), true);
        } else {
            cap.setStay(false);
            cap.setGuard(false, null);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.ring_of_recruitment.state.follow", new Object[]{entity.func_145748_c_()}), true);
        }
    }

    @SubscribeEvent
    public static void onUpdateLiving(LivingEvent.LivingUpdateEvent event) {
        IPuppetCapability cap;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityLiving && (cap = (IPuppetCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) != null && cap.hasPuppeteer()) {
            EntityLiving living = (EntityLiving)entity;
            if (!entity.field_70170_p.field_72995_K) {
                cap.setRemainingTicks(cap.getRemainingTicks() - 1);
                Entity controller = cap.getPuppeteer();
                if (cap.getRemainingTicks() <= 0 || controller != null && !ItemRingOfRecruitment.isRingActive(controller, cap)) {
                    ItemStack ring;
                    if (controller != null && !(ring = ItemRingOfRecruitment.getActiveRing(controller, null)).func_190926_b()) {
                        ring.func_77964_b(ring.func_77952_i() - cap.getRecruitmentCost());
                    }
                    cap.setRecruitmentCost(0);
                    cap.setPuppeteer(null);
                    cap.setRemainingTicks(0);
                    cap.setRingUuid(null);
                    living.func_70624_b(null);
                    living.func_70604_c(null);
                    EntityAIPuppet.removePuppetAI(living.field_70714_bg);
                    EntityAIPuppet.removePuppetAI(living.field_70715_bh);
                } else {
                    EntityAIPuppet puppetAI;
                    living.func_110163_bv();
                    if (controller instanceof EntityPlayer && living.func_110143_aJ() < living.func_110138_aP() - 0.1f && living.field_70173_aa % 40 == 0 && (!cap.getStay() && !cap.getGuard() || controller.func_70032_d((Entity)entity) < 6.0f) && ItemRing.removeXp((EntityPlayer)controller, 3) >= 3) {
                        living.func_70691_i(2.0f);
                        if (living.field_70170_p instanceof WorldServer) {
                            ((WorldServer)living.field_70170_p).func_175739_a(EnumParticleTypes.HEART, living.field_70165_t, living.field_70163_u + (double)living.func_70047_e() + 0.25, living.field_70161_v, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                    if (EntityAIPuppet.getPuppetAI(living.field_70715_bh) == null && living instanceof EntityCreature) {
                        EntityAINearestAttackableTarget<EntityLiving> aiTarget = new EntityAINearestAttackableTarget<EntityLiving>((EntityCreature)living, EntityLiving.class, 0, true, true, target -> {
                            IPuppetCapability targetCap = (IPuppetCapability)target.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
                            if (targetCap != null && targetCap.hasPuppeteer()) {
                                return false;
                            }
                            if (target instanceof IEntityOwnable && ((IEntityOwnable)target).func_184753_b() != null) {
                                return false;
                            }
                            return target instanceof IMob;
                        }){

                            protected double func_111175_f() {
                                return 16.0;
                            }

                            public boolean func_75250_a() {
                                IPuppetCapability thisCap;
                                return super.func_75250_a() && (thisCap = (IPuppetCapability)this.field_75299_d.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) != null && thisCap.getGuard();
                            }
                        };
                        aiTarget.func_75248_a(1);
                        EntityAITasks tasks = EntityAIPuppet.addPuppetAI(() -> cap.getPuppeteer(), (EntityLivingBase)living, living.field_70715_bh);
                        tasks.func_75776_a(0, (EntityAIBase)aiTarget);
                    }
                    if ((puppetAI = EntityAIPuppet.getPuppetAI(living.field_70714_bg)) == null) {
                        EntityAISwimming aiSwim = new EntityAISwimming(living);
                        EntityAIStay aiStay = new EntityAIStay(living);
                        aiStay.func_75248_a(3);
                        EntityAIGuardHome aiGuardHome = null;
                        EntityAIWander aiWander = null;
                        EntityAIAttackOnCollide aiAttack = null;
                        if (living instanceof EntityCreature) {
                            aiGuardHome = new EntityAIGuardHome((EntityCreature)living, 1.0, 24);
                            aiWander = new EntityAIWander((EntityCreature)living, 1.0);
                            aiAttack = new EntityAIAttackMelee((EntityCreature)living, 1.2, true){

                                protected void func_190102_a(EntityLivingBase enemy, double distToEnemySqr) {
                                    double d0 = this.func_179512_a(enemy);
                                    if (distToEnemySqr <= d0 && this.field_75439_d <= 0) {
                                        this.field_75439_d = 20;
                                        this.field_75441_b.func_184609_a(EnumHand.MAIN_HAND);
                                        if (!this.field_75441_b.func_70652_k((Entity)enemy)) {
                                            EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this.field_75441_b, (Entity)enemy);
                                        }
                                    }
                                }
                            };
                            aiAttack.func_75248_a(2);
                        } else {
                            aiAttack = new EntityAIAttackOnCollide(living, true);
                            aiAttack.func_75248_a(2);
                        }
                        EntityAIGoTo aiGoTo = new EntityAIGoTo(living, 1.2){

                            @Override
                            public boolean func_75250_a() {
                                IPuppetCapability thisCap;
                                return super.func_75250_a() && (thisCap = (IPuppetCapability)this.taskOwner.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) != null && !thisCap.getGuard();
                            }
                        };
                        aiGoTo.func_75248_a(3);
                        EntityAIFollowTarget aiFollow = new EntityAIFollowTarget(living, () -> {
                            Entity puppeteer = cap.getPuppeteer();
                            if (puppeteer instanceof EntityLivingBase) {
                                return (EntityLivingBase)puppeteer;
                            }
                            return null;
                        }, 1.2, 10.0f, 2.0f, true){

                            @Override
                            public boolean func_75250_a() {
                                IPuppetCapability thisCap;
                                return super.func_75250_a() && (thisCap = (IPuppetCapability)this.taskOwner.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) != null && !thisCap.getGuard();
                            }
                        };
                        aiFollow.func_75248_a(1);
                        if (aiGuardHome != null && aiWander != null) {
                            EntityAITasks tasks = EntityAIPuppet.addPuppetAI(() -> cap.getPuppeteer(), (EntityLivingBase)living, living.field_70714_bg);
                            tasks.func_75776_a(0, (EntityAIBase)aiSwim);
                            tasks.func_75776_a(1, (EntityAIBase)aiStay);
                            tasks.func_75776_a(2, (EntityAIBase)aiGuardHome);
                            tasks.func_75776_a(3, (EntityAIBase)aiFollow);
                            tasks.func_75776_a(4, (EntityAIBase)aiGoTo);
                            tasks.func_75776_a(5, (EntityAIBase)aiAttack);
                            tasks.func_75776_a(6, (EntityAIBase)aiWander);
                        } else {
                            EntityAITasks tasks = EntityAIPuppet.addPuppetAI(() -> cap.getPuppeteer(), (EntityLivingBase)living, living.field_70714_bg);
                            tasks.func_75776_a(0, (EntityAIBase)aiSwim);
                            tasks.func_75776_a(1, (EntityAIBase)aiStay);
                            tasks.func_75776_a(3, (EntityAIBase)aiFollow);
                            tasks.func_75776_a(4, (EntityAIBase)aiGoTo);
                            tasks.func_75776_a(5, (EntityAIBase)aiAttack);
                        }
                    } else {
                        EntityAIStay aiStay = PuppetHandler.getAI(EntityAIStay.class, puppetAI.getSubTasks());
                        if (aiStay != null) {
                            if (cap.getStay()) {
                                aiStay.setStay(true);
                                living.func_70624_b(null);
                            } else {
                                aiStay.setStay(false);
                            }
                        }
                    }
                }
            } else {
                if (entity.field_70170_p.field_73012_v.nextInt(5) == 0) {
                    BLParticles.SPAWNER.spawn(living.field_70170_p, living.field_70165_t + living.field_70159_w * 2.0, living.field_70163_u + (double)living.field_70131_O / 2.0, living.field_70161_v + living.field_70179_y * 2.0, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(living.field_70159_w + (double)((living.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f * entity.field_70130_N), (living.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f * entity.field_70131_O, living.field_70179_y + (double)((living.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f * entity.field_70130_N))).withData(40)).withColor(0.2f, 0.8f, 0.4f, 1.0f));
                }
                if (living.field_70173_aa % 50 == 0) {
                    Object args = ((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withScale(1.5f)).withColor(1.0f, 1.0f, 1.0f, 0.3f)).withData(living);
                    Particle particle = !cap.getStay() && !cap.getGuard() ? BLParticles.RING_OF_RECRUITMENT_FOLLOW.create(living.field_70170_p, 0.0, living.field_70131_O + 0.25f, 0.0, (ParticleFactory.ParticleArgs<?>)args) : (cap.getStay() ? BLParticles.RING_OF_RECRUITMENT_STAY.create(living.field_70170_p, 0.0, living.field_70131_O + 0.25f, 0.0, (ParticleFactory.ParticleArgs<?>)args) : BLParticles.RING_OF_RECRUITMENT_GUARD.create(living.field_70170_p, 0.0, living.field_70131_O + 0.25f, 0.0, (ParticleFactory.ParticleArgs<?>)args));
                    BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, particle);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        List<Entity> puppets;
        IPuppeteerCapability cap;
        DamageSource source;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (!attackedEntity.field_70170_p.field_72995_K && (source = event.getSource()).func_76346_g() instanceof EntityPlayer && (cap = (IPuppeteerCapability)source.func_76346_g().getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) != null && !(puppets = cap.getPuppets()).contains(attackedEntity)) {
            for (Entity entity : puppets) {
                if (!(entity instanceof EntityLiving)) continue;
                ((EntityLiving)entity).func_70624_b(attackedEntity);
            }
        }
    }

    private static <T extends EntityAIBase> T getAI(Class<T> cls, EntityAITasks tasks) {
        for (EntityAITasks.EntityAITaskEntry entry : tasks.field_75782_a) {
            if (!cls.isAssignableFrom(entry.field_75733_a.getClass())) continue;
            return (T)entry.field_75733_a;
        }
        return null;
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        IPuppetCapability cap;
        ItemStack ring;
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        if (event.getHand() == EnumHand.MAIN_HAND && player != null && player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && target instanceof EntityLiving && !(ring = ItemRingOfRecruitment.getActiveRing((Entity)player, null)).func_190926_b() && (cap = (IPuppetCapability)target.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) != null) {
            EntityLiving living = (EntityLiving)target;
            if (cap.hasPuppeteer()) {
                Entity puppeteer = cap.getPuppeteer();
                if (player == puppeteer) {
                    if (player.func_70093_af()) {
                        if (!player.field_70170_p.field_72995_K) {
                            cap.setRemainingTicks(0);
                        }
                        player.func_184609_a(EnumHand.MAIN_HAND);
                    } else {
                        if (!player.field_70170_p.field_72995_K) {
                            PuppetHandler.cycleAiState(living, cap, player, target.func_180425_c());
                        }
                        player.func_184609_a(EnumHand.MAIN_HAND);
                    }
                }
            } else if (!player.field_70170_p.field_72995_K) {
                int recruitmentCost = ((ItemRingOfRecruitment)ring.func_77973_b()).getRecruitmentCost((EntityLivingBase)living);
                if (ring.func_77952_i() <= ring.func_77958_k() - recruitmentCost) {
                    IPuppeteerCapability capPlayer = (IPuppeteerCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null);
                    if (capPlayer != null && capPlayer.getActivatingEntity() == null) {
                        capPlayer.setActivatingEntity((Entity)living);
                        capPlayer.setActivatingTicks(0);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.ring_of_recruitment.not_enough_power", new Object[0]), true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        IPuppeteerCapability cap;
        if (event.phase == TickEvent.Phase.END && (cap = (IPuppeteerCapability)event.player.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) != null) {
            Entity activatingEntity;
            ProtectionShield shield = cap.getShield();
            if (shield != null) {
                if (!event.player.field_70170_p.field_72995_K && !ItemRingOfRecruitment.isRingActive((Entity)event.player, null) && shield.hasShield()) {
                    for (int i = 0; i < 20; ++i) {
                        shield.setActive(i, false);
                    }
                }
                cap.updateShield();
            }
            if ((activatingEntity = cap.getActivatingEntity()) instanceof EntityLiving) {
                EntityLiving living = (EntityLiving)activatingEntity;
                if (!event.player.field_70170_p.field_72995_K) {
                    if (event.player.func_184614_ca().func_190926_b() && !event.player.field_82175_bq) {
                        if ((double)living.func_70032_d((Entity)event.player) > 5.0) {
                            cap.setActivatingEntity(null);
                            cap.setActivatingTicks(0);
                        } else {
                            cap.setActivatingTicks(cap.getActivatingTicks() + 1);
                            ItemRing.removeXp(event.player, 2);
                            if ((float)cap.getActivatingTicks() > living.func_110138_aP()) {
                                IPuppetCapability puppetCap;
                                UUID ringUuid;
                                ItemStack ring = ItemRingOfRecruitment.getActiveRing((Entity)event.player, null);
                                if (!ring.func_190926_b() && (ringUuid = ((ItemRingOfRecruitment)ring.func_77973_b()).getRingUuid(ring)) != null && (puppetCap = (IPuppetCapability)living.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null)) != null && !puppetCap.hasPuppeteer()) {
                                    int recruitmentCost = ((ItemRingOfRecruitment)ring.func_77973_b()).getRecruitmentCost((EntityLivingBase)living);
                                    if (ring.func_77952_i() <= ring.func_77958_k() - recruitmentCost) {
                                        ring.func_77964_b(ring.func_77952_i() + recruitmentCost);
                                        puppetCap.setRecruitmentCost(recruitmentCost);
                                        puppetCap.setPuppeteer((Entity)event.player);
                                        puppetCap.setRemainingTicks(Integer.MAX_VALUE);
                                        puppetCap.setRingUuid(ringUuid);
                                    }
                                }
                                cap.setActivatingEntity(null);
                                cap.setActivatingTicks(0);
                            }
                        }
                    } else {
                        cap.setActivatingEntity(null);
                        cap.setActivatingTicks(0);
                    }
                } else {
                    Vec3d vec = new Vec3d(living.field_70165_t - event.player.field_70165_t, living.field_70163_u + (double)(living.func_70047_e() * 0.8f) - (event.player.field_70163_u + (double)(event.player.func_70047_e() * 0.8f)), living.field_70161_v - event.player.field_70161_v);
                    vec = vec.func_72432_b();
                    vec = vec.func_72441_c((double)((event.player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 3.0f), (double)((event.player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 3.0f), (double)((event.player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 3.0f));
                    vec = vec.func_72432_b();
                    double dist = event.player.func_70032_d((Entity)living);
                    vec = vec.func_186678_a(dist / 15.0);
                    BLParticles.SPAWNER.spawn(event.player.field_70170_p, event.player.field_70165_t, event.player.field_70163_u + (double)(event.player.func_70047_e() * 0.8f), event.player.field_70161_v, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(40)).withColor(0.2f, 0.8f, 0.4f, 1.0f)).withMotion(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
                }
                event.player.field_70159_w *= 0.05;
                event.player.field_70179_y *= 0.05;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        EntityPlayer player;
        IPuppeteerCapability cap;
        if (event.getHand() == EnumHand.MAIN_HAND && event instanceof PlayerInteractEvent.RightClickBlock && event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && ItemRingOfRecruitment.isRingActive((Entity)event.getEntityPlayer(), null) && (cap = (IPuppeteerCapability)(player = event.getEntityPlayer()).getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) != null) {
            List<Entity> puppets = cap.getPuppets();
            BlockPos target = event.getPos().func_177972_a(event.getFace());
            boolean ordered = false;
            for (Entity puppet : puppets) {
                if (!(puppet instanceof EntityLiving)) continue;
                EntityLiving living = (EntityLiving)puppet;
                if (!player.field_70170_p.field_72995_K) {
                    EntityAIGoTo aiGoTo;
                    EntityAIPuppet puppetAI = EntityAIPuppet.getPuppetAI(living.field_70714_bg);
                    if (puppetAI != null && (aiGoTo = PuppetHandler.getAI(EntityAIGoTo.class, puppetAI.getSubTasks())) != null) {
                        aiGoTo.setTarget(target);
                    }
                    living.func_70624_b(null);
                }
                ordered = true;
            }
            if (ordered) {
                player.func_184609_a(EnumHand.MAIN_HAND);
                if (player.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 4; ++i) {
                        BLParticles.SPAWNER.spawn(player.field_70170_p, (double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f, (player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f, (player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f)).withData(30)).withColor(0.2f, 0.8f, 0.25f, 1.0f));
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        ProtectionShield shield;
        IPuppeteerCapability cap;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && player != null && player.func_70093_af() && (cap = (IPuppeteerCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) != null && (shield = cap.getShield()) != null && shield.hasShield()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            PuppetHandler.renderShield(shield, cap, (EntityPlayer)player, event.getPartialTicks(), 0.4f, 1.0f, false);
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        ProtectionShield shield;
        IPuppeteerCapability cap;
        EntityPlayer player = event.getEntityPlayer();
        if ((Minecraft.func_71410_x().field_71474_y.field_74320_O != 0 || player != Minecraft.func_71410_x().field_71439_g) && (cap = (IPuppeteerCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PUPPETEER, null)) != null && (shield = cap.getShield()) != null && shield.hasShield()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + 1.0), (double)event.getZ());
            PuppetHandler.renderShield(shield, cap, event.getEntityPlayer(), event.getPartialRenderTick(), 1.0f, player.func_70093_af() ? 1.0f : 0.15f, player.func_70093_af());
            GlStateManager.func_179121_F();
        }
    }

    private static void renderShield(ProtectionShield shield, IPuppeteerCapability cap, EntityPlayer player, float partialTicks, float insideAlpha, float alpha, boolean depthMask) {
        float ticks = (float)cap.getPrevShieldRotationTicks() + (float)(cap.getShieldRotationTicks() - cap.getPrevShieldRotationTicks()) * partialTicks;
        RenderFortressBoss.renderShield(shield, player.func_174791_d().func_72441_c(0.0, 1.0, 0.0), shield.getYaw(ticks), shield.getPitch(ticks), shield.getRoll(ticks), 0.15f, player.field_70173_aa, partialTicks, true, true, insideAlpha, insideAlpha * 0.45f, alpha, depthMask);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLivingPre(RenderLivingEvent.Pre<EntityLivingBase> event) {
        EntityLivingBase living = event.getEntity();
        IPuppetCapability cap = (IPuppetCapability)living.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
        if (cap != null && cap.hasPuppeteer() && !RenderUtils.doesRendererHaveLayer(event.getRenderer(), LayerPuppetOverlay.class, false)) {
            event.getRenderer().func_177094_a((LayerRenderer)new LayerPuppetOverlay((RenderLivingBase<EntityLivingBase>)event.getRenderer()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLivingPost(RenderLivingEvent.Post<EntityLivingBase> event) {
        Entity puppeteer;
        EntityLivingBase living = event.getEntity();
        IPuppetCapability cap = (IPuppetCapability)living.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
        if (cap != null && cap.hasPuppeteer() && (puppeteer = cap.getPuppeteer()) != null && (!cap.getStay() && !cap.getGuard() || puppeteer.func_70032_d((Entity)living) < 6.0f)) {
            event.getRenderer().func_110776_a(LayerPuppetOverlay.OVERLAY_TEXTURE);
            float alpha = 0.25f;
            if (cap.getStay() || cap.getGuard()) {
                alpha *= 1.0f - Math.max(0.0f, puppeteer.func_70032_d((Entity)living) - 3.0f) / 3.0f;
            }
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)(((float)living.field_70173_aa + WorldRenderHandler.getPartialTicks()) / 40.0f), (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)4.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179092_a((int)516, (float)0.001f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)false);
            float animationTimer = (float)living.field_70173_aa + event.getPartialRenderTick();
            float colorSine = (MathHelper.func_76134_b((float)(animationTimer * 0.1f)) + 1.0f) * 0.3f;
            GlStateManager.func_179131_c((float)colorSine, (float)(1.25f - colorSine), (float)2.0f, (float)(alpha *= (MathHelper.func_76126_a((float)(animationTimer * 0.0333333f)) + 1.0f) * 0.25f + 0.3f));
            double dx = puppeteer.field_70142_S + (puppeteer.field_70165_t - puppeteer.field_70142_S) * (double)WorldRenderHandler.getPartialTicks() - (living.field_70142_S + (living.field_70165_t - living.field_70142_S) * (double)WorldRenderHandler.getPartialTicks());
            double dy = (double)(-living.field_70131_O / 2.0f) + (double)puppeteer.field_70131_O / 2.0 + puppeteer.field_70137_T + (puppeteer.field_70163_u - puppeteer.field_70137_T) * (double)WorldRenderHandler.getPartialTicks() - (living.field_70137_T + (living.field_70163_u - living.field_70137_T) * (double)WorldRenderHandler.getPartialTicks());
            double dz = puppeteer.field_70136_U + (puppeteer.field_70161_v - puppeteer.field_70136_U) * (double)WorldRenderHandler.getPartialTicks() - (living.field_70136_U + (living.field_70161_v - living.field_70136_U) * (double)WorldRenderHandler.getPartialTicks());
            double sx = event.getX();
            double sy = event.getY() + (double)(living.field_70131_O / 2.0f);
            double sz = event.getZ();
            float sw = 0.03f;
            float ew = 0.01f;
            double ticks = ((float)living.field_70173_aa + WorldRenderHandler.getPartialTicks()) / 5.0f;
            double prevXOffset = 0.0;
            double prevYOffset = 0.0;
            double prevZOffset = 0.0;
            int iter = Minecraft.func_71375_t() ? 8 : 4;
            for (int i = 0; i < iter; ++i) {
                double multiplier = (1.0 - Math.abs((double)(i + 1) - (double)iter / 2.0) / (double)iter * 2.0) * 0.15;
                double xOffset = Math.cos((double)((float)(i + 1) * 4.0f / (float)iter) + ticks) * multiplier;
                double yOffset = Math.cos((double)((float)(i + 1) * 4.0f / (float)iter) + ticks + Math.PI) * multiplier;
                double zOffset = Math.sin((double)((float)(i + 1) * 4.0f / (float)iter) + ticks) * multiplier;
                RenderSwordEnergy.renderBeam(new Vec3d(sx + prevXOffset + dx / (double)iter * (double)i, sy + prevYOffset + dy / (double)iter * (double)i, sz + prevZOffset + dz / (double)iter * (double)i), new Vec3d(sx + xOffset + dx / (double)iter * (double)(i + 1), sy + yOffset + dy / (double)iter * (double)(i + 1), sz + zOffset + dz / (double)iter * (double)(i + 1)), ew + sw - sw / (float)iter * (float)i, ew + sw - sw / (float)iter * (float)(i + 1), i == 0, i == iter - 1);
                prevXOffset = xOffset;
                prevYOffset = yOffset;
                prevZOffset = zOffset;
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179089_o();
            GlStateManager.func_179098_w();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

