/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.capability.equipment.EquipmentHelper;
import thebetweenlands.common.network.serverbound.MessageEquipItem;
import thebetweenlands.common.registries.CapabilityRegistry;

public class ItemEquipmentHandler {
    private ItemEquipmentHandler() {
    }

    @SubscribeEvent
    public static void onLivingUpdated(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (!entity.getEntityData().func_74767_n("thebetweenlands.has_no_equipment")) {
            IEquipmentCapability cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            if (cap != null) {
                for (EnumEquipmentInventory invType : EnumEquipmentInventory.VALUES) {
                    IInventory inventory = cap.getInventory(invType);
                    if (!(inventory instanceof ITickable)) continue;
                    ((ITickable)inventory).func_73660_a();
                }
                if ((entity.field_70173_aa + entity.func_145782_y()) % 100 == 0) {
                    boolean hasEquipment = false;
                    block1: for (EnumEquipmentInventory invType : EnumEquipmentInventory.VALUES) {
                        IInventory inventory = cap.getInventory(invType);
                        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                            if (inventory.func_70301_a(i).func_190926_b()) continue;
                            hasEquipment = true;
                            break block1;
                        }
                    }
                    if (!hasEquipment) {
                        entity.getEntityData().func_74757_a("thebetweenlands.has_no_equipment", true);
                    }
                }
            } else {
                entity.getEntityData().func_74757_a("thebetweenlands.has_no_equipment", true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        if (player != null && target != null && !(target instanceof EntityPlayer)) {
            ItemStack heldItem = event.getItemStack();
            if (!player.func_70093_af() && !heldItem.func_190926_b()) {
                ItemStack result;
                IEquippable equippable;
                if (heldItem.func_77973_b() instanceof IEquippable && (equippable = (IEquippable)heldItem.func_77973_b()).canEquipOnRightClick(heldItem, player, target) && ((result = EquipmentHelper.equipItem(player, target, heldItem, false)).func_190926_b() || result.func_190916_E() != heldItem.func_190916_E())) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184611_a(event.getHand(), result);
                    }
                    player.func_184609_a(event.getHand());
                }
            } else if (player.func_70093_af() && heldItem.func_190926_b() && EquipmentHelper.tryPlayerUnequip(player, target)) {
                player.func_184609_a(EnumHand.MAIN_HAND);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            ItemEquipmentHandler.tryEquip(player, event.getHand(), false);
        } else if (event instanceof PlayerInteractEvent.RightClickEmpty && !ItemEquipmentHandler.tryEquip(player, EnumHand.MAIN_HAND, true)) {
            ItemEquipmentHandler.tryEquip(player, EnumHand.OFF_HAND, true);
        }
    }

    private static boolean tryEquip(EntityPlayer player, EnumHand hand, boolean packet) {
        IEquippable equippable;
        ItemStack heldItem = player.func_184586_b(hand);
        if (player != null && !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof IEquippable && (equippable = (IEquippable)heldItem.func_77973_b()).canEquipOnRightClick(heldItem, player, (Entity)player)) {
            if (packet) {
                ItemStack result;
                if (player.field_70170_p.field_72995_K && ((result = EquipmentHelper.equipItem(player, (Entity)player, heldItem, true)).func_190926_b() || result.func_190916_E() != heldItem.func_190916_E())) {
                    if (hand == EnumHand.OFF_HAND) {
                        TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageEquipItem(-1, (Entity)player));
                        player.func_184609_a(hand);
                        return true;
                    }
                    int slot = player.field_71071_by.func_184429_b(heldItem);
                    if (slot >= 0) {
                        TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageEquipItem(slot, (Entity)player));
                        player.func_184609_a(hand);
                        return true;
                    }
                }
            } else if (player.field_70170_p.field_72995_K) {
                ItemStack result = EquipmentHelper.equipItem(player, (Entity)player, heldItem, true);
                if (result.func_190926_b() || result.func_190916_E() != heldItem.func_190916_E()) {
                    player.func_184609_a(hand);
                    return true;
                }
            } else {
                ItemStack result = EquipmentHelper.equipItem(player, (Entity)player, heldItem, false);
                if (result.func_190926_b() || result.func_190916_E() != heldItem.func_190916_E()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184611_a(hand, result);
                    }
                    player.func_184609_a(hand);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.equipment.equipped", new Object[]{new TextComponentTranslation(heldItem.func_77977_a() + ".name", new Object[0])}), true);
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onDeathDrops(LivingDropsEvent event) {
        IEquipmentCapability cap;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && !entity.field_70170_p.field_72995_K && !entity.field_70170_p.func_82736_K().func_82766_b("keepInventory") && (cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) != null) {
            for (EnumEquipmentInventory type : EnumEquipmentInventory.VALUES) {
                IInventory inv = cap.getInventory(type);
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    if (stack.func_77973_b() instanceof IEquippable) {
                        IEquippable equippable = (IEquippable)stack.func_77973_b();
                        equippable.onUnequip(stack, (Entity)entity, inv);
                        if (!equippable.canDrop(stack, (Entity)entity, inv)) continue;
                    }
                    EntityItem equipmentDrop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, stack.func_77946_l());
                    equipmentDrop.func_174869_p();
                    event.getDrops().add(equipmentDrop);
                }
            }
        }
    }
}

