/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.api.entity.IBLBoss;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityCameraOffset;
import thebetweenlands.api.entity.IEntityMusic;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.mobs.EntityPeatMummy;
import thebetweenlands.common.entity.projectiles.EntitySludgeBall;
import thebetweenlands.common.network.clientbound.MessageSummonPeatMummyParticles;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.sound.BLSoundEvent;

public class EntityDreadfulMummy
extends EntityMob
implements IEntityBL,
IBLBoss,
IEntityScreenShake,
IEntityCameraOffset,
IEntityMusic {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    public static final IAttribute SPAWN_LENGTH_ATTRIB = new RangedAttribute(null, "bl.spawnLength", 180.0, 0.0, 2.147483647E9).func_111117_a("Spawning Length");
    public static final IAttribute SPAWN_OFFSET_ATTRIB = new RangedAttribute(null, "bl.spawnOffset", 3.0, -2.147483647E9, 2.147483647E9).func_111117_a("Spawning Y Offset");
    private static final DataParameter<Integer> SPAWNING_STATE_DW = EntityDataManager.func_187226_a(EntityDreadfulMummy.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PREY = EntityDataManager.func_187226_a(EntityDreadfulMummy.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> Y_OFFSET = EntityDataManager.func_187226_a(EntityDreadfulMummy.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> BOSSINFO_ID = EntityDataManager.func_187226_a(EntityDreadfulMummy.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final int BREAK_COUNT = 20;
    private static final int SPAWN_MUMMY_COOLDOWN = 350;
    private int untilSpawnMummy = 0;
    private static final int SPAWN_SLUDGE_COOLDOWN = 150;
    private int untilSpawnSludge = 0;
    private float prevYOffset;
    private int eatPreyTimer = 60;
    public EntityLivingBase currentEatPrey;
    public int deathTicks = 0;

    public EntityDreadfulMummy(World world) {
        super(world);
        this.func_70105_a(1.1f, 2.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPAWNING_STATE_DW, (Object)0);
        this.field_70180_af.func_187214_a(PREY, (Object)0);
        this.field_70180_af.func_187214_a(Y_OFFSET, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(BOSSINFO_ID, (Object)Optional.absent());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(550.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SPAWN_LENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(SPAWN_OFFSET_ATTRIB);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.DREADFUL_PEAT_MUMMY_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.DREADFUL_PEAT_MUMMY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.DREADFUL_PEAT_MUMMY_DEATH;
    }

    public double func_70033_W() {
        return ((Float)this.field_70180_af.func_187225_a(Y_OFFSET)).floatValue();
    }

    public void setYOffset(float yOffset) {
        this.field_70180_af.func_187227_b(Y_OFFSET, (Object)Float.valueOf(yOffset));
    }

    public float getCurrentOffset() {
        return (float)(-this.getSpawnOffset() + (double)this.getSpawningProgress() * this.getSpawnOffset());
    }

    public double getSpawnOffset() {
        return this.func_110148_a(SPAWN_OFFSET_ATTRIB).func_111126_e();
    }

    public int getSpawningState() {
        return (Integer)this.field_70180_af.func_187225_a(SPAWNING_STATE_DW);
    }

    public int getSpawningLength() {
        return (int)this.func_110148_a(SPAWN_LENGTH_ATTRIB).func_111126_e();
    }

    public float getSpawningProgress() {
        if (this.getSpawningLength() == 0) {
            return 1.0f;
        }
        return 1.0f / (float)this.getSpawningLength() * (float)this.getSpawningState();
    }

    public float getSpawningProgress(float delta) {
        if (this.getSpawningLength() == 0) {
            return 1.0f;
        }
        return 1.0f / (float)this.getSpawningLength() * ((float)this.getSpawningState() + (this.getSpawningState() == this.getSpawningLength() ? 0.0f : delta));
    }

    public float getInterpolatedYOffsetProgress(float partialTicks) {
        return this.prevYOffset + ((float)this.func_70033_W() - this.prevYOffset) * partialTicks;
    }

    public void updateSpawningState() {
        int spawningState = this.getSpawningState();
        if (spawningState < this.getSpawningLength()) {
            this.field_70180_af.func_187227_b(SPAWNING_STATE_DW, (Object)(spawningState + 1));
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_191958_b(float strafe, float up, float forward, float friction) {
        float swimSpeedBoost = 10.0f;
        float f = strafe * strafe + up * up + forward * forward;
        if (f >= 1.0E-4f) {
            if ((f = MathHelper.func_76129_c((float)f)) < 1.0f) {
                f = 1.0f;
            }
            f = friction / f;
            strafe *= f;
            up *= f;
            forward *= f;
            if (this.func_70090_H() || this.func_180799_ab()) {
                strafe = strafe * (float)this.func_110148_a(SWIM_SPEED).func_111126_e() * 10.0f;
                up *= (float)this.func_110148_a(SWIM_SPEED).func_111126_e();
                forward = forward * (float)this.func_110148_a(SWIM_SPEED).func_111126_e() * 10.0f;
            }
            float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            this.field_70159_w += (double)(strafe * f2 - forward * f1);
            this.field_70181_x += (double)up;
            this.field_70179_y += (double)(forward * f2 + strafe * f1);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BOSSINFO_ID, (Object)Optional.of((Object)this.bossInfo.func_186737_d()));
        }
    }

    public void func_70071_h_() {
        BlockPos pos;
        super.func_70071_h_();
        this.prevYOffset = (float)this.func_70033_W();
        EntityLivingBase prey = this.getPrey();
        if (prey instanceof EntityLivingBase) {
            this.currentEatPrey = prey;
            if (this.currentEatPrey != null) {
                this.updateEatPrey();
            }
        } else {
            this.currentEatPrey = null;
        }
        if (this.func_130014_f_().field_72995_K) {
            if (this.getSpawningProgress() < 1.0f) {
                this.setYOffset(this.getCurrentOffset());
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.getSpawningState() == this.getSpawningLength() - 1) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                int breakPoint = this.getSpawningLength() / 20;
                if ((this.getSpawningState() - breakPoint / 2 - 1) % breakPoint == 0) {
                    pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                    IBlockState state = this.func_130014_f_().func_180495_p(pos);
                    double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    double py = this.field_70163_u + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                    double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    int amount = this.field_70146_Z.nextInt(20) + 15;
                    for (int i = 0; i < amount; ++i) {
                        double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                        double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            } else if (this.deathTicks == 0) {
                this.setYOffset(0.0f);
            } else if (this.deathTicks > 60) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.deathTicks % 5 == 0) {
                    BlockPos pos2 = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                    IBlockState state = this.func_130014_f_().func_180495_p(pos2);
                    double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    double py = this.field_70163_u + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                    double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    int amount = this.field_70146_Z.nextInt(20) + 15;
                    for (int i = 0; i < amount; ++i) {
                        double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                        double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
        } else {
            if (this.deathTicks > 60) {
                this.setYOffset((float)(-(this.deathTicks - 60)) * 0.05f);
            }
            if (this.getSpawningProgress() < 1.0f) {
                if (this.getSpawningState() == 0) {
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_EMERGE, SoundCategory.HOSTILE, 1.2f, 1.0f);
                }
                this.updateSpawningState();
                this.setYOffset(this.getCurrentOffset());
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70133_I = true;
                int breakPoint = this.getSpawningLength() / 20;
                if ((this.getSpawningState() - breakPoint / 2 - 1) % breakPoint == 0) {
                    pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                    IBlockState blockState = this.field_70170_p.func_180495_p(pos);
                    this.func_184185_a(blockState.func_177230_c().getSoundType(blockState, this.field_70170_p, pos, (Entity)this).func_185845_c(), this.field_70146_Z.nextFloat() * 0.3f + 0.3f, this.field_70146_Z.nextFloat() * 0.15f + 0.7f);
                }
                if (this.func_70638_az() != null) {
                    this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 360.0f);
                }
                if (this.getSpawningState() == this.getSpawningLength() - 1) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
            } else if (this.deathTicks < 60) {
                this.setYOffset(0.0f);
                this.prevYOffset = 0.0f;
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70089_S() && this.getSpawningProgress() >= 1.0f) {
            if (this.field_70173_aa % 12 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.field_70170_p.func_72890_a((Entity)this, 32.0) == null) {
                this.func_70691_i(1.0f);
            }
            if (this.func_70638_az() != null) {
                AxisAlignedBB checkAABB = this.func_174813_aQ().func_72321_a(64.0, 64.0, 64.0);
                List peatMummies = this.func_130014_f_().func_72872_a(EntityPeatMummy.class, checkAABB);
                int mummies = 0;
                for (EntityPeatMummy mummy : peatMummies) {
                    if (!((double)mummy.func_70032_d((Entity)this) <= 64.0) || !mummy.isSpawningFinished()) continue;
                    ++mummies;
                }
                if (mummies < 4 && this.untilSpawnMummy <= 0) {
                    this.spawnMummy();
                }
                if (this.untilSpawnSludge <= 0) {
                    this.spawnSludge();
                }
            }
            if (this.untilSpawnMummy > 0) {
                --this.untilSpawnMummy;
            }
            if (this.untilSpawnSludge > 0) {
                --this.untilSpawnSludge;
            }
            if (this.eatPreyTimer > 0 && this.currentEatPrey != null) {
                --this.eatPreyTimer;
            }
            if (this.eatPreyTimer <= 0) {
                this.setPrey(null);
                this.eatPreyTimer = 60;
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    private void spawnMummy() {
        EntityPeatMummy mummy = new EntityPeatMummy(this.func_130014_f_());
        mummy.func_70107_b(this.field_70165_t + (double)(this.field_70146_Z.nextInt(6) - 3), this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextInt(6) - 3));
        if (mummy.func_130014_f_().func_72855_b(mummy.func_174813_aQ()) && mummy.func_130014_f_().func_184144_a((Entity)mummy, mummy.func_174813_aQ()).isEmpty()) {
            this.untilSpawnMummy = 350;
            mummy.func_70624_b(this.func_70638_az());
            mummy.func_70606_j(30.0f);
            this.func_130014_f_().func_72838_d((Entity)mummy);
            mummy.setCarryShimmerstone(false);
            mummy.setBossMummy(true);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_SCREAM, SoundCategory.HOSTILE, 1.0f, 1.0f);
            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageSummonPeatMummyParticles((Entity)mummy), new NetworkRegistry.TargetPoint(this.field_71093_bK, mummy.field_70165_t, mummy.field_70163_u, mummy.field_70161_v, 64.0));
        } else {
            this.untilSpawnMummy = 1;
        }
    }

    private void spawnSludge() {
        this.untilSpawnSludge = 150;
        if (this.func_70638_az() != null) {
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 360.0f);
        }
        Vec3d look = this.func_70040_Z();
        double direction = Math.toRadians(this.field_70761_aq);
        EntitySludgeBall sludge = new EntitySludgeBall(this.func_130014_f_(), (EntityLivingBase)this);
        sludge.func_70107_b(this.field_70165_t - Math.sin(direction) * 3.5, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + Math.cos(direction) * 3.5);
        sludge.field_70159_w = look.field_72450_a * 0.5;
        sludge.field_70181_x = look.field_72448_b;
        sludge.field_70179_y = look.field_72449_c * 0.5;
        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_RETCH, SoundCategory.HOSTILE, 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
        this.func_130014_f_().func_72838_d((Entity)sludge);
    }

    public boolean func_70652_k(Entity target) {
        if (this.getSpawningProgress() < 1.0f || this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        boolean attacked = super.func_70652_k(target);
        if (!(!attacked || this.field_70146_Z.nextInt(6) != 0 || target == this.currentEatPrey || !(target instanceof EntityLivingBase) || target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75098_d || this.func_130014_f_().field_72995_K)) {
            this.setPrey((EntityLivingBase)target);
        }
        if (attacked) {
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_SWIPE, SoundCategory.HOSTILE, 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
        }
        return attacked;
    }

    private void updateEatPrey() {
        double direction = Math.toRadians(this.field_70761_aq);
        this.currentEatPrey.func_70080_a(this.field_70165_t - Math.sin(direction) * 1.7, this.field_70163_u + 0.25, this.field_70161_v + Math.cos(direction) * 1.7, (float)(Math.toDegrees(direction) + 180.0), 0.0f);
        this.currentEatPrey.field_70177_z = this.currentEatPrey.field_70126_B = (float)(Math.toDegrees(direction) + 180.0);
        this.currentEatPrey.field_70758_at = this.currentEatPrey.field_70126_B;
        this.currentEatPrey.field_70759_as = this.currentEatPrey.field_70126_B;
        this.currentEatPrey.field_70143_R = 0.0f;
        if (this.field_70173_aa % 10 == 0 && !this.func_130014_f_().field_72995_K) {
            this.currentEatPrey.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_BITE, SoundCategory.HOSTILE, 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
        }
        if (!this.currentEatPrey.func_70089_S() && !this.func_130014_f_().field_72995_K) {
            this.setPrey(null);
        }
    }

    private void setPrey(EntityLivingBase prey) {
        if (prey == null) {
            this.field_70180_af.func_187227_b(PREY, (Object)-1);
        } else {
            this.field_70180_af.func_187227_b(PREY, (Object)prey.func_145782_y());
        }
    }

    private EntityLivingBase getPrey() {
        Entity prey;
        int id = (Integer)this.field_70180_af.func_187225_a(PREY);
        Entity entity = prey = id != -1 ? this.func_130014_f_().func_73045_a(id) : null;
        if (prey instanceof EntityLivingBase) {
            return (EntityLivingBase)prey;
        }
        return null;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.currentEatPrey != null && source.func_76346_g() == this.currentEatPrey) {
            return false;
        }
        if (this.getSpawningProgress() < 1.0f) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70609_aI() {
        this.bossInfo.func_186735_a(0.0f);
        if (this.deathTicks == 0 && !this.func_130014_f_().field_72995_K) {
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_DEATH, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        ++this.deathTicks;
        if (!this.func_130014_f_().field_72995_K) {
            int xp;
            int dropXP;
            this.field_70165_t = this.field_70142_S;
            this.field_70163_u = this.field_70137_T;
            this.field_70161_v = this.field_70136_U;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (this.deathTicks > 40 && this.deathTicks % 5 == 0) {
                for (xp = 100; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
            }
            if (this.deathTicks == 80) {
                for (xp = 1200; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
            }
            if (this.deathTicks > 120) {
                this.func_70106_y();
            }
        }
        if (this.deathTicks > 80 && this.func_130014_f_().field_72995_K && this.deathTicks % 5 == 0) {
            for (int xo = -1; xo <= 1; ++xo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    int x = MathHelper.func_76128_c((double)this.field_70165_t) + xo;
                    int y = MathHelper.func_76128_c((double)(this.field_70163_u - this.func_70033_W() - 0.1));
                    int z = MathHelper.func_76128_c((double)this.field_70161_v) + zo;
                    IBlockState state = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z));
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150350_a) continue;
                    double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    double py = this.field_70163_u - this.func_70033_W() + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                    double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), block.getSoundType(state, this.func_130014_f_(), this.func_180425_c().func_177977_b(), null).func_185845_c(), SoundCategory.BLOCKS, this.field_70146_Z.nextFloat() * 0.3f + 0.3f, this.field_70146_Z.nextFloat() * 0.15f + 0.7f);
                    int amount = this.field_70146_Z.nextInt(20) + 10;
                    for (int i = 0; i < amount; ++i) {
                        double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                        double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox + (double)xo, py, pz + oz + (double)zo, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.func_70089_S()) {
            super.func_70100_b_(player);
        }
    }

    public boolean func_70104_M() {
        return this.func_70089_S() && this.getSpawningProgress() >= 1.0f && super.func_70104_M();
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    protected boolean func_70610_aX() {
        return this.func_70089_S() && super.func_70610_aX();
    }

    @Override
    public float getShakeIntensity(Entity viewer, float partialTicks) {
        if (this.deathTicks > 0) {
            double dist = this.func_70032_d(viewer);
            float screamMult = (float)(1.0 - dist / 30.0);
            if (dist >= 30.0) {
                return 0.0f;
            }
            return (float)((Math.sin((double)this.deathTicks / 120.0 * Math.PI) + (double)0.1f) * (double)0.15f * (double)screamMult);
        }
        return 0.0f;
    }

    @Override
    public boolean applyOffset(Entity view, float partialTicks) {
        if (this.currentEatPrey == view) {
            double direction = Math.toRadians(this.field_70760_ar + (this.field_70761_aq - this.field_70760_ar) * partialTicks);
            view.field_70126_B = view.field_70177_z = (float)(Math.toDegrees(direction) + 180.0);
            view.field_70125_A = 0.0f;
            view.field_70127_C = 0.0f;
            view.func_70034_d((float)(Math.toDegrees(direction) + 180.0));
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("spawningState", this.getSpawningState());
        nbt.func_74768_a("deathTicks", this.deathTicks);
        nbt.func_74780_a("initialPosY", this.field_70163_u);
        nbt.func_74776_a("previousYOffset", this.prevYOffset);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.deathTicks = nbt.func_74762_e("deathTicks");
        this.field_70163_u = nbt.func_74769_h("initialPosY");
        this.setYOffset(nbt.func_74760_g("previousYOffset"));
        this.field_70180_af.func_187227_b(SPAWNING_STATE_DW, (Object)nbt.func_74762_e("spawningState"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.DREADFUL_PEAT_MUMMY;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public BLSoundEvent getMusicFile(EntityPlayer listener) {
        return SoundRegistry.DREADFUL_PEAT_MUMMY_LOOP;
    }

    @Override
    public double getMusicRange(EntityPlayer listener) {
        return 32.0;
    }

    @Override
    public boolean isMusicActive(EntityPlayer listener) {
        return this.func_70089_S();
    }

    @Override
    public int getMusicLayer(EntityPlayer listener) {
        return 1;
    }

    @Override
    public UUID getBossInfoUuid() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(BOSSINFO_ID)).or((Object)new UUID(0L, 0L));
    }
}

