/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.ai.EntityAIFlyingWander;
import thebetweenlands.common.entity.mobs.EntityFlyingMob;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityChiromaw
extends EntityFlyingMob
implements IEntityBL {
    private static final DataParameter<Boolean> IS_HANGING = EntityDataManager.func_187226_a(EntityChiromaw.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityChiromaw(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.9f);
        this.setIsHanging(false);
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
        this.func_184644_a(PathNodeType.FENCE, -8.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFlyingWander((EntityCreature)this, 0.5));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(160));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HANGING, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.field_70703_bu && this.func_70090_H()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 1.0);
        }
        if (this.getIsHanging()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.field_70163_u = (double)MathHelper.func_76128_c((double)this.field_70163_u) + 1.0 - (double)this.field_70131_O;
        }
        if (this.field_70181_x < 0.0 && this.func_70638_az() == null) {
            this.field_70181_x *= 0.25;
        }
        if (this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).isSideSolid((IBlockAccess)this.func_130014_f_(), this.func_180425_c().func_177977_b(), EnumFacing.UP)) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 1.0);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getIsHanging()) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70765_h.func_75642_a(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0);
                if (this.field_70146_Z.nextInt(250) == 0 || !this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v)).func_185915_l()) {
                    this.setIsHanging(false);
                    this.field_70170_p.func_180498_a(null, 1025, this.func_180425_c(), 0);
                } else if (this.func_70638_az() != null) {
                    this.setIsHanging(false);
                    this.field_70170_p.func_180498_a(null, 1025, this.func_180425_c(), 0);
                }
            }
        } else if (this.func_70638_az() == null && !this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(20) == 0 && this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v)).func_185915_l()) {
            this.setIsHanging(true);
        }
    }

    public boolean getIsHanging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HANGING);
    }

    public void setIsHanging(boolean hanging) {
        this.field_70180_af.func_187227_b(IS_HANGING, (Object)hanging);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.CHIROMAW;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.FLYING_FIEND_LIVING;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundRegistry.FLYING_FIEND_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.FLYING_FIEND_DEATH;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.095);
    }

    public boolean func_70652_k(Entity entityIn) {
        return EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, entityIn);
    }

    public int func_70641_bl() {
        return 3;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

