/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import thebetweenlands.common.entity.movement.FlightMoveHelper;

public class EntityAIFlyingWander
extends EntityAIBase {
    protected final EntityCreature entity;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int executionChance;
    protected boolean mustUpdate;

    public EntityAIFlyingWander(EntityCreature creatureIn, double speedIn) {
        this(creatureIn, speedIn, 10);
    }

    public EntityAIFlyingWander(EntityCreature creatureIn, double speedIn, int chance) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.mustUpdate && this.entity.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3d randomPosition = this.getPosition();
        if (randomPosition == null) {
            return false;
        }
        BlockPos groundHeight = FlightMoveHelper.getGroundHeight(this.entity.field_70170_p, new BlockPos(randomPosition), 8, new BlockPos(0, 0, 0));
        if (randomPosition.field_72448_b - (double)groundHeight.func_177956_o() >= 8.0) {
            randomPosition = randomPosition.func_72441_c(0.0, -6.0, 0.0);
        }
        this.x = randomPosition.field_72450_a;
        this.y = randomPosition.field_72448_b;
        this.z = randomPosition.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vec3d getPosition() {
        return RandomPositionGenerator.func_75463_a((EntityCreature)this.entity, (int)15, (int)4);
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f() && !this.entity.func_70605_aq().func_75640_a();
    }

    public void func_75249_e() {
        if (!this.entity.func_70605_aq().func_75640_a()) {
            this.entity.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed);
        }
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }
}

