/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.client.audio.MovingWallSound;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationSludgeWormDungeon;

public class EntityMovingWall
extends Entity
implements IEntityScreenShake,
IEntityAdditionalSpawnData {
    private static final DataParameter<Boolean> IS_NEW_SPAWN = EntityDataManager.func_187226_a(EntityMovingWall.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HOLD_STILL = EntityDataManager.func_187226_a(EntityMovingWall.class, (DataSerializer)DataSerializers.field_187198_h);
    public Entity ignoreEntity;
    private int ignoreTime;
    private int holdCount;
    public boolean playSlideSound = true;
    private int prev_shake_timer;
    private int shake_timer;
    private boolean shaking = false;
    private int shakingTimerMax = 20;
    public static final Set<Block> UNBREAKABLE_BLOCKS = new HashSet<Block>();
    protected float speed = 0.05f;
    protected boolean isBlockAligned = true;
    protected boolean isDungeonWall = false;

    public EntityMovingWall(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityMovingWall(World world, boolean isDungeonWall) {
        this(world);
        this.isDungeonWall = isDungeonWall;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_NEW_SPAWN, (Object)true);
        this.field_70180_af.func_187214_a(HOLD_STILL, (Object)false);
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.field_70173_aa == 1 && this.isNewSpawn()) {
                this.checkSpawnArea();
            }
            if (this.field_70173_aa == 2) {
                this.doJankSafetyCheck();
            }
            if (this.isHoldingStill()) {
                --this.holdCount;
                if (this.holdCount <= 0) {
                    this.setHoldStill(false);
                    this.holdCount = 20;
                }
            }
        }
        this.calculateAllCollisions(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
        this.calculateAllCollisions(this.field_70165_t, this.field_70163_u - 0.5, this.field_70161_v);
        this.calculateAllCollisions(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v);
        if (this.func_174811_aO() == EnumFacing.NORTH || this.func_174811_aO() == EnumFacing.SOUTH) {
            this.calculateAllCollisions(this.field_70165_t - 1.0, this.field_70163_u + 0.5, this.field_70161_v);
            this.calculateAllCollisions(this.field_70165_t - 1.0, this.field_70163_u - 0.5, this.field_70161_v);
            this.calculateAllCollisions(this.field_70165_t - 1.0, this.field_70163_u + 1.5, this.field_70161_v);
            this.calculateAllCollisions(this.field_70165_t + 1.0, this.field_70163_u + 0.5, this.field_70161_v);
            this.calculateAllCollisions(this.field_70165_t + 1.0, this.field_70163_u - 0.5, this.field_70161_v);
            this.calculateAllCollisions(this.field_70165_t + 1.0, this.field_70163_u + 1.5, this.field_70161_v);
        } else {
            this.calculateAllCollisions(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v - 1.0);
            this.calculateAllCollisions(this.field_70165_t, this.field_70163_u - 0.5, this.field_70161_v - 1.0);
            this.calculateAllCollisions(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v - 1.0);
            this.calculateAllCollisions(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v + 1.0);
            this.calculateAllCollisions(this.field_70165_t, this.field_70163_u - 0.5, this.field_70161_v + 1.0);
            this.calculateAllCollisions(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v + 1.0);
        }
        EnumFacing heading = EnumFacing.func_176737_a((float)((float)this.field_70159_w), (float)0.0f, (float)((float)this.field_70179_y));
        if (this.isBlockAligned) {
            if (heading.func_176740_k() != EnumFacing.Axis.Z) {
                this.field_70161_v = (double)MathHelper.func_76128_c((double)this.field_70161_v) + 0.5;
            }
            if (heading.func_176740_k() != EnumFacing.Axis.X) {
                this.field_70165_t = (double)MathHelper.func_76128_c((double)this.field_70165_t) + 0.5;
            }
        }
        if (!this.isHoldingStill()) {
            this.field_70181_x = 0.0;
            this.field_70159_w = (float)heading.func_82601_c() * this.speed;
            this.field_70179_y = (float)heading.func_82599_e() * this.speed;
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.pushEntitiesAway();
        }
        this.field_70125_A = 0.0f;
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(-this.field_70159_w), (double)this.field_70179_y) * 57.29577951308232);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_174826_a(this.func_70046_E());
        if (this.isShaking()) {
            this.shake(10);
        }
        if (this.func_130014_f_().field_72995_K) {
            if (this.isHoldingStill() && !this.playSlideSound) {
                this.playSlideSound = true;
            }
            if (!this.isHoldingStill() && this.playSlideSound) {
                this.playSlidingSound(this.func_130014_f_(), this.func_180425_c());
                this.playSlideSound = false;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isDungeonWall) {
            List<LocationSludgeWormDungeon> dungeons = BetweenlandsWorldStorage.forWorld(this.field_70170_p).getLocalStorageHandler().getLocalStorages(LocationSludgeWormDungeon.class, this.func_174813_aQ(), l -> true);
            if (dungeons.isEmpty()) {
                this.func_70106_y();
            } else {
                for (LocationSludgeWormDungeon dungeon : dungeons) {
                    if (!dungeon.isDefeated()) continue;
                    this.func_70106_y();
                    break;
                }
            }
        }
    }

    protected void pushEntitiesAway() {
        boolean collision = false;
        double maxReverseX = -1.0;
        double maxReverseZ = -1.0;
        AxisAlignedBB collisionAABB = this.func_70046_E();
        if (collisionAABB != null) {
            List entities = this.field_70170_p.func_72839_b((Entity)this, collisionAABB);
            for (Entity entity : entities) {
                if (!entity.func_70067_L()) continue;
                if (!entity.func_70104_M() && !(entity instanceof EntityMovingWall)) {
                    collision = true;
                    continue;
                }
                AxisAlignedBB entityAABB = entity.func_174813_aQ();
                boolean squished = false;
                double dx = Math.max(collisionAABB.field_72340_a - entityAABB.field_72336_d, entityAABB.field_72340_a - collisionAABB.field_72336_d);
                double dz = Math.max(collisionAABB.field_72339_c - entityAABB.field_72334_f, entityAABB.field_72339_c - collisionAABB.field_72334_f);
                if (Math.abs(dz) < Math.abs(dx)) {
                    entity.func_70091_d(MoverType.PISTON, 0.0, 0.0, (dz - 0.005) * Math.signum(this.field_70161_v - entity.field_70161_v));
                    entityAABB = entity.func_174813_aQ();
                    dz = Math.max(collisionAABB.field_72339_c - entityAABB.field_72334_f, entityAABB.field_72339_c - collisionAABB.field_72334_f);
                    if (-dz > 0.025) {
                        squished = true;
                        maxReverseZ = Math.max(-dz, maxReverseZ);
                    }
                } else {
                    entity.func_70091_d(MoverType.PISTON, (dx - 0.005) * Math.signum(this.field_70165_t - entity.field_70165_t), 0.0, 0.0);
                    entityAABB = entity.func_174813_aQ();
                    dx = Math.max(collisionAABB.field_72340_a - entityAABB.field_72336_d, entityAABB.field_72340_a - collisionAABB.field_72336_d);
                    if (-dx > 0.025) {
                        squished = true;
                        maxReverseX = Math.max(-dx, maxReverseX);
                    }
                }
                entity.func_70091_d(MoverType.PISTON, 0.0, -0.01, 0.0);
                if (!squished) continue;
                collision = true;
                if (this.field_70170_p.field_72995_K) continue;
                entity.func_70097_a(DamageSource.field_76368_d, 10.0f);
                this.setHoldStill(true);
                this.holdCount = 20;
                this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.WALL_SLAM, SoundCategory.HOSTILE, 0.5f, 0.75f);
            }
        }
        if (collision) {
            if (maxReverseZ > 0.0) {
                this.field_70161_v -= (maxReverseZ + 0.05) * Math.signum(this.field_70179_y);
            }
            if (maxReverseX > 0.0) {
                this.field_70165_t -= (maxReverseX + 0.05) * Math.signum(this.field_70159_w);
            }
            this.shaking = true;
            this.shake_timer = 0;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w *= -1.0;
                this.field_70179_y *= -1.0;
                this.field_70133_I = true;
            }
        }
    }

    private void checkSpawnArea() {
        BlockPos posEntity = this.func_180425_c();
        Iterable blocks = BlockPos.func_177980_a((BlockPos)posEntity.func_177963_a(-1.0, -1.0, -1.0), (BlockPos)posEntity.func_177963_a(1.0, 1.0, 1.0));
        for (BlockPos pos : blocks) {
            if (!this.isUnbreakableBlock(this.func_130014_f_().func_180495_p(pos))) continue;
            this.func_70106_y();
        }
        if (this.isUnbreakableBlock(this.func_130014_f_().func_180495_p(posEntity.func_177982_a(2, 0, 0))) && this.isUnbreakableBlock(this.func_130014_f_().func_180495_p(posEntity.func_177982_a(-2, 0, 0)))) {
            this.field_70179_y = this.speed;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.setIsNewSpawn(false);
        } else if (this.isUnbreakableBlock(this.func_130014_f_().func_180495_p(posEntity.func_177982_a(0, 0, 2))) && this.isUnbreakableBlock(this.func_130014_f_().func_180495_p(posEntity.func_177982_a(0, 0, -2)))) {
            this.field_70159_w = this.speed;
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.setIsNewSpawn(false);
        } else {
            this.func_70106_y();
        }
    }

    private void doJankSafetyCheck() {
        Vec3d vec3d1;
        EnumFacing facing = this.func_174811_aO();
        Vec3d vec3d = new Vec3d((Vec3i)this.func_180425_c());
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1 = new Vec3d((Vec3i)this.func_180425_c().func_177967_a(facing, 28)));
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            BlockPos hitpos = new BlockPos(vec3d1);
            AxisAlignedBB rayBox = new AxisAlignedBB(this.func_180425_c(), hitpos);
            List list = this.field_70170_p.func_72839_b((Entity)this, rayBox);
            for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
                Entity entity = (Entity)list.get(entityCount);
                if (entity == null || !(entity instanceof EntityMovingWall)) continue;
                entity.func_70106_y();
            }
        }
    }

    public void calculateAllCollisions(double posX, double posY, double posZ) {
        Vec3d vec3d = new Vec3d(posX, posY, posZ);
        Vec3d vec3d1 = new Vec3d(posX + this.field_70159_w * 12.0, posY + this.field_70181_x, posZ + this.field_70179_y * 12.0);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = new Vec3d(posX, posY, posZ);
        vec3d1 = new Vec3d(posX + this.field_70159_w, posY + this.field_70181_x, posZ + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_70046_E().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        boolean ignore = false;
        for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
            double d1;
            Entity entity1 = (Entity)list.get(entityCount);
            if (!entity1.func_70067_L()) continue;
            if (entity1 == this.ignoreEntity) {
                ignore = true;
                continue;
            }
            if (this.field_70173_aa < 2 && this.ignoreEntity == null) {
                this.ignoreEntity = entity1;
                ignore = true;
                continue;
            }
            ignore = false;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(vec3d, vec3d1);
            if (raytraceresult1 == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (this.ignoreEntity != null) {
            if (ignore) {
                this.ignoreTime = 2;
            } else if (this.ignoreTime-- <= 0) {
                this.ignoreEntity = null;
            }
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null) {
            this.onImpact(raytraceresult);
        }
    }

    protected void onImpact(RayTraceResult result) {
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = this.func_130014_f_().func_180495_p(result.func_178782_a());
            if (this.isUnbreakableBlock(state)) {
                if (result.field_178784_b.func_176745_a() == 2 || result.field_178784_b.func_176745_a() == 3) {
                    this.shaking = true;
                    this.shake_timer = 0;
                    this.field_70179_y *= -1.0;
                    this.field_70133_I = true;
                    if (!this.func_130014_f_().field_72995_K) {
                        this.setHoldStill(true);
                        this.holdCount = 20;
                        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.WALL_SLAM, SoundCategory.HOSTILE, 0.5f, 0.75f);
                    }
                } else if (result.field_178784_b.func_176745_a() == 4 || result.field_178784_b.func_176745_a() == 5) {
                    this.shaking = true;
                    this.shake_timer = 0;
                    this.field_70159_w *= -1.0;
                    this.field_70133_I = true;
                    if (!this.func_130014_f_().field_72995_K) {
                        this.setHoldStill(true);
                        this.holdCount = 20;
                        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.WALL_SLAM, SoundCategory.HOSTILE, 0.5f, 0.75f);
                    }
                }
            } else if (state.func_177230_c() != Blocks.field_150357_h) {
                this.func_130014_f_().func_175655_b(result.func_178782_a(), false);
                this.func_130014_f_().func_175685_c(result.func_178782_a(), state.func_177230_c(), true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playSlidingSound(World world, BlockPos pos) {
        MovingWallSound wall_slide = new MovingWallSound(this);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)wall_slide);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70024_g(double x, double y, double z) {
        if (this.isHoldingStill()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    public AxisAlignedBB func_174813_aQ() {
        if (this.func_174811_aO() == EnumFacing.NORTH || this.func_174811_aO() == EnumFacing.SOUTH) {
            return new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u - 0.5, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5).func_72314_b(1.0, 1.0, 0.0).func_72317_d(0.0, 0.5, 0.0);
        }
        return new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u - 0.5, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5).func_72314_b(0.0, 1.0, 1.0).func_72317_d(0.0, 0.5, 0.0);
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void setIsNewSpawn(boolean new_spawn) {
        this.field_70180_af.func_187227_b(IS_NEW_SPAWN, (Object)new_spawn);
    }

    public boolean isNewSpawn() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_NEW_SPAWN);
    }

    private void setHoldStill(boolean hold_still) {
        this.field_70180_af.func_187227_b(HOLD_STILL, (Object)hold_still);
    }

    public boolean isHoldingStill() {
        return (Boolean)this.field_70180_af.func_187225_a(HOLD_STILL);
    }

    public boolean isMoving() {
        return !this.isHoldingStill();
    }

    public boolean isUnbreakableBlock(IBlockState state) {
        return UNBREAKABLE_BLOCKS.contains(state.func_177230_c()) || BetweenlandsConfig.GENERAL.movingWallBlacklist.isListed(state);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_150297_b("new_spawn", 1)) {
            this.setIsNewSpawn(nbt.func_74767_n("new_spawn"));
        }
        if (nbt.func_150297_b("isBlockAligned", 1)) {
            this.isBlockAligned = nbt.func_74767_n("isBlockAligned");
        }
        if (nbt.func_150297_b("isDungeonWall", 1)) {
            this.isDungeonWall = nbt.func_74767_n("isDungeonWall");
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74757_a("new_spawn", this.isNewSpawn());
        nbt.func_74757_a("isBlockAligned", this.isBlockAligned);
        nbt.func_74757_a("isDungeonWall", this.isDungeonWall);
    }

    public void shake(int shakeTimerMax) {
        this.shakingTimerMax = shakeTimerMax;
        this.prev_shake_timer = this.shake_timer;
        if (this.shake_timer == 0) {
            this.shaking = true;
            this.shake_timer = 1;
        }
        if (this.shake_timer > 0) {
            ++this.shake_timer;
        }
        this.shaking = this.shake_timer < this.shakingTimerMax;
    }

    @Override
    public float getShakeIntensity(Entity viewer, float partialTicks) {
        if (this.isShaking()) {
            double dist = this.func_70032_d(viewer);
            float shakeMult = (float)(1.0 - dist / 16.0);
            if (dist >= 16.0) {
                return 0.0f;
            }
            return (float)((Math.sin((double)this.getShakingProgress(partialTicks) * Math.PI) + (double)0.1f) * (double)0.075f * (double)shakeMult);
        }
        return 0.0f;
    }

    public float getShakeDistance(Entity entity) {
        float distX = this.func_180425_c().func_177958_n() - entity.func_180425_c().func_177958_n();
        float distY = this.func_180425_c().func_177956_o() - entity.func_180425_c().func_177956_o();
        float distZ = this.func_180425_c().func_177952_p() - entity.func_180425_c().func_177952_p();
        return MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
    }

    public boolean isShaking() {
        return this.shaking;
    }

    public float getShakingProgress(float delta) {
        return 1.0f / (float)this.shakingTimerMax * ((float)this.prev_shake_timer + (float)(this.shake_timer - this.prev_shake_timer) * delta);
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.isBlockAligned);
        buffer.writeBoolean(this.isDungeonWall);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.isBlockAligned = buffer.readBoolean();
        this.isDungeonWall = buffer.readBoolean();
    }

    static {
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_ALCOVE);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.WORM_DUNGEON_PILLAR);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_TILES);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_TILES_WATER);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_STAIRS);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_STAIRS_DECAY_1);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_STAIRS_DECAY_2);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_STAIRS_DECAY_3);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_STAIRS_DECAY_4);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_SLAB);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_SLAB_DECAY_1);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_SLAB_DECAY_2);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_SLAB_DECAY_3);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_SLAB_DECAY_4);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICKS);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICKS_CARVED);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_SPIKE_TRAP);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_TILES_SPIKE_TRAP);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICKS_CLIMBABLE);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.DUNGEON_DOOR_COMBINATION);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.DUNGEON_DOOR_RUNES);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.DUNGEON_DOOR_RUNES_MIMIC);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.DUNGEON_DOOR_RUNES_CRAWLER);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.DUNGEON_DOOR_RUNES_CRAWLER);
        UNBREAKABLE_BLOCKS.add(BlockRegistry.MUD_BRICK_WALL);
    }
}

