/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.config.properties;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.ConfigProperty;

public class BlockListProperty
extends ConfigProperty {
    private final Supplier<String[]> unparsed;
    private Map<String, IntOpenHashSet> blockList;

    public BlockListProperty(Supplier<String[]> unparsed) {
        this.unparsed = unparsed;
    }

    @Override
    protected void init() {
        String[] unparsed;
        this.blockList = new HashMap<String, IntOpenHashSet>();
        for (String listed : unparsed = this.unparsed.get()) {
            try {
                IntOpenHashSet metaSet;
                int meta;
                String block;
                block9: {
                    String[] data = listed.split(":");
                    block = data[0] + ":" + data[1];
                    if (this.blockList.get(block) != null && this.blockList.get(block).contains(Short.MAX_VALUE)) continue;
                    meta = 0;
                    if (data.length > 2) {
                        if (!"*".equals(data[2])) {
                            try {
                                meta = Integer.parseInt(data[2]);
                                break block9;
                            }
                            catch (NumberFormatException ex) {
                                TheBetweenlands.logger.error("Failed to parse block: " + listed + ". Invalid metadata: " + data[2]);
                                continue;
                            }
                        }
                        meta = Short.MAX_VALUE;
                    }
                }
                if ((metaSet = this.blockList.get(block)) == null) {
                    metaSet = new IntOpenHashSet();
                    this.blockList.put(block, metaSet);
                }
                if (meta == Short.MAX_VALUE) {
                    metaSet.clear();
                }
                metaSet.add(meta);
            }
            catch (Exception e) {
                TheBetweenlands.logger.error("Failed to parse block: " + listed);
            }
        }
    }

    public boolean isListed(IBlockState state) {
        ResourceLocation name = state.func_177230_c().getRegistryName();
        IntOpenHashSet metas = this.blockList.get(name.toString());
        if (metas == null) {
            return false;
        }
        if (metas.contains(Short.MAX_VALUE)) {
            return true;
        }
        return metas.contains(state.func_177230_c().func_176201_c(state));
    }
}

