/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import thebetweenlands.api.environment.IEnvironmentEvent;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class CommandBLEvent
extends CommandBase {
    private List<String> childCommands = Arrays.asList("toggle", "on", "off", "list", "enable", "disable");

    public String func_71517_b() {
        return "blevent";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.blevent.usage";
    }

    private void checkArg(String[] args, int length, String usage) throws CommandException {
        if (args.length < length) {
            throw new CommandException("command.blevent.usage." + usage, new Object[0]);
        }
    }

    private void processToggle(ICommandSender sender, String[] args) throws PlayerNotFoundException, CommandException {
        this.checkArg(args, 2, "toggle");
        ResourceLocation eventName = new ResourceLocation(CommandBLEvent.func_147178_a((ICommandSender)sender, (String[])args, (int)1).func_150260_c());
        IEnvironmentEvent event = this.getEnvironentEvent(sender, eventName);
        boolean isActive = event.isActive();
        event.setActive(!isActive);
        if (event.isActive() != !isActive) {
            throw new CommandException("command.blevent.failure." + (isActive ? "off" : "on"), new Object[]{eventName});
        }
        CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("command.blevent.success." + (isActive ? "off" : "on")), (Object[])new Object[]{eventName});
    }

    private void processOn(ICommandSender sender, String[] args) throws PlayerNotFoundException, CommandException {
        this.checkArg(args, 2, "on");
        this.processEventState(sender, new ResourceLocation(CommandBLEvent.func_147178_a((ICommandSender)sender, (String[])args, (int)1).func_150260_c()), true);
    }

    private void processOff(ICommandSender sender, String[] args) throws PlayerNotFoundException, CommandException {
        if (args.length < 2) {
            BLEnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
            for (IEnvironmentEvent event : environmentEventRegistry.getActiveEvents()) {
                event.setActive(false);
            }
            CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.blevent.success.alloff", (Object[])new Object[0]);
        } else {
            this.processEventState(sender, new ResourceLocation(CommandBLEvent.func_147178_a((ICommandSender)sender, (String[])args, (int)1).func_150260_c()), false);
        }
    }

    private void processEnable(ICommandSender sender, String[] args) throws CommandException {
        BLEnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
        if (environmentEventRegistry.isEnabled()) {
            throw new CommandException("command.blevent.failure.alreadyenabled", new Object[0]);
        }
        environmentEventRegistry.enable();
        CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.blevent.success.enable", (Object[])new Object[0]);
    }

    private void processDisable(ICommandSender sender, String[] args) throws CommandException {
        BLEnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
        if (environmentEventRegistry.isDisabled()) {
            throw new CommandException("command.blevent.failure.alreadydisabled", new Object[0]);
        }
        environmentEventRegistry.disable();
        for (IEnvironmentEvent event : environmentEventRegistry.getActiveEvents()) {
            event.setActive(false);
        }
        CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.blevent.success.disable", (Object[])new Object[0]);
    }

    private void processList(ICommandSender sender) throws CommandException {
        BLEnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
        sender.func_145747_a((ITextComponent)new TextComponentString(environmentEventRegistry.getGrammaticalActiveEventNameList()));
    }

    private void processEventState(ICommandSender sender, ResourceLocation eventName, boolean isActive) throws CommandException {
        IEnvironmentEvent event = this.getEnvironentEvent(sender, eventName);
        if (event.isActive() == isActive) {
            throw new CommandException("command.blevent.failure.already" + (isActive ? "on" : "off"), new Object[]{eventName});
        }
        event.setActive(isActive);
        if (event.isActive() != isActive) {
            throw new CommandException("command.blevent.failure." + (isActive ? "on" : "off"), new Object[]{eventName});
        }
        CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("command.blevent.success." + (isActive ? "on" : "off")), (Object[])new Object[]{eventName});
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (BetweenlandsWorldStorage.forWorld(sender.func_130014_f_()) == null) {
            return Collections.emptyList();
        }
        List<String> completions = null;
        if (args.length == 1) {
            completions = this.childCommands;
        } else if (args.length == 2) {
            try {
                List<ResourceLocation> foundEvents = null;
                switch (args[0]) {
                    case "toggle": {
                        foundEvents = this.getEnvironmentEventRegistry(sender).getEventNames();
                        break;
                    }
                    case "on": {
                        foundEvents = this.getEnvironmentEventRegistry(sender).getEventNamesOfState(false);
                        break;
                    }
                    case "off": {
                        foundEvents = this.getEnvironmentEventRegistry(sender).getEventNamesOfState(true);
                    }
                }
                if (foundEvents != null && !foundEvents.isEmpty()) {
                    completions = new ArrayList<String>();
                    for (ResourceLocation event : foundEvents) {
                        completions.add(event.toString());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return completions == null ? Collections.emptyList() : CommandBLEvent.func_71530_a((String[])args, (String[])completions.toArray(new String[0]));
    }

    private BLEnvironmentEventRegistry getEnvironmentEventRegistry(ICommandSender sender) throws CommandException {
        World world = sender.func_130014_f_();
        BetweenlandsWorldStorage storage = BetweenlandsWorldStorage.forWorld(world);
        if (storage != null) {
            return storage.getEnvironmentEventRegistry();
        }
        throw new CommandException("command.blevent.failure.wrongdimension", new Object[0]);
    }

    private IEnvironmentEvent getEnvironentEvent(ICommandSender sender, ResourceLocation eventName) throws CommandException {
        BLEnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
        IEnvironmentEvent event = environmentEventRegistry.forName(eventName);
        if (event == null) {
            throw new CommandException("command.blevent.failure.unknown", new Object[]{eventName});
        }
        return event;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new CommandException("command.blevent.usage", new Object[0]);
        }
        switch (args[0]) {
            case "toggle": {
                this.processToggle(sender, args);
                break;
            }
            case "on": {
                this.processOn(sender, args);
                break;
            }
            case "off": {
                this.processOff(sender, args);
                break;
            }
            case "list": {
                this.processList(sender);
                break;
            }
            case "enable": {
                this.processEnable(sender, args);
                break;
            }
            case "disable": {
                this.processDisable(sender, args);
                break;
            }
            default: {
                throw new CommandException("command.blevent.usage", new Object[0]);
            }
        }
    }
}

