/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.circlegem;

import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.common.capability.circlegem.CircleGemType;

public class CircleGem {
    private final CircleGemType gemType;
    private final CombatType combatType;

    public CircleGem(CircleGemType gemType, CombatType combatType) {
        this.gemType = gemType;
        this.combatType = combatType;
    }

    public CircleGemType getGemType() {
        return this.gemType;
    }

    public CombatType getCombatType() {
        return this.combatType;
    }

    public boolean matchCombatType(CombatType type) {
        return this.combatType == CombatType.BOTH || type == this.combatType;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("gem", this.gemType.name);
        nbt.func_74768_a("type", this.combatType.ordinal());
        return nbt;
    }

    public static CircleGem readFromNBT(NBTTagCompound nbt) {
        CircleGemType gem = CircleGemType.fromName(nbt.func_74779_i("gem"));
        int typeOrdinal = nbt.func_74762_e("type");
        if (CombatType.values().length > typeOrdinal) {
            return new CircleGem(gem, CombatType.values()[typeOrdinal]);
        }
        return null;
    }

    public static enum CombatType {
        OFFENSIVE,
        DEFENSIVE,
        BOTH;

    }
}

