/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.armor.ItemRubberBoots;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockMud
extends Block {
    protected static final AxisAlignedBB MUD_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    public BlockMud() {
        super(BLMaterialRegistry.MUD);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
        this.setHarvestLevel("shovel", 0);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149713_g(255);
    }

    public boolean canEntityWalkOnMud(Entity entity) {
        if (entity instanceof EntityLivingBase && ElixirEffectRegistry.EFFECT_HEAVYWEIGHT.isActive((EntityLivingBase)entity)) {
            return false;
        }
        boolean canWalk = entity instanceof EntityPlayer && ItemRubberBoots.canEntityWalkOnMud(entity);
        boolean hasLurkerArmor = entity instanceof EntityPlayer && entity.func_70090_H() && !((EntityPlayer)entity).field_71071_by.field_70460_b.isEmpty() && ((ItemStack)((EntityPlayer)entity).field_71071_by.field_70460_b.get(0)).func_77973_b() == ItemRegistry.LURKER_SKIN_BOOTS;
        return entity instanceof IEntityBL || entity instanceof EntityItem || canWalk || hasLurkerArmor || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d && ((EntityPlayer)entity).field_71075_bZ.field_75100_b;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MUD_AABB;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        AxisAlignedBB blockAABB = field_185505_j.func_186670_a(pos);
        if (entityBox.func_72326_a(blockAABB) && (entity == null || this.canEntityWalkOnMud(entity))) {
            collidingBoxes.add(blockAABB);
        } else if (world.field_72995_K && entityBox.func_72326_a(blockAABB = MUD_AABB.func_186670_a(pos))) {
            collidingBoxes.add(blockAABB);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!this.canEntityWalkOnMud(entity)) {
            entity.field_70159_w *= 0.08;
            if (!entity.func_70090_H() && entity.field_70181_x < 0.0 && entity.field_70122_E) {
                entity.field_70181_x = -0.1;
            }
            entity.field_70179_y *= 0.08;
            if (!entity.func_70090_H()) {
                entity.func_70110_aj();
            } else {
                entity.field_70181_x *= 0.02;
            }
            entity.field_70122_E = true;
            if (entity instanceof EntityLivingBase && entity.func_70055_a(BLMaterialRegistry.MUD)) {
                entity.func_70097_a(DamageSource.field_76368_d, 2.0f);
            }
        }
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        boolean stateBelow;
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        if (rand.nextInt(10) == 0 && (stateBelow = world.func_175623_d(pos.func_177977_b()))) {
            double d3 = d0 + (double)rand.nextFloat();
            double d5 = d1 - 0.05;
            double d7 = d2 + (double)rand.nextFloat();
            BLParticles.CAVE_WATER_DRIP.spawn(world, d3, d5, d7).func_70538_b(0.4118f, 0.2745f, 0.1568f);
        }
    }
}

