/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.storage.ILocalStorageHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.tile.TileEntityWaystone;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class BlockWaystone
extends BlockContainer {
    public static final PropertyEnum<Part> PART = PropertyEnum.func_177709_a((String)"part", Part.class);
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockWaystone() {
        super(Material.field_151576_e);
        this.func_149711_c(25.0f);
        this.func_149752_b(10000.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PART, (Comparable)((Object)Part.BOTTOM)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PART, ACTIVE});
    }

    public int func_176201_c(IBlockState state) {
        return ((Part)((Object)state.func_177229_b(PART))).getMeta() | ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 4 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PART, (Comparable)((Object)Part.fromMeta(meta & 3))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && super.func_176196_c(world, pos.func_177984_a()) && super.func_176196_c(world, pos.func_177981_b(2));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            IBlockState stateTop = this.func_176223_P().func_177226_a(PART, (Comparable)((Object)Part.TOP));
            IBlockState stateMiddle = this.func_176223_P().func_177226_a(PART, (Comparable)((Object)Part.MIDDLE));
            worldIn.func_180501_a(pos.func_177981_b(2), stateTop, 3);
            worldIn.func_180501_a(pos.func_177984_a(), stateMiddle, 3);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        ILocalStorageHandler localStorageHandler = BetweenlandsWorldStorage.forWorld(worldIn).getLocalStorageHandler();
        List<LocationStorage> waystoneLocations = localStorageHandler.getLocalStorages(LocationStorage.class, new AxisAlignedBB(pos), storage -> storage.getType() == EnumLocationType.WAYSTONE);
        for (LocationStorage waystoneLocation : waystoneLocations) {
            localStorageHandler.removeLocalStorage(waystoneLocation);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.isValidWaystone(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean isValidWaystone(World world, BlockPos pos, IBlockState state) {
        switch ((Part)((Object)state.func_177229_b(PART))) {
            case TOP: {
                IBlockState down1 = world.func_180495_p(pos.func_177977_b());
                IBlockState down2 = world.func_180495_p(pos.func_177979_c(2));
                return down1.func_177230_c() == this && down1.func_177229_b(PART) == Part.MIDDLE && down2.func_177230_c() == this && down2.func_177229_b(PART) == Part.BOTTOM;
            }
            case MIDDLE: {
                IBlockState down1 = world.func_180495_p(pos.func_177977_b());
                IBlockState up1 = world.func_180495_p(pos.func_177984_a());
                return down1.func_177230_c() == this && down1.func_177229_b(PART) == Part.BOTTOM && up1.func_177230_c() == this && up1.func_177229_b(PART) == Part.TOP;
            }
        }
        IBlockState up1 = world.func_180495_p(pos.func_177984_a());
        IBlockState up2 = world.func_180495_p(pos.func_177981_b(2));
        return up1.func_177230_c() == this && up1.func_177229_b(PART) == Part.MIDDLE && up2.func_177230_c() == this && up2.func_177229_b(PART) == Part.TOP;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(PART) == Part.BOTTOM) {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (!worldIn.field_72995_K) {
            return new TileEntityWaystone(worldIn.field_73012_v.nextFloat() * 360.0f);
        }
        return new TileEntityWaystone();
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 16; ++i) {
            worldIn.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, (double)pos.func_177958_n() + 0.5 + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 16.0, (double)pos.func_177956_o() + 0.5 + (double)(rand.nextFloat() * 6.0f) - 3.0, (double)pos.func_177952_p() + 0.5 + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 16.0, 0.0, 0.2, 0.0, new int[0]);
        }
    }

    public static enum Part implements IStringSerializable
    {
        TOP("top", 0),
        MIDDLE("middle", 1),
        BOTTOM("bottom", 2);

        private final String name;
        private final int meta;

        private Part(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        public int getMeta() {
            return this.meta;
        }

        public static Part fromMeta(int meta) {
            for (Part part : Part.values()) {
                if (part.meta != meta) continue;
                return part;
            }
            return null;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

