/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.registries.BlockRegistry;

public class BlockDruidStone
extends BasicBlock
implements BlockRegistry.ISubtypeItemBlockModelDefinition {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockDruidStone(Material blockMaterialIn) {
        super(blockMaterialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149715_a(0.8f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 4 : 0);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double pixel = 0.625;
        if (!((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ACTIVE)).booleanValue() && rand.nextInt(80) == 0) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos side = pos.func_177972_a(facing);
                if (world.func_180495_p(side).func_185914_p()) continue;
                double dx = (double)rand.nextFloat() - 0.5;
                double dy = (double)rand.nextFloat() - 0.5;
                double dz = (double)rand.nextFloat() - 0.5;
                int vx = facing.func_82601_c();
                int vy = facing.func_96559_d();
                int vz = facing.func_82599_e();
                double particleX = (double)pos.func_177958_n() + 0.5 + (dx *= (double)(1 - Math.abs(vx))) + (double)vx * pixel;
                double particleY = (double)pos.func_177956_o() + 0.5 + (dy *= (double)(1 - Math.abs(vy))) + (double)vy * pixel;
                double particleZ = (double)pos.func_177952_p() + 0.5 + (dz *= (double)(1 - Math.abs(vz))) + (double)vz * pixel;
                BLParticles.DRUID_CASTING_BIG.spawn(world, particleX, particleY, particleZ, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((double)(rand.nextFloat() - rand.nextFloat()) * 0.1, 0.0, (double)(rand.nextFloat() - rand.nextFloat()) * 0.1)).withScale(rand.nextFloat() * 0.5f + 0.5f)).withColor(0.8f + rand.nextFloat() * 0.2f, 0.8f + rand.nextFloat() * 0.2f, 0.8f, 1.0f));
            }
        }
    }

    @Override
    public int getSubtypeNumber() {
        return 2;
    }

    @Override
    public String getSubtypeName(int meta) {
        switch (meta) {
            default: {
                return "%s";
            }
            case 1: 
        }
        return "%s_active";
    }
}

