/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.tile.ModelDungeonDoorRunes;
import thebetweenlands.client.render.model.tile.ModelDungeonDoorRunesLayer;
import thebetweenlands.common.block.structure.BlockDungeonDoorRunes;
import thebetweenlands.common.tile.TileEntityDungeonDoorRunes;

@SideOnly(value=Side.CLIENT)
public class RenderDungeonDoorRunes
extends TileEntitySpecialRenderer<TileEntityDungeonDoorRunes> {
    private static final ModelDungeonDoorRunes RUNE_BLOCK = new ModelDungeonDoorRunes();
    private static final ModelDungeonDoorRunesLayer RUNE_BLOCK_LAYER = new ModelDungeonDoorRunesLayer();
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "textures/tiles/dungeon_door_runes.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_3.png");
    private static final ResourceLocation TEXTURE_4 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_4.png");
    private static final ResourceLocation TEXTURE_5 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_5.png");
    private static final ResourceLocation TEXTURE_6 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_6.png");
    private static final ResourceLocation TEXTURE_7 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_7.png");
    private static final ResourceLocation TEXTURE_8 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_8.png");
    private static final ResourceLocation TEXTURE_RUNE_GLOW = new ResourceLocation("thebetweenlands", "textures/tiles/dungeon_runes_glow.png");

    public void renderTile(TileEntityDungeonDoorRunes tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state == null || !(state.func_177230_c() instanceof BlockDungeonDoorRunes)) {
            return;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDungeonDoorRunes.FACING);
        boolean invisiBlock = (Boolean)state.func_177229_b((IProperty)BlockDungeonDoorRunes.INVISIBLE);
        if (invisiBlock) {
            return;
        }
        this.func_147499_a(TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        switch (facing) {
            case UP: 
            case DOWN: 
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        RUNE_BLOCK.render(tile, 0.0625f, partialTick);
        if (!tile.isMimic()) {
            GlStateManager.func_179109_b((float)0.0f, (float)(0.0f + 0.1375f * ((float)tile.last_tick_slate_1_rotate + (float)(tile.slate_1_rotate - tile.last_tick_slate_1_rotate) * partialTick) * 0.0625f), (float)(0.0f + 0.275f * ((float)tile.last_tick_recess_pos + (float)(tile.recess_pos - tile.last_tick_recess_pos) * partialTick) * 0.0625f));
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (!tile.is_gate_entrance) {
            this.func_147499_a(this.getTextureFromRotationIndex(tile.top_state_prev));
            RUNE_BLOCK_LAYER.renderTopOverlay(tile, TEXTURE_RUNE_GLOW, tile.renderTicks, 0.0625f, partialTick);
            this.func_147499_a(this.getTextureFromRotationIndex(tile.mid_state_prev));
            RUNE_BLOCK_LAYER.renderMidOverlay(tile, TEXTURE_RUNE_GLOW, tile.renderTicks, 0.0625f, partialTick);
            this.func_147499_a(this.getTextureFromRotationIndex(tile.bottom_state_prev));
            RUNE_BLOCK_LAYER.renderBottomOverlay(tile, TEXTURE_RUNE_GLOW, tile.renderTicks, 0.0625f, partialTick);
        }
        if (tile.is_gate_entrance && tile.slate_1_rotate <= 270) {
            this.func_147499_a(TextureMap.field_110575_b);
            ITextureObject texture = Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b);
            texture.func_174936_b(false, false);
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.func_179145_e();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)1.03125f, (float)1.03125f, (float)1.03125f);
            IBakedModel itemModel = renderItem.func_184393_a(tile.cachedStack(), (World)null, (EntityLivingBase)null);
            itemModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)itemModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
            renderItem.func_180454_a(tile.cachedStack(), itemModel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            texture.func_174935_a();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void render(TileEntityDungeonDoorRunes tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile == null || !tile.func_145830_o()) {
            this.renderTileAsItem(x, y, z);
            return;
        }
        this.renderTile(tile, x, y, z, partialTicks, destroyStage, alpha);
    }

    private void renderTileAsItem(double x, double y, double z) {
        GlStateManager.func_179094_E();
        this.func_147499_a(TEXTURE);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        RUNE_BLOCK.renderItem(0.0625f);
        GlStateManager.func_179121_F();
    }

    public ResourceLocation getTextureFromRotationIndex(int index) {
        switch (index) {
            case 0: {
                return TEXTURE_1;
            }
            case 1: {
                return TEXTURE_2;
            }
            case 2: {
                return TEXTURE_3;
            }
            case 3: {
                return TEXTURE_4;
            }
            case 4: {
                return TEXTURE_5;
            }
            case 5: {
                return TEXTURE_6;
            }
            case 6: {
                return TEXTURE_7;
            }
            case 7: {
                return TEXTURE_8;
            }
        }
        return TEXTURE_1;
    }
}

