/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.tile.ModelDungeonDoorRunesLayer;
import thebetweenlands.common.block.structure.BlockDungeonDoorCombination;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityDungeonDoorCombination;

@SideOnly(value=Side.CLIENT)
public class RenderDungeonDoorCombination
extends TileEntitySpecialRenderer<TileEntityDungeonDoorCombination> {
    private static final ModelDungeonDoorRunesLayer RUNE_BLOCK_LAYER = new ModelDungeonDoorRunesLayer();
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_3.png");
    private static final ResourceLocation TEXTURE_4 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_4.png");
    private static final ResourceLocation TEXTURE_5 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_5.png");
    private static final ResourceLocation TEXTURE_6 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_6.png");
    private static final ResourceLocation TEXTURE_7 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_7.png");
    private static final ResourceLocation TEXTURE_8 = new ResourceLocation("thebetweenlands", "textures/tiles/rune_overlay_8.png");
    private static final ResourceLocation TEXTURE_RUNE_GLOW = new ResourceLocation("thebetweenlands", "textures/tiles/dungeon_runes_glow.png");

    public void render(TileEntityDungeonDoorCombination tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state == null || state.func_177230_c() != BlockRegistry.DUNGEON_DOOR_COMBINATION) {
            return;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDungeonDoorCombination.FACING);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        switch (facing) {
            case UP: 
            case DOWN: 
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.func_147499_a(this.getTextureFromRotationIndex(tile.top_code));
        RUNE_BLOCK_LAYER.renderTopOverlay(tile, TEXTURE_RUNE_GLOW, tile.renderTicks, 0.062505f, partialTick);
        this.func_147499_a(this.getTextureFromRotationIndex(tile.mid_code));
        RUNE_BLOCK_LAYER.renderMidOverlay(tile, TEXTURE_RUNE_GLOW, tile.renderTicks, 0.062505f, partialTick);
        this.func_147499_a(this.getTextureFromRotationIndex(tile.bottom_code));
        RUNE_BLOCK_LAYER.renderBottomOverlay(tile, TEXTURE_RUNE_GLOW, tile.renderTicks, 0.062505f, partialTick);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public ResourceLocation getTextureFromRotationIndex(int index) {
        switch (index) {
            case 0: {
                return TEXTURE_1;
            }
            case 1: {
                return TEXTURE_2;
            }
            case 2: {
                return TEXTURE_3;
            }
            case 3: {
                return TEXTURE_4;
            }
            case 4: {
                return TEXTURE_5;
            }
            case 5: {
                return TEXTURE_6;
            }
            case 6: {
                return TEXTURE_7;
            }
            case 7: {
                return TEXTURE_8;
            }
        }
        return TEXTURE_1;
    }
}

