/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.sprite;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureCorrosion
extends TextureAtlasSprite {
    public static final ResourceLocation CORROSION_TEXTURE = new ResourceLocation("thebetweenlands", "textures/items/tool_corrosion.png");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random(0L);
    private static int[] corrosionPixels;
    private static int corrosionWidth;
    private AnimationMetadataSection parentAnimationMetadata;
    private final long seed;
    private final ResourceLocation parentTexture;
    private final ResourceLocation parentTextureSpriteName;
    private final int corrosionAmount;
    private int currentMipmapLevels = 0;
    private ResourceLocation loadedResourceLocation = null;
    private IResourceManager loaderResourceManager = null;
    private TextureAtlasSprite parentSprite;
    private Function<ResourceLocation, TextureAtlasSprite> textureGetter;

    public TextureCorrosion(String spriteName, ResourceLocation parentTexture, int corrosionAmount, long seed) {
        super(spriteName);
        this.parentTexture = parentTexture;
        String spritePath = this.parentTexture.func_110623_a();
        spritePath = spritePath.substring("textures/".length(), spritePath.length() - ".png".length());
        this.parentTextureSpriteName = new ResourceLocation(this.parentTexture.func_110624_b(), spritePath);
        this.corrosionAmount = corrosionAmount;
        this.seed = seed;
    }

    public ResourceLocation getParentTexture() {
        return this.parentTexture;
    }

    public ResourceLocation getParentSpriteName() {
        return this.parentTextureSpriteName;
    }

    public void setParentSprite(TextureAtlasSprite sprite) {
        this.parentSprite = sprite;
    }

    public TextureAtlasSprite getParentSprite() {
        return this.parentSprite;
    }

    private void resetSprite() {
        this.parentAnimationMetadata = null;
        this.func_110968_a(new ArrayList());
        this.field_110973_g = 0;
        this.field_110983_h = 0;
    }

    private void loadCorrosionPixels(IResourceManager manager) {
        try {
            BufferedImage corrosionImg = ImageIO.read(manager.func_110536_a(CORROSION_TEXTURE).func_110527_b());
            corrosionPixels = new int[corrosionImg.getWidth() * corrosionImg.getHeight()];
            corrosionImg.getRGB(0, 0, corrosionImg.getWidth(), corrosionImg.getHeight(), corrosionPixels, 0, corrosionImg.getWidth());
            corrosionWidth = corrosionImg.getWidth();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public void func_188538_a(PngSizeInfo sizeInfo, boolean hasAnimationMeta) throws IOException {
        throw new RuntimeException("Not supported!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        if (corrosionPixels == null) {
            this.loadCorrosionPixels(manager);
        }
        IResource resource = null;
        try {
            this.loadedResourceLocation = location;
            this.loaderResourceManager = manager;
            this.textureGetter = textureGetter;
            resource = manager.func_110536_a(this.parentTexture);
            this.func_188539_a(resource, this.currentMipmapLevels + 1);
        }
        catch (RuntimeException runtimeexception) {
            LOGGER.error("Unable to parse metadata from " + this.loadedResourceLocation, (Throwable)runtimeexception);
            IOUtils.closeQuietly((Closeable)resource);
        }
        catch (IOException ioexception) {
            LOGGER.error("Using missing texture, unable to load " + this.loadedResourceLocation, (Throwable)ioexception);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resource);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
        IOUtils.closeQuietly((Closeable)resource);
        return false;
    }

    public void func_147963_d(int mipmapLevels) {
        boolean generatedMipmaps = true;
        if (mipmapLevels > this.currentMipmapLevels && this.loaderResourceManager != null && this.loadedResourceLocation != null) {
            this.currentMipmapLevels = mipmapLevels;
            try {
                this.load(this.loaderResourceManager, this.loadedResourceLocation, this.textureGetter);
            }
            catch (Exception ex) {
                generatedMipmaps = false;
                this.currentMipmapLevels = 0;
            }
        }
        super.func_147963_d(generatedMipmaps ? mipmapLevels : 0);
    }

    public void func_188539_a(IResource resource, int mipmapLevels) throws IOException {
        BufferedImage spriteTexture = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
        AnimationMetadataSection spriteMetadata = (AnimationMetadataSection)resource.func_110526_a("animation");
        int[][] mipmappedFrames = new int[mipmapLevels][];
        mipmappedFrames[0] = new int[spriteTexture.getWidth() * spriteTexture.getHeight()];
        spriteTexture.getRGB(0, 0, spriteTexture.getWidth(), spriteTexture.getHeight(), mipmappedFrames[0], 0, spriteTexture.getWidth());
        this.resetSprite();
        int width = spriteTexture.getWidth();
        int height = spriteTexture.getHeight();
        this.field_130223_c = width;
        this.field_130224_d = height;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (y % width == 0) {
                    RANDOM.setSeed(this.seed);
                }
                int pixel = mipmappedFrames[0][x + y * width];
                int corrosion = 0;
                if (pixel >>> 24 != 0 && RANDOM.nextFloat() > 0.2f) {
                    corrosion = corrosionPixels[x % width % corrosionWidth + y % width % corrosionWidth * corrosionWidth];
                }
                float alpha = (float)this.corrosionAmount / 5.0f * ((float)(corrosion >>> 24 & 0xFF) / 255.0f) * (0.5f + RANDOM.nextFloat() * 0.5f);
                mipmappedFrames[0][x + y * width] = ((int)(alpha * 255.0f) & 0xFF) << 24 | (corrosion >> 16 & 0xFF) << 16 | (corrosion >> 8 & 0xFF) << 8 | corrosion & 0xFF;
            }
        }
        if (spriteMetadata == null) {
            if (height != width) {
                throw new RuntimeException("broken aspect ratio and not an animation");
            }
            this.field_110976_a.add(mipmappedFrames);
        } else {
            int frameCount = height / width;
            int frameWidth = width;
            int frameHeight = width;
            this.field_130224_d = width;
            if (spriteMetadata.func_110473_c() > 0) {
                Iterator frameIndexIterator = spriteMetadata.func_130073_e().iterator();
                int frameIndex = 0;
                while (frameIndexIterator.hasNext()) {
                    frameIndex = (Integer)frameIndexIterator.next();
                    if (frameIndex >= frameCount) {
                        throw new RuntimeException("invalid frameindex " + frameIndex);
                    }
                    this.allocateFrameTextureData(frameIndex);
                    this.field_110976_a.set(frameIndex, TextureCorrosion.getFrameTextureData(mipmappedFrames, frameWidth, frameHeight, frameIndex));
                }
                this.parentAnimationMetadata = spriteMetadata;
            } else {
                ArrayList animationFrames = Lists.newArrayList();
                for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
                    this.field_110976_a.add(TextureCorrosion.getFrameTextureData(mipmappedFrames, frameWidth, frameHeight, frameIndex));
                    animationFrames.add(new AnimationFrame(frameIndex, -1));
                }
                this.parentAnimationMetadata = new AnimationMetadataSection((List)animationFrames, width, height, spriteMetadata.func_110469_d(), spriteMetadata.func_177219_e());
            }
        }
    }

    private void allocateFrameTextureData(int frameCount) {
        if (this.field_110976_a.size() <= frameCount) {
            for (int i = this.field_110976_a.size(); i <= frameCount; ++i) {
                this.field_110976_a.add(null);
            }
        }
    }

    private static int[][] getFrameTextureData(int[][] framesData, int width, int height, int offset) {
        int[][] newFrameData = new int[framesData.length][];
        for (int frame = 0; frame < framesData.length; ++frame) {
            int[] frameData = framesData[frame];
            if (frameData == null) continue;
            newFrameData[frame] = new int[(width >> frame) * (height >> frame)];
            System.arraycopy(frameData, offset * newFrameData[frame].length, newFrameData[frame], 0, newFrameData[frame].length);
        }
        return newFrameData;
    }

    public void func_94219_l() {
        if (this.parentSprite == null) {
            ++this.field_110983_h;
            if (this.field_110983_h >= this.parentAnimationMetadata.func_110472_a(this.field_110973_g)) {
                int frameIndex = this.parentAnimationMetadata.func_110468_c(this.field_110973_g);
                int frameCount = this.parentAnimationMetadata.func_110473_c() == 0 ? this.field_110976_a.size() : this.parentAnimationMetadata.func_110473_c();
                this.field_110973_g = (this.field_110973_g + 1) % frameCount;
                this.field_110983_h = 0;
                int nextFrameIndex = this.parentAnimationMetadata.func_110468_c(this.field_110973_g);
                if (frameIndex != nextFrameIndex && nextFrameIndex >= 0 && nextFrameIndex < this.field_110976_a.size()) {
                    TextureUtil.func_147955_a((int[][])((int[][])this.field_110976_a.get(nextFrameIndex)), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
                }
            } else if (this.parentAnimationMetadata.func_177219_e()) {
                this.updateAnimationInterpolated();
            }
        } else {
            int prevFrameIndex = this.parentAnimationMetadata.func_110468_c(this.field_110973_g);
            try {
                this.field_110983_h = this.parentSprite.field_110983_h;
                this.field_110973_g = this.parentSprite.field_110973_g;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            int nextFrameIndex = this.parentAnimationMetadata.func_110468_c(this.field_110973_g);
            if (prevFrameIndex != nextFrameIndex) {
                TextureUtil.func_147955_a((int[][])((int[][])this.field_110976_a.get(nextFrameIndex)), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            } else if (this.parentAnimationMetadata.func_177219_e()) {
                this.updateAnimationInterpolated();
            }
        }
    }

    private void updateAnimationInterpolated() {
        int frameCount;
        int nextFrameIndex;
        double interpolatedFrameIndex = 1.0 - (double)this.field_110983_h / (double)this.parentAnimationMetadata.func_110472_a(this.field_110973_g);
        int frameIndex = this.parentAnimationMetadata.func_110468_c(this.field_110973_g);
        if (frameIndex != (nextFrameIndex = this.parentAnimationMetadata.func_110468_c((this.field_110973_g + 1) % (frameCount = this.parentAnimationMetadata.func_110473_c() == 0 ? this.field_110976_a.size() : this.parentAnimationMetadata.func_110473_c()))) && nextFrameIndex >= 0 && nextFrameIndex < this.field_110976_a.size()) {
            int[][] frame = (int[][])this.field_110976_a.get(frameIndex);
            int[][] nextFrame = (int[][])this.field_110976_a.get(nextFrameIndex);
            if (this.field_176605_b == null || this.field_176605_b.length != frame.length) {
                this.field_176605_b = new int[frame.length][];
            }
            for (int mipmapLevel = 0; mipmapLevel < frame.length; ++mipmapLevel) {
                if (this.field_176605_b[mipmapLevel] == null) {
                    this.field_176605_b[mipmapLevel] = new int[frame[mipmapLevel].length];
                }
                if (mipmapLevel >= nextFrame.length || nextFrame[mipmapLevel].length != frame[mipmapLevel].length) continue;
                for (int framePixelIndex = 0; framePixelIndex < frame[mipmapLevel].length; ++framePixelIndex) {
                    int pixel = frame[mipmapLevel][framePixelIndex];
                    int nextPixel = nextFrame[mipmapLevel][framePixelIndex];
                    int interpR = this.interpolateColor(interpolatedFrameIndex, pixel >> 16 & 0xFF, nextPixel >> 16 & 0xFF);
                    int interpG = this.interpolateColor(interpolatedFrameIndex, pixel >> 8 & 0xFF, nextPixel >> 8 & 0xFF);
                    int interpB = this.interpolateColor(interpolatedFrameIndex, pixel & 0xFF, nextPixel & 0xFF);
                    this.field_176605_b[mipmapLevel][framePixelIndex] = pixel & 0xFF000000 | interpR << 16 | interpG << 8 | interpB;
                }
            }
            TextureUtil.func_147955_a((int[][])this.field_176605_b, (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
        }
    }

    private int interpolateColor(double lerp, int val1, int val2) {
        return (int)(lerp * (double)val1 + (1.0 - lerp) * (double)val2);
    }

    public boolean func_130098_m() {
        return this.parentAnimationMetadata != null;
    }
}

