/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.render.shader.DepthBuffer;
import thebetweenlands.client.render.shader.FloatFramebuffer;

public class GeometryBuffer
extends AbstractTexture {
    private Framebuffer geometryBuffer;
    private DepthBuffer geometryDepthBuffer;
    private boolean depthBuffer = false;
    protected final TextureManager textureManager;
    protected final ResourceLocation nameDiffuse;
    protected final ResourceLocation nameDepth;

    public GeometryBuffer(TextureManager textureManager, @Nullable ResourceLocation nameDiffuse, @Nullable ResourceLocation nameDepth, boolean depthBuffer) {
        this.textureManager = textureManager;
        this.depthBuffer = depthBuffer;
        this.nameDiffuse = nameDiffuse;
        this.nameDepth = nameDepth;
        if (this.textureManager != null && this.nameDiffuse != null) {
            this.textureManager.func_110579_a(this.nameDiffuse, (ITextureObject)this);
        }
    }

    public boolean updateGeometryBuffer(int width, int height) {
        boolean changed = false;
        if (this.geometryBuffer == null) {
            this.geometryBuffer = new FloatFramebuffer(width, height, this.depthBuffer);
            changed = true;
        }
        if (width != this.geometryBuffer.field_147621_c || height != this.geometryBuffer.field_147618_d) {
            this.geometryBuffer.func_147608_a();
            this.geometryBuffer = new FloatFramebuffer(width, height, this.depthBuffer);
            changed = true;
        }
        return changed;
    }

    public boolean updateDepthBuffer() {
        boolean changed = false;
        if (this.depthBuffer && this.geometryBuffer != null) {
            if (this.geometryDepthBuffer == null) {
                this.geometryDepthBuffer = new DepthBuffer(this.textureManager, this.nameDepth);
                changed = true;
            }
            if (this.geometryDepthBuffer.blitDepthBuffer(this.geometryBuffer)) {
                changed = true;
            }
        }
        return changed;
    }

    public int getDiffuseTexture() {
        if (this.geometryBuffer != null) {
            return this.geometryBuffer.field_147617_g;
        }
        return -1;
    }

    public int getDepthTexture() {
        if (this.depthBuffer && this.geometryDepthBuffer != null) {
            return this.geometryDepthBuffer.func_110552_b();
        }
        return -1;
    }

    public void bind() {
        if (this.geometryBuffer == null) {
            throw new NullPointerException("The buffers aren't initialized yet");
        }
        this.geometryBuffer.func_147610_a(false);
    }

    public boolean isInitialized() {
        return this.geometryBuffer != null;
    }

    public void clear(float r, float g, float b, float a, double depth) {
        if (this.geometryBuffer != null) {
            this.geometryBuffer.func_147610_a(false);
            GlStateManager.func_179082_a((float)r, (float)g, (float)b, (float)a);
            GlStateManager.func_179151_a((double)depth);
            GlStateManager.func_179086_m((int)16640);
        }
    }

    public void clear(float r, float g, float b, float a) {
        this.clear(r, g, b, a, 1.0);
    }

    public void deleteBuffers() {
        if (this.geometryBuffer != null) {
            this.geometryBuffer.func_147608_a();
        }
        if (this.geometryDepthBuffer != null) {
            this.geometryDepthBuffer.deleteBuffer();
        }
    }

    public boolean hasDepthBuffer() {
        return this.depthBuffer;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
    }

    public int func_110552_b() {
        if (this.geometryBuffer != null) {
            return this.geometryBuffer.field_147617_g;
        }
        return -1;
    }

    public void func_147631_c() {
        this.deleteBuffers();
    }
}

