/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.loader.extension;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import thebetweenlands.client.render.model.baked.BakedModelItemWrapper;
import thebetweenlands.client.render.model.loader.CustomModelLoader;
import thebetweenlands.client.render.model.loader.extension.LoaderExtension;

public class AdvancedItemLoaderExtension
extends LoaderExtension {
    private final Map<ModelResourceLocation, ModelContext> modelContexts = new HashMap<ModelResourceLocation, ModelContext>();

    @Override
    public String getName() {
        return "from_item_advanced";
    }

    @Override
    public IModel loadModel(IModel original, ResourceLocation location, String arg) {
        ModelContext context = this.parseContextData(location, this.readMetadata(arg));
        this.modelContexts.put(context.source, context);
        this.findReplacementModelAndRegister(location, context);
        return this.getItemDummyModel();
    }

    protected ModelContext parseContextData(ResourceLocation location, String metadata) {
        JsonParser parser = new JsonParser();
        ImmutableMap<String, String> dataMap = AdvancedItemLoaderExtension.parseJsonElementList(parser, metadata, location.toString() + " model metadata");
        if (!dataMap.containsKey((Object)"source")) {
            this.throwLoaderException("Source model was not specified");
        }
        String sourceItem = JsonUtils.func_151206_a((JsonElement)parser.parse((String)dataMap.get((Object)"source")), (String)"source");
        String customData = null;
        if (dataMap.containsKey((Object)"custom")) {
            customData = (String)dataMap.get((Object)"custom");
        }
        boolean inheritOverrides = true;
        if (dataMap.containsKey((Object)"inherit_overrides")) {
            try {
                inheritOverrides = JsonUtils.func_151216_b((JsonElement)parser.parse((String)dataMap.get((Object)"inherit_overrides")), (String)"inherit_overrides");
            }
            catch (Exception ex) {
                this.throwLoaderException("Malformed inherit_overrides value. Must be a boolean", ex);
            }
        }
        boolean shouldCacheOverrides = true;
        if (dataMap.containsKey((Object)"cache_overrides")) {
            try {
                shouldCacheOverrides = JsonUtils.func_151216_b((JsonElement)parser.parse((String)dataMap.get((Object)"cache_overrides")), (String)"cache_overrides");
            }
            catch (Exception ex) {
                this.throwLoaderException("Malformed cache_overrides value. Must be a boolean", ex);
            }
        }
        ResourceLocation childModel = new ResourceLocation(sourceItem);
        ModelResourceLocation sourceLocation = new ModelResourceLocation(new ResourceLocation(childModel.func_110624_b(), childModel.func_110623_a()), "inventory");
        return new ModelContext(sourceLocation, location, customData, inheritOverrides, shouldCacheOverrides);
    }

    @Override
    public IBakedModel getModelReplacement(ModelResourceLocation location, IBakedModel original) {
        ModelContext context = this.modelContexts.get(location);
        if (context != null) {
            IModel replacementModel = this.findReplacementModelAndRegister((ResourceLocation)location, context);
            IBakedModel bakedModel = replacementModel.bake(replacementModel.getDefaultState(), DefaultVertexFormats.field_176599_b, loc -> Minecraft.func_71410_x().func_147117_R().func_110572_b(loc.toString()));
            return new BakedModelItemWrapper(original, bakedModel).setInheritOverrides(context.inheritOverrides).setCacheOverrideModels(context.cacheOverrides);
        }
        return null;
    }

    private IModel findReplacementModelAndRegister(ResourceLocation location, ModelContext context) {
        ResourceLocation replacementModelLocation = context.replacement;
        if (context.hasCustomData()) {
            replacementModelLocation = CustomModelLoader.MODEL_PROCESSOR_LOADER_EXTENSION.getLocationWithExtension(replacementModelLocation, "{\"custom\": " + context.customData + "}");
        }
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)replacementModelLocation);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load model " + replacementModelLocation + " for child model " + location, ex);
        }
    }

    protected final class ModelContext {
        public final ModelResourceLocation source;
        public final ResourceLocation replacement;
        public final String customData;
        public final boolean inheritOverrides;
        public final boolean cacheOverrides;

        protected ModelContext(ModelResourceLocation source, ResourceLocation replacement, String customData, boolean inheritsOverrides, boolean cacheOverrides) {
            this.source = source;
            this.replacement = replacement;
            this.customData = customData;
            this.inheritOverrides = inheritsOverrides;
            this.cacheOverrides = cacheOverrides;
        }

        protected boolean hasCustomData() {
            return this.customData != null && this.customData.length() > 0;
        }

        protected ImmutableMap<String, String> parseCustomData(JsonParser parser) {
            return LoaderExtension.parseJsonElementList(parser, this.customData, this.source.toString() + " model metadata");
        }
    }
}

