/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.render.model.IModelRenderCallback;
import thebetweenlands.client.render.model.Model3DTexture;
import thebetweenlands.client.render.model.MowzieModelRenderer;
import thebetweenlands.util.RotationOrder;

public class AdvancedModelRenderer
extends MowzieModelRenderer {
    public boolean field_78812_q;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public float aftMoveX;
    public float aftMoveY;
    public float aftMoveZ;
    public RotationOrder rotationOrder;
    public float secondaryRotateAngleX;
    public float secondaryRotateAngleY;
    public float secondaryRotateAngleZ;
    public boolean isGlowing = false;
    public boolean shouldntGlow;
    public boolean isMeteorLightGlow;
    public List<ModelRenderer> field_78805_m;
    protected int field_78803_o;
    protected int field_78813_p;
    protected int field_78811_r;
    protected ModelBase modelBase;
    protected RotationOrder secondaryRotationOrder;
    protected List<IModelRenderCallback> callbacks = new ArrayList<IModelRenderCallback>();

    public AdvancedModelRenderer(ModelBase modelBase) {
        this(modelBase, null);
    }

    public AdvancedModelRenderer(ModelBase modelBase, int textureOffsetX, int textureOffsetY) {
        this(modelBase);
        this.setTextureOffset(textureOffsetX, textureOffsetY);
    }

    public AdvancedModelRenderer(ModelBase modelBase, String name) {
        super(modelBase, name);
        this.modelBase = modelBase;
        this.setTextureSize(modelBase.field_78090_t, modelBase.field_78089_u);
        this.scaleZ = 1.0f;
        this.scaleY = 1.0f;
        this.scaleX = 1.0f;
        this.rotationOrder = RotationOrder.ZYX;
        this.secondaryRotationOrder = RotationOrder.ZYX;
    }

    public void func_78792_a(ModelRenderer modelRenderer) {
        if (this.field_78805_m == null) {
            this.field_78805_m = Lists.newArrayList();
        }
        this.field_78805_m.add(modelRenderer);
    }

    private void callback(float scale) {
        for (IModelRenderCallback callback : this.callbacks) {
            callback.render(this, scale);
        }
    }

    public AdvancedModelRenderer addBox(float posX, float posY, float posZ, int width, int height, int depth) {
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, posX, posY, posZ, width, height, depth, 0.0f));
        return this;
    }

    public void func_78790_a(float posX, float posY, float posZ, int width, int height, int depth, float scale) {
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, posX, posY, posZ, width, height, depth, scale));
    }

    public AdvancedModelRenderer addBox(String name, float posX, float posY, float posZ, int width, int height, int depth) {
        name = this.field_78802_n + "." + name;
        TextureOffset textureoffset = this.modelBase.func_78084_a(name);
        this.setTextureOffset(textureoffset.field_78783_a, textureoffset.field_78782_b);
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, posX, posY, posZ, width, height, depth, 0.0f).func_78244_a(name));
        return this;
    }

    public AdvancedModelRenderer add3DTexture(float posX, float posY, float posZ, int width, int height) {
        this.field_78804_l.add(new Model3DTexture(this, this.field_78803_o, this.field_78813_p, width, height));
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_78788_d(float scale) {
        this.field_78811_r = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.field_78811_r, (int)4864);
        for (Object aCubeList : this.field_78804_l) {
            ((ModelBox)aCubeList).func_178780_a(Tessellator.func_178181_a().func_178180_c(), scale);
        }
        GL11.glEndList();
        this.field_78812_q = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78794_c(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (!this.field_78812_q) {
                this.func_78788_d(scale);
            }
            GL11.glTranslatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            this.rotationOrder.rotate(this.field_78795_f * 57.29578f, this.field_78796_g * 57.29578f, this.field_78808_h * 57.29578f);
            this.secondaryRotationOrder.rotate(this.secondaryRotateAngleX * 57.29578f, this.secondaryRotateAngleY * 57.29578f, this.secondaryRotateAngleZ * 57.29578f);
            GL11.glTranslatef((float)this.aftMoveX, (float)this.aftMoveY, (float)this.aftMoveZ);
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
        }
    }

    private void baseRender(float scale) {
        if (this.isGlowing && this.shouldntGlow) {
            return;
        }
        if (this.isGlowing) {
            List boxModels = this.field_78804_l;
            for (ModelBox box : boxModels) {
                int bri = 1;
                float expand = 0.45f;
                float meteorExpandY = 0.0f;
                for (int i = 0; i < bri; ++i) {
                    float width = box.field_78248_d - box.field_78252_a;
                    float height = box.field_78249_e - box.field_78250_b;
                    float depth = box.field_78246_f - box.field_78251_c;
                    float localExpand = expand * (float)(i + 1);
                    float localMeteorExpandY = meteorExpandY * (float)(i + 1);
                    float newWidth = width + 2.0f * localExpand;
                    float newHeight = height + 2.0f * (this.isMeteorLightGlow ? localMeteorExpandY : localExpand);
                    float newDepth = depth + 2.0f * localExpand;
                    float scaleX = newWidth / width;
                    float scaleY = newHeight / height;
                    float scaleZ = newDepth / depth;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((box.field_78252_a - expand - scaleX * box.field_78252_a) / 16.0f), (float)((box.field_78250_b - (this.isMeteorLightGlow ? meteorExpandY : expand) - scaleY * box.field_78250_b) / 16.0f), (float)((box.field_78251_c - expand - scaleZ * box.field_78251_c) / 16.0f));
                    GL11.glScalef((float)scaleX, (float)scaleY, (float)scaleZ);
                    box.func_178780_a(Tessellator.func_178181_a().func_178180_c(), scale);
                    GL11.glPopMatrix();
                }
            }
        } else {
            GL11.glCallList((int)this.field_78811_r);
        }
        if (this.field_78805_m != null) {
            for (ModelRenderer modelRenderer : this.field_78805_m) {
                if (modelRenderer instanceof AdvancedModelRenderer) {
                    ((AdvancedModelRenderer)modelRenderer).isGlowing = this.isGlowing;
                }
                modelRenderer.func_78785_a(scale);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78785_a(float scale) {
        if (!this.field_78807_k) {
            if (!this.field_78812_q) {
                this.func_78788_d(scale);
            }
            GL11.glTranslatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
            if (this.field_78795_f == 0.0f && this.field_78796_g == 0.0f && this.field_78808_h == 0.0f) {
                if (this.field_78800_c == 0.0f && this.field_78797_d == 0.0f && this.field_78798_e == 0.0f) {
                    if (this.scaleX == 1.0f && this.scaleY == 1.0f && this.scaleZ == 1.0f) {
                        if (this.field_78806_j) {
                            GL11.glCallList((int)this.field_78811_r);
                        }
                        this.callback(scale);
                        if (this.field_78805_m != null) {
                            for (ModelRenderer childModel : this.field_78805_m) {
                                childModel.func_78785_a(scale);
                            }
                        }
                    } else {
                        GL11.glPushMatrix();
                        GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
                        if (this.field_78806_j) {
                            GL11.glCallList((int)this.field_78811_r);
                        }
                        this.callback(scale);
                        if (this.field_78805_m != null) {
                            for (ModelRenderer childModel : this.field_78805_m) {
                                childModel.func_78785_a(scale);
                            }
                        }
                        GL11.glPopMatrix();
                    }
                } else {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                    GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
                    if (this.field_78806_j) {
                        GL11.glCallList((int)this.field_78811_r);
                    }
                    this.callback(scale);
                    if (this.field_78805_m != null) {
                        for (ModelRenderer childModel : this.field_78805_m) {
                            childModel.func_78785_a(scale);
                        }
                    }
                    GL11.glPopMatrix();
                }
            } else {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                this.rotationOrder.rotate(this.field_78795_f * 57.29578f, this.field_78796_g * 57.29578f, this.field_78808_h * 57.29578f);
                GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
                if (this.field_78806_j) {
                    GL11.glCallList((int)this.field_78811_r);
                }
                this.callback(scale);
                if (this.field_78805_m != null) {
                    for (ModelRenderer childModel : this.field_78805_m) {
                        childModel.func_78785_a(scale);
                    }
                }
                GL11.glPopMatrix();
            }
            GL11.glTranslatef((float)(-this.field_82906_o), (float)(-this.field_82908_p), (float)(-this.field_82907_q));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78791_b(float scale) {
        if (!this.field_78807_k) {
            if (!this.field_78812_q) {
                this.func_78788_d(scale);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            this.rotationOrder.rotate(this.field_78795_f * 57.29578f, this.field_78796_g * 57.29578f, this.field_78808_h * 57.29578f);
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            if (this.field_78806_j) {
                GL11.glCallList((int)this.field_78811_r);
            }
            this.callback(scale);
            GL11.glPopMatrix();
        }
    }

    public void func_78793_a(float rotationPointX, float rotationPointY, float rotationPointZ) {
        this.field_78800_c = rotationPointX;
        this.field_78797_d = rotationPointY;
        this.field_78798_e = rotationPointZ;
    }

    @Override
    public void setRotationAngles(float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        this.field_78795_f = rotateAngleX;
        this.field_78796_g = rotateAngleY;
        this.field_78808_h = rotateAngleZ;
    }

    public AdvancedModelRenderer setTextureOffset(int textureOffsetX, int textureOffsetY) {
        this.field_78803_o = textureOffsetX;
        this.field_78813_p = textureOffsetY;
        return this;
    }

    public AdvancedModelRenderer setTextureSize(int textureWidth, int textureHeight) {
        this.field_78801_a = textureWidth;
        this.field_78799_b = textureHeight;
        return this;
    }

    public RotationOrder getRotationOrder() {
        return this.rotationOrder;
    }

    public void setRotationOrder(RotationOrder rotationOrder) {
        this.rotationOrder = rotationOrder;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
    }

    public void setScale(float scale) {
        this.scaleY = this.scaleZ = scale;
        this.scaleX = this.scaleZ;
    }

    public void addCallback(IModelRenderCallback callback) {
        this.callbacks.add(callback);
    }
}

