/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import java.util.EnumMap;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.util.vector.Quaternion;
import thebetweenlands.client.render.entity.RenderPlayerRower;
import thebetweenlands.client.render.model.entity.rowboat.ModelWeedwoodRowboat;
import thebetweenlands.common.entity.rowboat.EntityWeedwoodRowboat;
import thebetweenlands.common.entity.rowboat.ShipSide;
import thebetweenlands.util.CubicBezier;
import thebetweenlands.util.MathUtils;
import thebetweenlands.util.Matrix;
import thebetweenlands.util.Quat;

public class RenderWeedwoodRowboat
extends Render<EntityWeedwoodRowboat> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "textures/entity/weedwood_rowboat.png");
    private static final ResourceLocation TEXTURE_TARRED = new ResourceLocation("thebetweenlands", "textures/entity/weedwood_rowboat_tarred.png");
    private static final CubicBezier PULL_CURVE = new CubicBezier(1.0f, 0.0f, 1.0f, 0.25f);
    private RenderPlayerRower rowerDefaultRender;
    private RenderPlayerRower rowerSlimRender;
    private ModelWeedwoodRowboat model = new ModelWeedwoodRowboat();
    private int maskId = -1;
    private Matrix matrix = new Matrix();
    private EnumMap<ShipSide, Vec3d> grips = ShipSide.newEnumMap(Vec3d.class, Vec3d.field_186680_a, Vec3d.field_186680_a);
    private EnumMap<ShipSide, ArmArticulation> arms = ShipSide.newEnumMap(ArmArticulation.class, new ArmArticulation(), new ArmArticulation());
    private EnumMap<ShipSide, Float> shoulderZ = ShipSide.newEnumMap(Float.TYPE, new Float[0]);
    private Vec3d arm = Vec3d.field_186680_a;
    private float bodyRotateAngleX;
    private float bodyRotateAngleY;

    public RenderWeedwoodRowboat(RenderManager mgr) {
        super(mgr);
        this.rowerDefaultRender = new RenderPlayerRower(mgr, false);
        this.rowerSlimRender = new RenderPlayerRower(mgr, true);
    }

    public boolean func_188295_H_() {
        return true;
    }

    public void doRender(EntityWeedwoodRowboat rowboat, double x, double y, double z, float yaw, float delta) {
        this.model.animateOar(rowboat, ShipSide.STARBOARD, delta);
        this.model.animateOar(rowboat, ShipSide.PORT, delta);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + 1.5 + rowboat.getWaveHeight(delta)), (double)z);
        this.roll(rowboat, yaw, delta);
        this.func_180548_c((Entity)rowboat);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.model.render(rowboat, 0.0625f, delta);
        GlStateManager.func_179121_F();
    }

    public void renderMultipass(EntityWeedwoodRowboat rowboat, double x, double y, double z, float yaw, float delta) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + 1.5 + rowboat.getWaveHeight(delta)), (double)z);
        this.roll(rowboat, yaw, delta);
        this.renderWaterMask();
        GlStateManager.func_179121_F();
    }

    private void roll(EntityWeedwoodRowboat rowboat, float yaw, float delta) {
        Quat rot = rowboat.getRotation(delta);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
        GlStateManager.func_187444_a((Quaternion)new Quaternion((float)rot.x, (float)rot.y, (float)rot.z, (float)rot.w));
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float timeSinceHit = (float)rowboat.func_70268_h() - delta;
        float damageTaken = rowboat.func_70271_g() - delta;
        if (damageTaken < 0.0f) {
            damageTaken = 0.0f;
        }
        if (timeSinceHit > 0.0f) {
            GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)timeSinceHit) * timeSinceHit * damageTaken / 10.0f * (float)rowboat.func_70267_i()), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void onLivingRender(RenderPlayerEvent.Pre event) {
        EntityPlayer e = event.getEntityPlayer();
        Entity riding = e.func_184187_bx();
        if (riding instanceof EntityWeedwoodRowboat && riding.func_184179_bs() == e) {
            event.setCanceled(true);
            EntityWeedwoodRowboat rowboat = (EntityWeedwoodRowboat)riding;
            float delta = event.getPartialRenderTick();
            this.model.animateOar(rowboat, ShipSide.STARBOARD, delta);
            this.model.animateOar(rowboat, ShipSide.PORT, delta);
            this.calculateGrip(rowboat, ShipSide.STARBOARD, delta);
            this.calculateGrip(rowboat, ShipSide.PORT, delta);
            this.articulateBody(rowboat, delta);
            float yaw = rowboat.field_70126_B + (rowboat.field_70177_z - rowboat.field_70126_B) * delta;
            this.articulateArm(ShipSide.STARBOARD, yaw);
            this.articulateArm(ShipSide.PORT, yaw);
            AbstractClientPlayer player = (AbstractClientPlayer)e;
            RenderPlayerRower render = "slim".equals(player.func_175154_l()) ? this.rowerSlimRender : this.rowerDefaultRender;
            render.renderPilot(player, this.arms.get((Object)ShipSide.STARBOARD), this.arms.get((Object)ShipSide.PORT), this.bodyRotateAngleX, this.bodyRotateAngleY, event.getX(), event.getY(), event.getZ(), delta);
        }
    }

    private void calculateGrip(EntityWeedwoodRowboat rowboat, ShipSide side, float delta) {
        int dir = side == ShipSide.PORT ? 1 : -1;
        this.matrix.setIdentity();
        float yaw = (rowboat.field_70126_B + (rowboat.field_70177_z - rowboat.field_70126_B) * delta) * ((float)Math.PI / 180);
        double pelvis = 0.75;
        this.matrix.translate(0.0, pelvis - 1.5, 0.0);
        this.matrix.rotate(yaw, 0.0, 1.0, 0.0);
        this.matrix.rotate(rowboat.getRotation(delta));
        this.matrix.rotate(-yaw, 0.0, 1.0, 0.0);
        this.matrix.translate(0.0, 1.5, 0.0);
        this.matrix.scale(-1.0, -1.0, 1.0);
        this.matrix.translate(-0.5625 * (double)dir, pelvis + 0.625, -0.4375);
        this.createOarTransformationMatrix(side);
        this.grips.put(side, this.matrix.transform(new Vec3d(0.0, -0.375, 0.0)));
    }

    private void createOarTransformationMatrix(ShipSide side) {
        ModelRenderer oar = this.model.getOar(side);
        this.matrix.rotate(oar.field_78808_h, 0.0, 0.0, 1.0);
        this.matrix.rotate(oar.field_78795_f, 1.0, 0.0, 0.0);
        this.matrix.rotate(oar.field_78796_g, 0.0, 1.0, 0.0);
    }

    private void articulateBody(EntityWeedwoodRowboat rowboat, float delta) {
        float pow = rowboat.getPilotPower(delta);
        float leftZ = (float)this.grips.get((Object)((Object)ShipSide.STARBOARD)).field_72449_c;
        float rightZ = (float)this.grips.get((Object)((Object)ShipSide.PORT)).field_72449_c;
        float generalX = 0.0f;
        float generalY = 0.0f;
        float powerX = 0.0f;
        if (pow != 0.0f) {
            float port = rowboat.getRowProgress(ShipSide.PORT, delta);
            powerX = MathHelper.func_76126_a((float)((port + 0.03f) * -28.0f)) * 0.32f + 0.05f;
        }
        if (pow != 1.0f) {
            float upward;
            float tilt = (float)Math.atan2(leftZ, rightZ) + 2.3561945f;
            generalY = tilt * 0.75f;
            float z = (leftZ + rightZ) / 2.0f;
            float y = (float)(this.grips.get((Object)((Object)ShipSide.STARBOARD)).field_72448_b + this.grips.get((Object)((Object)ShipSide.PORT)).field_72448_b) / 2.0f;
            float forward = -z * MathUtils.linearTransformf(Math.abs(leftZ + rightZ), 0.0f, 0.05f, 1.1f, 1.0f);
            float downward = MathHelper.func_76131_a((float)((-y - 0.3f) / 0.35f), (float)0.0f, (float)1.0f);
            if (downward < 0.6f) {
                upward = MathUtils.linearTransformf(downward, 0.0f, 0.6f, 1.0f, 0.0f);
                upward = PULL_CURVE.eval(upward) * 0.6f;
            } else {
                upward = 0.0f;
            }
            float lean = (forward + downward * 0.1f) * (1.0f - upward) + upward * 0.2f;
            generalX = MathUtils.linearTransformf(lean, 0.2f, 0.72f, -0.45f, 0.5f);
        }
        this.bodyRotateAngleX = generalX + (powerX - generalX) * pow;
        this.bodyRotateAngleY = generalY * (1.0f - pow);
        this.shoulderZ.put(ShipSide.STARBOARD, Float.valueOf(MathHelper.func_76131_a((float)((leftZ + 0.44f) * 0.45f - 0.02f), (float)-0.1f, (float)0.1f)));
        this.shoulderZ.put(ShipSide.PORT, Float.valueOf(MathHelper.func_76131_a((float)((rightZ + 0.44f) * 0.45f - 0.02f), (float)-0.1f, (float)0.1f)));
    }

    private void articulateArm(ShipSide side, float yaw) {
        int dir = side == ShipSide.PORT ? 1 : -1;
        float ps = 0.9375f;
        this.createBodyTransformationMatrix();
        this.matrix.translate(-0.375f * (float)dir, -0.625, this.shoulderZ.get((Object)side).floatValue());
        this.arm = this.matrix.transform(Vec3d.field_186680_a);
        Vec3d grip = this.grips.get((Object)side);
        float targetX = (float)(grip.field_72450_a - this.arm.field_72450_a);
        float targetY = (float)(grip.field_72448_b - this.arm.field_72448_b);
        float targetZ = (float)(grip.field_72449_c - this.arm.field_72449_c);
        float horizontalDistSq = targetX * targetX + targetZ * targetZ;
        float targetPitch = (float)Math.atan2(targetY, MathHelper.func_76129_c((float)horizontalDistSq));
        float targetLen = MathHelper.func_76129_c((float)(horizontalDistSq + targetY * targetY));
        float upperArmLen = 0.25f;
        float lowerArmLen = 0.265625f;
        float shoulderAngle = (float)Math.acos((upperArmLen * upperArmLen + targetLen * targetLen - lowerArmLen * lowerArmLen) / (2.0f * upperArmLen * targetLen));
        float flexionAngle = (float)Math.acos((upperArmLen * upperArmLen + lowerArmLen * lowerArmLen - targetLen * targetLen) / (2.0f * upperArmLen * lowerArmLen));
        ArmArticulation armArt = this.arms.get((Object)side);
        armArt.shoulderAngleX = (shoulderAngle != shoulderAngle ? -1.5707964f - targetPitch : shoulderAngle - 1.5707964f - targetPitch) - this.bodyRotateAngleX;
        armArt.shoulderAngleY = (float)Math.atan2(targetZ, targetX) + 1.5707964f - this.bodyRotateAngleY;
        armArt.flexionAngle = shoulderAngle != shoulderAngle ? 0.0f : (flexionAngle - (float)Math.PI) * 57.29578f;
        armArt.shoulderZ = this.shoulderZ.get((Object)side).floatValue();
    }

    private void createBodyTransformationMatrix() {
        this.matrix.setIdentity();
        this.matrix.translate(0.0, -1.62, 0.0);
        this.matrix.scale(-1.0, -1.0, 1.0);
        this.matrix.scale(0.9375, 0.9375, 0.9375);
        this.matrix.translate(0.0, -1.5078125, 0.0);
        this.matrix.translate(0.0, 0.75, 0.0);
        this.matrix.rotate(this.bodyRotateAngleY, 0.0, 1.0, 0.0);
        this.matrix.rotate(this.bodyRotateAngleX, 1.0, 0.0, 0.0);
    }

    private void renderWaterMask() {
        if (this.maskId == -1) {
            this.maskId = GLAllocation.func_74526_a((int)1);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vb = tessellator.func_178180_c();
            vb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            double y = -0.687;
            double midWidth = 0.55;
            double midDepth = 0.65;
            double endWidth = 0.4;
            double endDepth = 0.16;
            double endOffset = 0.81;
            vb.func_181662_b(-midWidth, y, midDepth).func_181675_d();
            vb.func_181662_b(midWidth, y, midDepth).func_181675_d();
            vb.func_181662_b(midWidth, y, -midDepth).func_181675_d();
            vb.func_181662_b(-midWidth, y, -midDepth).func_181675_d();
            vb.func_181662_b(-endWidth, y, endDepth - endOffset).func_181675_d();
            vb.func_181662_b(endWidth, y, endDepth - endOffset).func_181675_d();
            vb.func_181662_b(endWidth, y, -endDepth - endOffset).func_181675_d();
            vb.func_181662_b(-endWidth, y, -endDepth - endOffset).func_181675_d();
            vb.func_181662_b(-endWidth, y, endDepth + endOffset).func_181675_d();
            vb.func_181662_b(endWidth, y, endDepth + endOffset).func_181675_d();
            vb.func_181662_b(endWidth, y, -endDepth + endOffset).func_181675_d();
            vb.func_181662_b(-endWidth, y, -endDepth + endOffset).func_181675_d();
            GlStateManager.func_187423_f((int)this.maskId, (int)4865);
            GlStateManager.func_179090_x();
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            tessellator.func_78381_a();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_187415_K();
        } else {
            GlStateManager.func_179148_o((int)this.maskId);
        }
    }

    protected ResourceLocation getEntityTexture(EntityWeedwoodRowboat rowboat) {
        return rowboat.isTarred() ? TEXTURE_TARRED : TEXTURE;
    }

    public static class ArmArticulation {
        public float shoulderAngleX;
        public float shoulderAngleY;
        public float flexionAngle;
        public float shoulderZ;
    }
}

