/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import thebetweenlands.client.render.particle.entity.ParticleBeam;
import thebetweenlands.common.entity.projectiles.EntityPredatorArrowGuide;
import thebetweenlands.util.LightingUtil;

public class RenderPredatorArrowGuide
extends Render<EntityPredatorArrowGuide> {
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("thebetweenlands:textures/particle/beam.png");

    public RenderPredatorArrowGuide(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityPredatorArrowGuide entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        Entity target = entity.getTarget();
        Entity ridingEntity = entity.func_184187_bx();
        if (target != null) {
            double ix = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double iy = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double iz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            double targetIx = target.field_70142_S + (target.field_70165_t - target.field_70142_S) * (double)partialTicks;
            double targetIy = target.field_70137_T + (target.field_70163_u - target.field_70137_T) * (double)partialTicks + (double)target.func_70047_e();
            double targetIz = target.field_70136_U + (target.field_70161_v - target.field_70136_U) * (double)partialTicks;
            double diffX = targetIx - ix;
            double diffY = targetIy - iy;
            double diffZ = targetIz - iz;
            LightingUtil.INSTANCE.setLighting(255);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)false);
            this.func_110776_a(BEAM_TEXTURE);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y - (ridingEntity != null ? entity.field_70163_u - ridingEntity.field_70163_u : 0.0)), (double)z);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            ParticleBeam.buildBeam(diffX, diffY, diffZ, new Vec3d(-diffX, -diffY, -diffZ), 0.05f, 0.0f, 2.0f, ActiveRenderInfo.func_178808_b(), ActiveRenderInfo.func_178803_d(), ActiveRenderInfo.func_178805_e(), ActiveRenderInfo.func_178807_f(), ActiveRenderInfo.func_178809_c(), (vx, vy, vz, u, v) -> buffer.func_181662_b(vx, vy, vz).func_187315_a(u, v).func_181669_b(35, 80, 110, 255).func_181675_d());
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179089_o();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            LightingUtil.INSTANCE.revert();
        }
    }

    protected ResourceLocation getEntityTexture(EntityPredatorArrowGuide entity) {
        return null;
    }
}

