/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.handler.DecayRenderHandler;
import thebetweenlands.client.render.entity.RenderWeedwoodRowboat;
import thebetweenlands.client.render.entity.layer.LayerRowerArmor;
import thebetweenlands.client.render.entity.layer.LayerRowerWear;
import thebetweenlands.client.render.model.entity.rowboat.ModelBipedRower;
import thebetweenlands.client.render.model.entity.rowboat.ModelPlayerRower;

public class RenderPlayerRower
extends RenderLivingBase<AbstractClientPlayer> {
    private ModelBipedRower[] models;
    private ModelBiped wearModel;

    public RenderPlayerRower(RenderManager mgr, boolean slimArms) {
        super(mgr, (ModelBase)new ModelPlayerRower(0.0f, slimArms, new ModelBipedRower.BipedTextureUVs(32, 48, 40, 16, 16, 48, 0, 16)), 0.5f);
        this.field_177097_h.clear();
        LayerRowerWear wear = new LayerRowerWear(slimArms);
        this.func_177094_a(wear);
        LayerRowerArmor armor = new LayerRowerArmor(this);
        this.func_177094_a((LayerRenderer)armor);
        this.func_177094_a((LayerRenderer)new LayerCustomHead((ModelRenderer)new HeadTransform((ModelBase)this.getMainModel())));
        this.func_177094_a(new DecayRenderHandler.LayerDecay(this, box -> false));
        this.models = new ModelBipedRower[]{this.getMainModel(), wear.getModel(), armor.getChest(), armor.getLeggings()};
        this.wearModel = wear.getModel();
    }

    public ModelPlayerRower getMainModel() {
        return (ModelPlayerRower)super.func_177087_b();
    }

    public void renderPilot(AbstractClientPlayer player, RenderWeedwoodRowboat.ArmArticulation leftArm, RenderWeedwoodRowboat.ArmArticulation rightArm, float bodyRotateAngleX, float bodyRotateAngleY, double x, double y, double z, float delta) {
        for (ModelBipedRower model : this.models) {
            model.field_178724_i.field_78795_f = leftArm.shoulderAngleX;
            model.field_178724_i.field_78796_g = leftArm.shoulderAngleY;
            model.setLeftArmFlexionAngle(leftArm.flexionAngle);
            model.field_178723_h.field_78795_f = rightArm.shoulderAngleX;
            model.field_178723_h.field_78796_g = rightArm.shoulderAngleY;
            model.setRightArmFlexionAngle(rightArm.flexionAngle);
            model.field_78115_e.field_78795_f = bodyRotateAngleX;
            model.field_78115_e.field_78796_g = bodyRotateAngleY;
            model.field_78116_c.field_78795_f = -bodyRotateAngleX * 0.75f;
            model.field_78116_c.field_78796_g = -bodyRotateAngleY * 0.75f;
            model.field_178724_i.field_78798_e = leftArm.shoulderZ * 16.0f;
            model.field_178723_h.field_78798_e = rightArm.shoulderZ * 16.0f;
        }
        this.doRender(player, x, y, z, player.field_70126_B + (player.field_70177_z - player.field_70126_B) * delta, delta);
    }

    public void doRender(AbstractClientPlayer player, double x, double y, double z, float yaw, float delta) {
        this.getMainModel().field_178720_f.field_78806_j = player.func_175148_a(EnumPlayerModelParts.HAT);
        this.wearModel.field_78115_e.field_78806_j = player.func_175148_a(EnumPlayerModelParts.JACKET);
        this.wearModel.field_178722_k.field_78806_j = player.func_175148_a(EnumPlayerModelParts.LEFT_PANTS_LEG);
        this.wearModel.field_178721_j.field_78806_j = player.func_175148_a(EnumPlayerModelParts.RIGHT_PANTS_LEG);
        this.wearModel.field_178724_i.field_78806_j = player.func_175148_a(EnumPlayerModelParts.LEFT_SLEEVE);
        this.wearModel.field_178723_h.field_78806_j = player.func_175148_a(EnumPlayerModelParts.RIGHT_SLEEVE);
        GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        super.func_76986_a((EntityLivingBase)player, x, y, z, yaw, delta);
        GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
    }

    protected void preRenderCallback(AbstractClientPlayer player, float delta) {
        float scale = 0.9375f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
    }

    protected boolean canRenderName(AbstractClientPlayer entity) {
        return !entity.func_175144_cb() && super.func_177070_b((EntityLivingBase)entity);
    }

    protected void renderEntityName(AbstractClientPlayer player, double x, double y, double z, String name, double distance) {
        Scoreboard scoreboard;
        ScoreObjective sidebarObj;
        if (distance < 100.0 && (sidebarObj = (scoreboard = player.func_96123_co()).func_96539_a(2)) != null) {
            Score score = scoreboard.func_96529_a(player.func_70005_c_(), sidebarObj);
            this.func_147906_a((Entity)player, score.func_96652_c() + " " + sidebarObj.func_96678_d(), x, y, z, 64);
            y += (double)((float)this.func_76983_a().field_78288_b * 1.15f * 0.025f);
        }
        super.func_188296_a((Entity)player, x, y, z, name, distance);
    }

    protected ResourceLocation getEntityTexture(AbstractClientPlayer entity) {
        return entity.func_110306_p();
    }

    class HeadTransform
    extends ModelRenderer {
        HeadTransform(ModelBase model) {
            super(model);
        }

        public void func_78794_c(float scale) {
            RenderPlayerRower.this.getMainModel().field_78115_e.func_78794_c(scale);
            RenderPlayerRower.this.getMainModel().field_78116_c.func_78794_c(scale);
        }
    }
}

