/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui.menu;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWinGame;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.realms.RealmsBridge;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServerDemo;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GLContext;
import thebetweenlands.client.gui.menu.GuiButtonMainMenu;
import thebetweenlands.client.gui.menu.GuiMainMenuBackground;
import thebetweenlands.common.config.BetweenlandsConfig;

public class GuiBLMainMenu
extends GuiMainMenu {
    public static final ResourceLocation LOGO_TEXTURE = new ResourceLocation("thebetweenlands", "textures/gui/main/logo.png");
    private GuiButton realmsButton;
    private boolean hasCheckedForRealmsNotification;
    private GuiScreen realmsNotification;
    private int widthCopyright;
    private int widthCopyrightRest;
    private GuiButton modButton;
    private NotificationModUpdateScreen modUpdateNotification;
    private final Object threadLock = new Object();
    private int openGLWarning2Width;
    private int openGLWarning1Width;
    private int openGLWarningX1;
    private int openGLWarningY1;
    private int openGLWarningX2;
    private int openGLWarningY2;
    private String openGLWarning1 = "";
    private String openGLWarning2 = "";
    private int ticks;
    private GuiMainMenuBackground background = new GuiMainMenuBackground(new ResourceLocation("thebetweenlands", "textures/gui/main/layer"), 4);

    public GuiBLMainMenu() {
        if (!GLContext.getCapabilities().OpenGL20 && !OpenGlHelper.func_153193_b()) {
            this.openGLWarning1 = I18n.func_135052_a((String)"title.oldgl1", (Object[])new Object[0]);
            this.openGLWarning2 = I18n.func_135052_a((String)"title.oldgl2", (Object[])new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onGuiOpened(GuiOpenEvent event) {
        if (BetweenlandsConfig.GENERAL.blMainMenu && event.getGui() instanceof GuiMainMenu && !(event.getGui() instanceof GuiBLMainMenu)) {
            event.setGui((GuiScreen)new GuiBLMainMenu());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73866_w_() {
        this.widthCopyright = this.field_146289_q.func_78256_a("Copyright Mojang AB. Do not distribute!");
        this.widthCopyrightRest = this.field_146294_l - this.widthCopyright - 2;
        this.background.field_146297_k = this.field_146297_k;
        this.background.field_146294_l = this.field_146294_l;
        this.background.field_146295_m = this.field_146295_m;
        this.background.func_73866_w_();
        this.field_146292_n.clear();
        int j = this.field_146295_m / 4 + 48;
        this.field_146292_n.add(new GuiButtonMainMenu(1, this.field_146294_l / 2 - 100, j, I18n.func_135052_a((String)"menu.singleplayer", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonMainMenu(2, this.field_146294_l / 2 - 100, j + 24, I18n.func_135052_a((String)"menu.multiplayer", (Object[])new Object[0])));
        this.realmsButton = new GuiButtonMainMenu(14, this.field_146294_l / 2 + 2, j + 48, 98, 20, I18n.func_135052_a((String)"menu.online", (Object[])new Object[0]).replace("Minecraft", "").trim());
        this.field_146292_n.add(this.realmsButton);
        this.modButton = new GuiButtonMainMenu(6, this.field_146294_l / 2 - 100, j + 48, 98, 20, I18n.func_135052_a((String)"fml.menu.mods", (Object[])new Object[0]));
        this.field_146292_n.add(this.modButton);
        this.field_146292_n.add(new GuiButtonMainMenu(5, this.field_146294_l / 2 - 124, j + 72 + 12, 20, 20, "L"));
        this.field_146292_n.add(new GuiButtonMainMenu(0, this.field_146294_l / 2 - 100, j + 72 + 12, 98, 20, I18n.func_135052_a((String)"menu.options", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonMainMenu(4, this.field_146294_l / 2 + 2, j + 72 + 12, 98, 20, I18n.func_135052_a((String)"menu.quit", (Object[])new Object[0])));
        Object object = this.threadLock;
        synchronized (object) {
            this.openGLWarning1Width = this.field_146289_q.func_78256_a(this.openGLWarning1);
            this.openGLWarning2Width = this.field_146289_q.func_78256_a(this.openGLWarning2);
            int k = Math.max(this.openGLWarning1Width, this.openGLWarning2Width);
            this.openGLWarningX1 = (this.field_146294_l - k) / 2;
            this.openGLWarningY1 = ((GuiButton)this.field_146292_n.get((int)0)).field_146129_i - 24;
            this.openGLWarningX2 = this.openGLWarningX1 + k;
            this.openGLWarningY2 = this.openGLWarningY1 + 24;
        }
        this.field_146297_k.func_181537_a(false);
        if (Minecraft.func_71410_x().field_71474_y.func_74308_b(GameSettings.Options.REALMS_NOTIFICATIONS) && !this.hasCheckedForRealmsNotification) {
            RealmsBridge realmsbridge = new RealmsBridge();
            this.realmsNotification = realmsbridge.getNotificationScreen((GuiScreen)this);
            this.hasCheckedForRealmsNotification = true;
        }
        if (this.areRealmsNotificationsEnabled()) {
            this.realmsNotification.func_183500_a(this.field_146294_l, this.field_146295_m);
            this.realmsNotification.func_73866_w_();
        }
        this.modUpdateNotification = NotificationModUpdateScreen.init((GuiMainMenu)this, (GuiButton)this.modButton);
    }

    private boolean areRealmsNotificationsEnabled() {
        return Minecraft.func_71410_x().field_71474_y.func_74308_b(GameSettings.Options.REALMS_NOTIFICATIONS) && this.realmsNotification != null;
    }

    public void func_146281_b() {
        this.background.func_146281_b();
    }

    protected void func_146284_a(GuiButton button) {
        ISaveFormat isaveformat;
        WorldInfo worldinfo;
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiOptions((GuiScreen)this, this.field_146297_k.field_71474_y));
        }
        if (button.field_146127_k == 5) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLanguage((GuiScreen)this, this.field_146297_k.field_71474_y, this.field_146297_k.func_135016_M()));
        }
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldSelection((GuiScreen)this));
        }
        if (button.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiMultiplayer((GuiScreen)this));
        }
        if (button.field_146127_k == 14 && this.realmsButton.field_146125_m) {
            RealmsBridge realmsbridge = new RealmsBridge();
            realmsbridge.switchToRealms((GuiScreen)this);
        }
        if (button.field_146127_k == 4) {
            this.field_146297_k.func_71400_g();
        }
        if (button.field_146127_k == 6) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiModList((GuiScreen)this));
        }
        if (button.field_146127_k == 11) {
            this.field_146297_k.func_71371_a("Demo_World", "Demo_World", WorldServerDemo.field_73071_a);
        }
        if (button.field_146127_k == 12 && (worldinfo = (isaveformat = this.field_146297_k.func_71359_d()).func_75803_c("Demo_World")) != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"selectWorld.deleteQuestion", (Object[])new Object[0]), "'" + worldinfo.func_76065_j() + "' " + I18n.func_135052_a((String)"selectWorld.deleteWarning", (Object[])new Object[0]), I18n.func_135052_a((String)"selectWorld.deleteButton", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), 12));
        }
    }

    public void func_73876_c() {
        ++this.ticks;
        this.background.func_73876_c();
        if (this.areRealmsNotificationsEnabled()) {
            this.realmsNotification.func_73876_c();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.background.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179089_o();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.field_146297_k.func_110434_K().func_110577_a(LOGO_TEXTURE);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 80, 20.0f + MathHelper.func_76126_a((float)(((float)this.ticks + partialTicks) / 16.0f)) * 6.0f, 0.0, 0.0, 161.0, 79.0, 256.0, 256.0);
        this.func_73729_b(0, 0, 239, 0, 17, 16);
        ForgeHooksClient.renderMainMenu((GuiMainMenu)this, (FontRenderer)this.field_146289_q, (int)this.field_146294_l, (int)this.field_146295_m, (String)"");
        List brandings = Lists.reverse((List)FMLCommonHandler.instance().getBrandings(true));
        for (int brdline = 0; brdline < brandings.size(); ++brdline) {
            String brd = (String)brandings.get(brdline);
            if (Strings.isNullOrEmpty((String)brd)) continue;
            this.func_73731_b(this.field_146289_q, brd, 2, this.field_146295_m - (10 + brdline * (this.field_146289_q.field_78288_b + 1)), 0xFFFFFF);
        }
        this.func_73731_b(this.field_146289_q, "Copyright Mojang AB. Do not distribute!", this.widthCopyrightRest, this.field_146295_m - 10, -1);
        if (mouseX > this.widthCopyrightRest && mouseX < this.widthCopyrightRest + this.widthCopyright && mouseY > this.field_146295_m - 10 && mouseY < this.field_146295_m && Mouse.isInsideWindow()) {
            GuiBLMainMenu.func_73734_a((int)this.widthCopyrightRest, (int)(this.field_146295_m - 1), (int)(this.widthCopyrightRest + this.widthCopyright), (int)this.field_146295_m, (int)-1);
        }
        if (this.openGLWarning1 != null && !this.openGLWarning1.isEmpty()) {
            GuiBLMainMenu.func_73734_a((int)(this.openGLWarningX1 - 2), (int)(this.openGLWarningY1 - 2), (int)(this.openGLWarningX2 + 2), (int)(this.openGLWarningY2 - 1), (int)0x55200000);
            this.func_73731_b(this.field_146289_q, this.openGLWarning1, this.openGLWarningX1, this.openGLWarningY1, -1);
            this.func_73731_b(this.field_146289_q, this.openGLWarning2, (this.field_146294_l - this.openGLWarning2Width) / 2, ((GuiButton)this.field_146292_n.get((int)0)).field_146129_i - 12, -1);
        }
        for (GuiButton button : this.field_146292_n) {
            button.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        if (this.areRealmsNotificationsEnabled()) {
            this.realmsNotification.func_73863_a(mouseX, mouseY, partialTicks);
        }
        this.modUpdateNotification.func_73863_a(mouseX, mouseY, partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        Object object = this.threadLock;
        synchronized (object) {
            String openGLWarningLink = "https://help.mojang.com/customer/portal/articles/325948?ref=game";
            if (!this.openGLWarning1.isEmpty() && !StringUtils.func_151246_b((String)openGLWarningLink) && mouseX >= this.openGLWarningX1 && mouseX <= this.openGLWarningX2 && mouseY >= this.openGLWarningY1 && mouseY <= this.openGLWarningY2) {
                GuiConfirmOpenLink guiconfirmopenlink = new GuiConfirmOpenLink((GuiYesNoCallback)this, openGLWarningLink, 13, true);
                guiconfirmopenlink.func_146358_g();
                this.field_146297_k.func_147108_a((GuiScreen)guiconfirmopenlink);
            }
        }
        if (mouseX > this.widthCopyrightRest && mouseX < this.widthCopyrightRest + this.widthCopyright && mouseY > this.field_146295_m - 10 && mouseY < this.field_146295_m) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiWinGame(false, Runnables.doNothing()));
        }
    }

    protected void drawTexturedModalRect(double x, double y, double u, double v, double width, double height, double textureWidth, double textureHeight) {
        double uscale = 1.0 / textureWidth;
        double vscale = 1.0 / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x + 0.0, y + height, (double)this.field_73735_i).func_187315_a(u * uscale, (v + height) * vscale).func_181675_d();
        buffer.func_181662_b(x + width, y + height, (double)this.field_73735_i).func_187315_a((u + width) * uscale, (v + height) * vscale).func_181675_d();
        buffer.func_181662_b(x + width, y + 0.0, (double)this.field_73735_i).func_187315_a((u + width) * uscale, v * vscale).func_181675_d();
        buffer.func_181662_b(x + 0.0, y + 0.0, (double)this.field_73735_i).func_187315_a(u * uscale, v * vscale).func_181675_d();
        tessellator.func_78381_a();
    }
}

