/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio.ambience.list;

import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import thebetweenlands.client.audio.ambience.AmbienceLayer;
import thebetweenlands.client.audio.ambience.AmbienceType;
import thebetweenlands.common.entity.EntityGrapplingHookNode;
import thebetweenlands.common.entity.EntityVolarkite;
import thebetweenlands.common.registries.AmbienceRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class WindAmbienceType
extends AmbienceType {
    @Override
    public boolean isActive() {
        Entity ridingEntity = this.getPlayer().func_184187_bx();
        return ridingEntity instanceof EntityGrapplingHookNode || ridingEntity instanceof EntityVolarkite;
    }

    @Override
    public AmbienceLayer getAmbienceLayer() {
        return AmbienceRegistry.DETAIL_LAYER;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getFadeTime() {
        return 10;
    }

    private double getVelocity(Entity entity) {
        double dx = entity.field_70165_t - entity.field_70169_q;
        double dy = entity.field_70163_u - entity.field_70167_r;
        double dz = entity.field_70161_v - entity.field_70166_s;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private double getSoundVariation(Entity entity) {
        return (Math.sin((double)entity.field_70173_aa * 0.1) + 1.0) / 2.0 * (Math.cos((double)entity.field_70173_aa * 0.2) + 1.0) / 2.0 * (Math.sin((double)entity.field_70173_aa * 0.3) + 1.0) / 2.0 * (Math.cos((double)entity.field_70173_aa * 0.4) + 1.0) / 2.0;
    }

    @Override
    public float getVolume() {
        Entity ridingEntity = this.getPlayer().func_184187_bx();
        if (ridingEntity != null) {
            return (1.0f - (float)Math.pow(1.0f - Math.min((float)this.getVelocity(ridingEntity) * 1.5f, 2.0f) / 2.0f, 0.5)) * 1.25f * (float)(1.0 - this.getSoundVariation((Entity)this.getPlayer()) * 0.5);
        }
        return 0.0f;
    }

    @Override
    public float getPitch() {
        Entity ridingEntity = this.getPlayer().func_184187_bx();
        if (ridingEntity != null) {
            return 0.9f + (1.0f - (float)Math.pow(1.0f - Math.min((float)this.getVelocity(ridingEntity) * 1.5f, 4.0f) / 4.0f, 0.5)) * 1.8f * (float)(1.0 - this.getSoundVariation((Entity)this.getPlayer()) * 0.5);
        }
        return 1.0f;
    }

    @Override
    public SoundCategory getCategory() {
        return SoundCategory.AMBIENT;
    }

    @Override
    public SoundEvent getSound() {
        return SoundRegistry.ROPE_SWING;
    }

    @Override
    public float getLowerPriorityVolume() {
        return 1.0f;
    }

    @Override
    public boolean isActiveInWorld(World world) {
        return true;
    }
}

