/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.TooltipRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketSetSlot;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketValueTypeRecipeLPElementSetRecipe;

public class LogicProgrammerTransferHandler<T extends ContainerLogicProgrammerBase>
implements IRecipeTransferHandler<T> {
    private final Class<T> clazz;

    public LogicProgrammerTransferHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        ILogicProgrammerElement element = ((ContainerLogicProgrammerBase)((Object)container)).getActiveElement();
        if (element != null) {
            if (element instanceof ValueTypeRecipeLPElement) {
                return this.handleRecipeElement((ValueTypeRecipeLPElement)element, container, recipeLayout, doTransfer);
            }
            return this.handleDefaultElement(element, container, recipeLayout, doTransfer);
        }
        return null;
    }

    protected IRecipeTransferError handleRecipeElement(ValueTypeRecipeLPElement element, T container, IRecipeLayout recipeLayout, boolean doTransfer) {
        ItemStack stack;
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList fluidInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        ArrayList fluidOutputs = Lists.newArrayList();
        for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
            stack = (ItemStack)Iterables.getFirst((Iterable)((IGuiIngredient)entry.getValue()).getAllIngredients(), (Object)ItemStack.field_190927_a);
            if (((IGuiIngredient)entry.getValue()).isInput()) {
                itemInputs.add(stack);
                continue;
            }
            itemOutputs.add(stack);
        }
        for (Map.Entry entry : recipeLayout.getFluidStacks().getGuiIngredients().entrySet()) {
            stack = (FluidStack)Iterables.getFirst((Iterable)((IGuiIngredient)entry.getValue()).getAllIngredients(), null);
            if (((IGuiIngredient)entry.getValue()).isInput()) {
                fluidInputs.add(stack);
                continue;
            }
            fluidOutputs.add(stack);
        }
        if (!element.isValidForRecipeGrid(itemInputs, fluidInputs, itemOutputs, fluidOutputs)) {
            return new IRecipeTransferError(){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.USER_FACING;
                }

                public void showError(Minecraft minecraft, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
                    TooltipRenderer.drawHoveringText((Minecraft)minecraft, Collections.singletonList(L10NHelpers.localize((String)"error.jei.integrateddynamics.recipetransfer.recipe.toobig.desc", (Object[])new Object[0])), (int)mouseX, (int)mouseY, (FontRenderer)minecraft.field_71466_p);
                }
            };
        }
        if (doTransfer) {
            element.setRecipeGrid((ContainerLogicProgrammerBase)((Object)container), itemInputs, fluidInputs, itemOutputs, fluidOutputs);
            IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketValueTypeRecipeLPElementSetRecipe(((ContainerLogicProgrammerBase)((Object)container)).field_75152_c, itemInputs, fluidInputs, itemOutputs, fluidOutputs));
        }
        return null;
    }

    protected IRecipeTransferError handleDefaultElement(ILogicProgrammerElement element, T container, IRecipeLayout recipeLayout, boolean doTransfer) {
        ItemStack itemStack = null;
        Object focusElement = recipeLayout.getFocus().getValue();
        if (focusElement instanceof ItemStack) {
            itemStack = (ItemStack)focusElement;
        } else if (focusElement instanceof FluidStack) {
            itemStack = new ItemStack(Items.field_151133_ar);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            fluidHandler.fill((FluidStack)focusElement, true);
            itemStack = fluidHandler.getContainer();
        }
        if (itemStack != null) {
            if (element.isItemValidForSlot(0, itemStack)) {
                if (doTransfer) {
                    this.setStackInSlot(container, 0, itemStack);
                }
            } else {
                return new IRecipeTransferError(){

                    public IRecipeTransferError.Type getType() {
                        return IRecipeTransferError.Type.USER_FACING;
                    }

                    public void showError(Minecraft minecraft, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
                    }
                };
            }
        }
        return null;
    }

    protected void setStackInSlot(T container, int slot, ItemStack itemStack) {
        int slotId = ((ContainerLogicProgrammerBase)((Object)container)).field_75151_b.size() - 37 + slot;
        container.func_75141_a(slotId, itemStack.func_77946_l());
        IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketSetSlot(((ContainerLogicProgrammerBase)((Object)container)).field_75152_c, slotId, itemStack));
    }
}

