/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.client.render.model.FacadeModel;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemFacade
extends ConfigurableItem {
    private static ItemFacade _instance = null;

    public static ItemFacade getInstance() {
        return _instance;
    }

    public ItemFacade(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
    }

    public IBlockState getFacadeBlock(ItemStack itemStack) {
        if (!itemStack.func_190926_b() && itemStack.func_77942_o()) {
            NBTTagCompound tag = itemStack.func_77978_p();
            String blockName = tag.func_74779_i("blockName");
            int meta = tag.func_74762_e("meta");
            return BlockHelpers.deserializeBlockState((Pair)Pair.of((Object)blockName, (Object)meta));
        }
        return null;
    }

    public ItemStack getFacadeBlockItem(ItemStack itemStack) {
        IBlockState blockState = this.getFacadeBlock(itemStack);
        if (blockState != null) {
            return BlockHelpers.getItemStackFromBlockState((IBlockState)blockState);
        }
        return null;
    }

    public void writeFacadeBlock(ItemStack itemStack, IBlockState blockState) {
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)itemStack);
        Pair serializedBlockState = BlockHelpers.serializeBlockState((IBlockState)blockState);
        tag.func_74778_a("blockName", (String)serializedBlockState.getLeft());
        tag.func_74768_a("meta", ((Integer)serializedBlockState.getRight()).intValue());
    }

    public String func_77653_i(ItemStack itemStack) {
        String suffix = TextFormatting.ITALIC + L10NHelpers.localize((String)"general.integrateddynamics.info.none", (Object[])new Object[0]);
        ItemStack itemStackInner = this.getFacadeBlockItem(itemStack);
        if (itemStackInner != null) {
            suffix = this.getFacadeBlockItem(itemStack).func_82833_r();
        }
        return super.func_77653_i(itemStack) + " - " + suffix;
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (!world.field_72995_K) {
            IFacadeable facadeable = (IFacadeable)TileHelpers.getCapability((World)world, (BlockPos)pos, null, FacadeableConfig.CAPABILITY);
            IBlockState blockState = this.getFacadeBlock(itemStack);
            if (facadeable != null && blockState != null && !facadeable.hasFacade()) {
                facadeable.setFacade(blockState);
                ItemBlockCable.playPlaceSound(world, pos);
                itemStack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(playerIn, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return new FacadeModel();
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        IBakedModel oldModel;
        FacadeModel.emptyModel = oldModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)this.eConfig.dynamicItemVariantLocation);
        super.onModelBakeEvent(event);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemFacade)) {
            return false;
        }
        ItemFacade other = (ItemFacade)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemFacade;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "ItemFacade()";
    }
}

