/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsAndFluidStackRecipeComponent;
import org.cyclops.integrateddynamics.block.BlockSqueezer;

public class SqueezerRecipeAppendix
extends RecipeAppendix<IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, ?>> {
    private static final int SLOT_INPUT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 23;
    private static final int SLOT_OUTPUT_OFFSET_X = 68;
    private static final AdvancedButtonEnum INPUT_ITEM = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT_FLUID = AdvancedButtonEnum.create();
    private final List<AdvancedButtonEnum> resultItems = Lists.newArrayList();

    public SqueezerRecipeAppendix(IInfoBook infoBook, IRecipe<IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, ?> recipe) {
        super(infoBook, recipe);
        for (int i = 0; i < ((IngredientsAndFluidStackRecipeComponent)recipe.getOutput()).getIngredients().size(); ++i) {
            this.resultItems.add(AdvancedButtonEnum.create());
        }
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeightInner() {
        return (((IngredientsAndFluidStackRecipeComponent)((IRecipe)this.recipe).getOutput()).getFluidStack() != null ? 23 : 0) + this.resultItems.size() * 23 - 3;
    }

    protected String getUnlocalizedTitle() {
        return "tile.blocks.integrateddynamics.squeezer.name";
    }

    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT_ITEM, new RecipeAppendix.ItemButton(this.getInfoBook()));
        for (AdvancedButtonEnum resultItem : this.resultItems) {
            this.renderItemHolders.put(resultItem, new RecipeAppendix.ItemButton(this.getInfoBook()));
        }
        this.renderItemHolders.put(RESULT_FLUID, new RecipeAppendix.FluidButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawElementInner(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(x + middle - 3, y + 2);
        int tick = this.getTick(gui);
        ItemStack inputItem = ((IngredientRecipeComponent)((IRecipe)this.recipe).getInput()).getIngredient() == null ? null : this.prepareItemStacks(((IngredientRecipeComponent)((IRecipe)this.recipe).getInput()).getItemStacks(), tick);
        List outputItems = ((IngredientsAndFluidStackRecipeComponent)((IRecipe)this.recipe).getOutput()).getSubIngredientComponents().stream().map(component -> component.getIngredient() == null ? null : this.prepareItemStacks(component.getItemStacks(), tick)).collect(Collectors.toList());
        FluidStack outputFluid = ((IngredientsAndFluidStackRecipeComponent)((IRecipe)this.recipe).getOutput()).getFluidStack();
        this.renderItem(gui, x + 16, y, inputItem, mx, my, INPUT_ITEM);
        int slotOffset = 0;
        for (int i = 0; i < outputItems.size(); ++i) {
            this.renderItem(gui, x + 68, y + slotOffset, (ItemStack)outputItems.get(i), mx, my, this.resultItems.get(i), ((IngredientRecipeComponent)((IngredientsAndFluidStackRecipeComponent)((IRecipe)this.recipe).getOutput()).getSubIngredientComponents().get(i)).getChance());
            slotOffset += 23;
        }
        if (outputFluid != null) {
            this.renderFluid(gui, x + 68, y + slotOffset, outputFluid, mx, my, RESULT_FLUID);
        }
        this.renderItem(gui, x + middle, y, this.getCrafter(), mx, my, false, null);
    }

    protected ItemStack getCrafter() {
        return new ItemStack((Block)BlockSqueezer.getInstance());
    }
}

