/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.AttachCapabilitiesEventPart;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartStateBase<P extends IPartType>
implements IPartState<P>,
IDirtyMarkListener {
    private boolean dirty = false;
    private boolean update = false;
    private boolean forceBlockUpdateRender = false;
    private int updateInterval = this.getDefaultUpdateInterval();
    private int priority = 0;
    private int channel = 0;
    private EnumFacing targetSide = null;
    private int id = -1;
    private Map<IAspect, IAspectProperties> aspectProperties = new IdentityHashMap<IAspect, IAspectProperties>();
    private boolean enabled = true;
    private CapabilityDispatcher capabilities = null;
    private IdentityHashMap<Capability<?>, Object> volatileCapabilities = new IdentityHashMap();

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("updateInterval", this.updateInterval);
        tag.func_74768_a("priority", this.priority);
        tag.func_74768_a("channel", this.channel);
        if (this.targetSide != null) {
            tag.func_74768_a("targetSide", this.targetSide.ordinal());
        }
        tag.func_74768_a("id", this.id);
        this.writeAspectProperties("aspectProperties", tag);
        tag.func_74757_a("enabled", this.enabled);
        if (this.capabilities != null) {
            tag.func_74782_a("ForgeCaps", (NBTBase)this.capabilities.serializeNBT());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.updateInterval = tag.func_74762_e("updateInterval");
        this.priority = tag.func_74762_e("priority");
        this.channel = tag.func_74762_e("channel");
        if (tag.func_150297_b("targetSide", 3)) {
            this.targetSide = EnumFacing.field_82609_l[tag.func_74762_e("targetSide")];
        }
        this.id = tag.func_74762_e("id");
        this.aspectProperties.clear();
        this.readAspectProperties("aspectProperties", tag);
        this.enabled = tag.func_74767_n("enabled");
        if (this.capabilities != null && tag.func_74764_b("ForgeCaps")) {
            this.capabilities.deserializeNBT(tag.func_74775_l("ForgeCaps"));
        }
    }

    protected void writeAspectProperties(String name, NBTTagCompound tag) {
        NBTTagCompound mapTag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Map.Entry<IAspect, IAspectProperties> entry : this.aspectProperties.entrySet()) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74778_a("key", entry.getKey().getTranslationKey());
            if (entry.getValue() != null) {
                entryTag.func_74782_a("value", (NBTBase)entry.getValue().toNBT());
            }
            list.func_74742_a((NBTBase)entryTag);
        }
        mapTag.func_74782_a("map", (NBTBase)list);
        tag.func_74782_a(name, (NBTBase)mapTag);
    }

    public void readAspectProperties(String name, NBTTagCompound tag) {
        NBTTagCompound mapTag = tag.func_74775_l(name);
        NBTTagList list = mapTag.func_150295_c("map", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        if (list.func_74745_c() > 0) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound entryTag = list.func_150305_b(i);
                IAspect key = Aspects.REGISTRY.getAspect(entryTag.func_74779_i("key"));
                AspectProperties value = null;
                if (entryTag.func_74764_b("value")) {
                    value = new AspectProperties();
                    value.fromNBT(entryTag.func_74775_l("value"));
                }
                if (key == null || value == null) continue;
                this.aspectProperties.put(key, value);
            }
        }
    }

    @Override
    public void generateId() {
        this.id = IntegratedDynamics.globalCounters.getNext("part");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void setTargetSideOverride(EnumFacing targetSide) {
        this.targetSide = targetSide;
    }

    @Override
    @Nullable
    public EnumFacing getTargetSideOverride() {
        return this.targetSide;
    }

    @Override
    public boolean isDirtyAndReset() {
        boolean wasDirty = this.dirty;
        this.dirty = false;
        return wasDirty;
    }

    @Override
    public boolean isUpdateAndReset() {
        boolean wasUpdate = this.update;
        this.update = false;
        return wasUpdate;
    }

    @Override
    public void forceBlockRenderUpdate() {
        this.forceBlockUpdateRender = true;
    }

    @Override
    public boolean isForceBlockRenderUpdateAndReset() {
        boolean wasForceBlockUpdateRender = this.forceBlockUpdateRender;
        this.forceBlockUpdateRender = false;
        return wasForceBlockUpdateRender;
    }

    public void onDirty() {
        this.dirty = true;
        this.forceBlockRenderUpdate();
    }

    public void sendUpdate() {
        this.update = true;
    }

    @Override
    public IAspectProperties getAspectProperties(IAspect aspect) {
        return this.aspectProperties.get(aspect);
    }

    @Override
    public void setAspectProperties(IAspect aspect, IAspectProperties properties) {
        this.aspectProperties.put(aspect, properties);
        this.sendUpdate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (this.enabled != wasEnabled) {
            this.sendUpdate();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void gatherCapabilities(P partType) {
        AttachCapabilitiesEventPart event = new AttachCapabilitiesEventPart((IPartType)partType, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities()) : null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        return this.hasCapability(capability) || this.volatileCapabilities.containsKey(capability) || this.hasCapability(capability, partNetwork, target) || this.capabilities != null && this.capabilities.hasCapability(capability, null);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        T cap = this.getCapability(capability);
        if (cap != null) {
            return cap;
        }
        cap = this.getCapability(capability, partNetwork, target);
        if (cap != null) {
            return cap;
        }
        Object o = this.volatileCapabilities.get(capability);
        if (o != null) {
            return (T)o;
        }
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, null));
    }

    @Override
    @Deprecated
    public boolean hasCapability(Capability<?> capability, IPartNetwork network, PartTarget target) {
        return false;
    }

    @Override
    @Deprecated
    public <T> T getCapability(Capability<T> capability, IPartNetwork network, PartTarget target) {
        return null;
    }

    @Deprecated
    public boolean hasCapability(Capability<?> capability) {
        return false;
    }

    @Deprecated
    public <T> T getCapability(Capability<T> capability) {
        return null;
    }

    @Override
    public <T> void addVolatileCapability(Capability<T> capability, T value) {
        this.volatileCapabilities.put(capability, value);
    }

    @Override
    public void removeVolatileCapability(Capability<?> capability) {
        this.volatileCapabilities.remove(capability);
    }

    protected int getDefaultUpdateInterval() {
        return GeneralConfig.defaultPartUpdateFreq;
    }
}

