/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.commoncapabilities.api.capability.wrench.IWrench;
import org.cyclops.commoncapabilities.api.capability.wrench.WrenchTarget;
import org.cyclops.integrateddynamics.Capabilities;

public final class WrenchHelpers {
    public static boolean isWrench(EntityPlayer player, ItemStack heldItem, World world, BlockPos pos, EnumFacing side) {
        if (heldItem == null) {
            return false;
        }
        return heldItem.hasCapability(Capabilities.WRENCH, null) && ((IWrench)heldItem.getCapability(Capabilities.WRENCH, null)).canUse(player, WrenchTarget.forBlock((World)world, (BlockPos)pos, (EnumFacing)side));
    }

    public static <P> void wrench(EntityPlayer player, ItemStack heldItem, World world, BlockPos pos, EnumFacing side, IWrenchAction<P> action, P parameter) {
        IWrench wrench = (IWrench)heldItem.getCapability(Capabilities.WRENCH, null);
        WrenchTarget wrenchTarget = WrenchTarget.forBlock((World)world, (BlockPos)pos, (EnumFacing)side);
        wrench.beforeUse(player, wrenchTarget);
        action.onWrench(player, pos, parameter);
        wrench.afterUse(player, wrenchTarget);
    }

    public static void wrench(EntityPlayer player, ItemStack heldItem, World world, BlockPos pos, EnumFacing side, IWrenchAction<Void> action) {
        WrenchHelpers.wrench(player, heldItem, world, pos, side, action, null);
    }

    public static abstract class SimpleWrenchAction
    implements IWrenchAction<Void> {
        @Override
        public void onWrench(EntityPlayer player, BlockPos pos, Void parameter) {
            this.onWrench(player, pos);
        }

        public abstract void onWrench(EntityPlayer var1, BlockPos var2);
    }

    public static interface IWrenchAction<P> {
        public void onWrench(EntityPlayer var1, BlockPos var2, P var3);
    }
}

