/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.GuiNumberField;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integrateddynamics.core.client.gui.GuiTextFieldDropdown;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;
import org.lwjgl.input.Keyboard;

public class GuiPartSettings
extends GuiContainerExtended {
    public static final int BUTTON_SAVE = 0;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final IPartType partType;
    private GuiNumberField numberFieldUpdateInterval = null;
    private GuiNumberField numberFieldPriority = null;
    private GuiNumberField numberFieldChannel = null;
    private GuiTextFieldDropdown<EnumFacing> dropdownFieldSide = null;
    private List<SideDropdownEntry> dropdownEntries;

    public GuiPartSettings(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        this(new ContainerPartSettings(player, target, partContainer, partType), player, target, partContainer, partType);
    }

    public GuiPartSettings(ContainerPartSettings containerPartSettings, EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super((ExtendedInventoryContainer)containerPartSettings);
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.putButtonAction(0, (buttonId, gui, container) -> this.onSave());
    }

    protected void onSave() {
        IntegratedDynamics._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.PART, (Object)this.getTarget().getCenter().getSide());
        try {
            if (this.isFieldSideEnabled()) {
                EnumFacing selectedSide = this.dropdownFieldSide.getSelectedDropdownPossibility() == null ? null : this.dropdownFieldSide.getSelectedDropdownPossibility().getValue();
                int side = selectedSide != null && selectedSide != this.getDefaultSide() ? selectedSide.ordinal() : -1;
                ValueNotifierHelpers.setValue((IValueNotifier)this.getContainer(), (int)((ContainerPartSettings)this.getContainer()).getLastSideValueId(), (int)side);
            }
            if (this.isFieldUpdateIntervalEnabled()) {
                int updateInterval = this.numberFieldUpdateInterval.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)this.getContainer(), (int)((ContainerPartSettings)this.getContainer()).getLastUpdateValueId(), (int)updateInterval);
            }
            if (this.isFieldPriorityEnabled()) {
                int priority = this.numberFieldPriority.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)this.getContainer(), (int)((ContainerPartSettings)this.getContainer()).getLastPriorityValueId(), (int)priority);
            }
            if (this.isFieldChannelEnabled()) {
                int channel = this.numberFieldChannel.getInt();
                ValueNotifierHelpers.setValue((IValueNotifier)this.getContainer(), (int)((ContainerPartSettings)this.getContainer()).getLastChannelValueId(), (int)channel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getGuiTexture() {
        return (String)this.getContainer().getGuiProvider().getModGui().getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "part_settings.png";
    }

    protected EnumFacing getCurrentSide() {
        return this.getTarget().getTarget().getSide();
    }

    protected EnumFacing getDefaultSide() {
        return this.getTarget().getCenter().getSide().func_176734_d();
    }

    protected String getSideText(EnumFacing side) {
        return side.func_176610_l().toLowerCase(Locale.ENGLISH);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.isFieldSideEnabled()) {
            this.dropdownEntries = Arrays.stream(EnumFacing.field_82609_l).map(x$0 -> new SideDropdownEntry((EnumFacing)x$0)).collect(Collectors.toList());
            this.dropdownFieldSide = new GuiTextFieldDropdown(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + 106, this.field_147009_r + this.getFieldSideY(), 70, 14, true, Sets.newHashSet(this.dropdownEntries));
            this.setSideInDropdownField(this.getCurrentSide());
            this.dropdownFieldSide.func_146203_f(15);
            this.dropdownFieldSide.func_146189_e(true);
            this.dropdownFieldSide.func_146193_g(0xFFFFFF);
            this.dropdownFieldSide.func_146205_d(true);
        }
        if (this.isFieldUpdateIntervalEnabled()) {
            this.numberFieldUpdateInterval = new GuiNumberField(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + 106, this.field_147009_r + this.getFieldUpdateIntervalY(), 70, 14, true, true);
            this.numberFieldUpdateInterval.func_146203_f(15);
            this.numberFieldUpdateInterval.func_146189_e(true);
            this.numberFieldUpdateInterval.func_146193_g(0xFFFFFF);
            this.numberFieldUpdateInterval.func_146205_d(true);
            ContainerPartSettings container = (ContainerPartSettings)this.getContainer();
            this.numberFieldUpdateInterval.setMinValue(container.getPartType().getMinimumUpdateInterval(container.getPartState()));
        }
        if (this.isFieldPriorityEnabled()) {
            this.numberFieldPriority = new GuiNumberField(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + 106, this.field_147009_r + this.getFieldPriorityY(), 70, 14, true, true);
            this.numberFieldPriority.setPositiveOnly(false);
            this.numberFieldPriority.func_146203_f(15);
            this.numberFieldPriority.func_146189_e(true);
            this.numberFieldPriority.func_146193_g(0xFFFFFF);
            this.numberFieldPriority.func_146205_d(true);
        }
        if (this.isFieldChannelEnabled()) {
            this.numberFieldChannel = new GuiNumberField(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + 106, this.field_147009_r + this.getFieldChannelY(), 70, 14, true, true);
            this.numberFieldChannel.setPositiveOnly(false);
            this.numberFieldChannel.func_146203_f(15);
            this.numberFieldChannel.func_146189_e(true);
            this.numberFieldChannel.func_146193_g(0xFFFFFF);
            this.numberFieldChannel.func_146205_d(true);
            this.numberFieldChannel.func_146184_c(this.isChannelEnabled());
        }
        String save = L10NHelpers.localize((String)"gui.integrateddynamics.button.save", (Object[])new Object[0]);
        this.field_146292_n.add(new GuiButtonText(0, this.field_147003_i + 178, this.field_147009_r + 8, this.field_146289_q.func_78256_a(save) + 6, 16, save, true));
        this.refreshValues();
    }

    protected int getFieldSideY() {
        return 9;
    }

    protected int getFieldUpdateIntervalY() {
        return 34;
    }

    protected int getFieldPriorityY() {
        return 59;
    }

    protected int getFieldChannelY() {
        return 84;
    }

    protected boolean isFieldSideEnabled() {
        return true;
    }

    protected boolean isFieldUpdateIntervalEnabled() {
        return true;
    }

    protected boolean isFieldPriorityEnabled() {
        return true;
    }

    protected boolean isFieldChannelEnabled() {
        return true;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!(this.func_146983_a(keyCode) || this.isFieldUpdateIntervalEnabled() && this.numberFieldUpdateInterval.func_146201_a(typedChar, keyCode) || this.isFieldPriorityEnabled() && this.numberFieldPriority.func_146201_a(typedChar, keyCode) || this.isFieldChannelEnabled() && this.numberFieldChannel.func_146201_a(typedChar, keyCode) || this.isFieldSideEnabled() && this.dropdownFieldSide.func_146201_a(typedChar, keyCode))) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isFieldSideEnabled()) {
            this.dropdownFieldSide.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.isFieldUpdateIntervalEnabled()) {
            this.numberFieldUpdateInterval.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.isFieldPriorityEnabled()) {
            this.numberFieldPriority.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.isFieldChannelEnabled()) {
            this.numberFieldChannel.func_146192_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.isFieldUpdateIntervalEnabled()) {
            this.field_146289_q.func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.update_interval", (Object[])new Object[0]), this.field_147003_i + 8, this.field_147009_r + this.getFieldUpdateIntervalY() + 3, Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.numberFieldUpdateInterval.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        }
        if (this.isFieldPriorityEnabled()) {
            this.field_146289_q.func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.priority", (Object[])new Object[0]), this.field_147003_i + 8, this.field_147009_r + this.getFieldPriorityY() + 3, Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.numberFieldPriority.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        }
        if (this.isFieldChannelEnabled()) {
            this.field_146289_q.func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.channel", (Object[])new Object[0]), this.field_147003_i + 8, this.field_147009_r + this.getFieldChannelY() + 3, this.isChannelEnabled() ? Helpers.RGBToInt((int)0, (int)0, (int)0) : Helpers.RGBToInt((int)100, (int)100, (int)100));
            this.numberFieldChannel.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        }
        if (this.isFieldSideEnabled()) {
            this.field_146289_q.func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.side", (Object[])new Object[0]), this.field_147003_i + 8, this.field_147009_r + this.getFieldSideY() + 3, Helpers.RGBToInt((int)0, (int)0, (int)0));
            this.dropdownFieldSide.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (!this.isChannelEnabled()) {
            GuiHelpers.renderTooltip((GuiContainer)this, (int)8, (int)87, (int)100, (int)20, (int)mouseX, (int)mouseY, () -> Lists.newArrayList((Object[])new String[]{L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.channel.disabledinfo", (Object[])new Object[0])}));
        }
    }

    protected boolean isChannelEnabled() {
        return GeneralConfig.energyConsumptionMultiplier > 0;
    }

    protected int getBaseXSize() {
        return 214;
    }

    protected int getBaseYSize() {
        return 191;
    }

    protected void setSideInDropdownField(EnumFacing side) {
        this.dropdownFieldSide.selectPossibility(this.dropdownEntries.get(side.ordinal()));
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        if (this.isFieldSideEnabled() && valueId == ((ContainerPartSettings)this.getContainer()).getLastSideValueId()) {
            int side = ((ContainerPartSettings)this.getContainer()).getLastSideValue();
            this.setSideInDropdownField(side == -1 ? this.getDefaultSide() : EnumFacing.field_82609_l[side]);
        }
        if (this.isFieldUpdateIntervalEnabled() && valueId == ((ContainerPartSettings)this.getContainer()).getLastUpdateValueId()) {
            this.numberFieldUpdateInterval.func_146180_a(Integer.toString(((ContainerPartSettings)this.getContainer()).getLastUpdateValue()));
        }
        if (this.isFieldPriorityEnabled() && valueId == ((ContainerPartSettings)this.getContainer()).getLastPriorityValueId()) {
            this.numberFieldPriority.func_146180_a(Integer.toString(((ContainerPartSettings)this.getContainer()).getLastPriorityValue()));
        }
        if (this.isFieldChannelEnabled() && valueId == ((ContainerPartSettings)this.getContainer()).getLastChannelValueId()) {
            this.numberFieldChannel.func_146180_a(Integer.toString(((ContainerPartSettings)this.getContainer()).getLastChannelValue()));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiPartSettings)) {
            return false;
        }
        GuiPartSettings other = (GuiPartSettings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        IPartContainer this$partContainer = this.getPartContainer();
        IPartContainer other$partContainer = other.getPartContainer();
        if (this$partContainer == null ? other$partContainer != null : !this$partContainer.equals(other$partContainer)) {
            return false;
        }
        IPartType this$partType = this.getPartType();
        IPartType other$partType = other.getPartType();
        if (this$partType == null ? other$partType != null : !this$partType.equals(other$partType)) {
            return false;
        }
        GuiNumberField this$numberFieldUpdateInterval = this.getNumberFieldUpdateInterval();
        GuiNumberField other$numberFieldUpdateInterval = other.getNumberFieldUpdateInterval();
        if (this$numberFieldUpdateInterval == null ? other$numberFieldUpdateInterval != null : !this$numberFieldUpdateInterval.equals(other$numberFieldUpdateInterval)) {
            return false;
        }
        GuiNumberField this$numberFieldPriority = this.getNumberFieldPriority();
        GuiNumberField other$numberFieldPriority = other.getNumberFieldPriority();
        if (this$numberFieldPriority == null ? other$numberFieldPriority != null : !this$numberFieldPriority.equals(other$numberFieldPriority)) {
            return false;
        }
        GuiNumberField this$numberFieldChannel = this.getNumberFieldChannel();
        GuiNumberField other$numberFieldChannel = other.getNumberFieldChannel();
        if (this$numberFieldChannel == null ? other$numberFieldChannel != null : !this$numberFieldChannel.equals(other$numberFieldChannel)) {
            return false;
        }
        GuiTextFieldDropdown<EnumFacing> this$dropdownFieldSide = this.getDropdownFieldSide();
        GuiTextFieldDropdown<EnumFacing> other$dropdownFieldSide = other.getDropdownFieldSide();
        if (this$dropdownFieldSide == null ? other$dropdownFieldSide != null : !((Object)this$dropdownFieldSide).equals(other$dropdownFieldSide)) {
            return false;
        }
        List<SideDropdownEntry> this$dropdownEntries = this.getDropdownEntries();
        List<SideDropdownEntry> other$dropdownEntries = other.getDropdownEntries();
        return !(this$dropdownEntries == null ? other$dropdownEntries != null : !((Object)this$dropdownEntries).equals(other$dropdownEntries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiPartSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        IPartContainer $partContainer = this.getPartContainer();
        result = result * 59 + ($partContainer == null ? 43 : $partContainer.hashCode());
        IPartType $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 43 : $partType.hashCode());
        GuiNumberField $numberFieldUpdateInterval = this.getNumberFieldUpdateInterval();
        result = result * 59 + ($numberFieldUpdateInterval == null ? 43 : $numberFieldUpdateInterval.hashCode());
        GuiNumberField $numberFieldPriority = this.getNumberFieldPriority();
        result = result * 59 + ($numberFieldPriority == null ? 43 : $numberFieldPriority.hashCode());
        GuiNumberField $numberFieldChannel = this.getNumberFieldChannel();
        result = result * 59 + ($numberFieldChannel == null ? 43 : $numberFieldChannel.hashCode());
        GuiTextFieldDropdown<EnumFacing> $dropdownFieldSide = this.getDropdownFieldSide();
        result = result * 59 + ($dropdownFieldSide == null ? 43 : ((Object)$dropdownFieldSide).hashCode());
        List<SideDropdownEntry> $dropdownEntries = this.getDropdownEntries();
        result = result * 59 + ($dropdownEntries == null ? 43 : ((Object)$dropdownEntries).hashCode());
        return result;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public IPartType getPartType() {
        return this.partType;
    }

    public GuiNumberField getNumberFieldUpdateInterval() {
        return this.numberFieldUpdateInterval;
    }

    public GuiNumberField getNumberFieldPriority() {
        return this.numberFieldPriority;
    }

    public GuiNumberField getNumberFieldChannel() {
        return this.numberFieldChannel;
    }

    public GuiTextFieldDropdown<EnumFacing> getDropdownFieldSide() {
        return this.dropdownFieldSide;
    }

    public List<SideDropdownEntry> getDropdownEntries() {
        return this.dropdownEntries;
    }

    public void setNumberFieldUpdateInterval(GuiNumberField numberFieldUpdateInterval) {
        this.numberFieldUpdateInterval = numberFieldUpdateInterval;
    }

    public void setNumberFieldPriority(GuiNumberField numberFieldPriority) {
        this.numberFieldPriority = numberFieldPriority;
    }

    public void setNumberFieldChannel(GuiNumberField numberFieldChannel) {
        this.numberFieldChannel = numberFieldChannel;
    }

    public void setDropdownFieldSide(GuiTextFieldDropdown<EnumFacing> dropdownFieldSide) {
        this.dropdownFieldSide = dropdownFieldSide;
    }

    public void setDropdownEntries(List<SideDropdownEntry> dropdownEntries) {
        this.dropdownEntries = dropdownEntries;
    }

    public String toString() {
        return "GuiPartSettings(target=" + this.getTarget() + ", partContainer=" + this.getPartContainer() + ", partType=" + this.getPartType() + ", numberFieldUpdateInterval=" + this.getNumberFieldUpdateInterval() + ", numberFieldPriority=" + this.getNumberFieldPriority() + ", numberFieldChannel=" + this.getNumberFieldChannel() + ", dropdownFieldSide=" + this.getDropdownFieldSide() + ", dropdownEntries=" + this.getDropdownEntries() + ")";
    }

    public class SideDropdownEntry
    implements IDropdownEntry<EnumFacing> {
        private final EnumFacing side;

        public SideDropdownEntry(EnumFacing side) {
            this.side = side;
        }

        @Override
        public String getMatchString() {
            return GuiPartSettings.this.getSideText(this.side);
        }

        @Override
        public String getDisplayString() {
            return (GuiPartSettings.this.getDefaultSide() == this.side ? TextFormatting.YELLOW : "") + this.getMatchString();
        }

        @Override
        public List<String> getTooltip() {
            return Collections.emptyList();
        }

        @Override
        public EnumFacing getValue() {
            return this.side;
        }
    }
}

