/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import java.util.Arrays;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.MatrixHelpers;

public class PartRenderPosition {
    public static final PartRenderPosition NONE = new PartRenderPosition(-1.0f, -1.0f, -1.0f, -1.0f);
    private final float depthFactor;
    private final float widthFactor;
    private final float heightFactor;
    private final float widthFactorSide;
    private final float heightFactorSide;
    private final EnumFacingMap<AxisAlignedBB> sidedCableCollisionBoxes;
    private final EnumFacingMap<AxisAlignedBB> collisionBoxes;

    public PartRenderPosition(float selectionDepthFactor, float depthFactor, float widthFactor, float heightFactor) {
        this(selectionDepthFactor, depthFactor, widthFactor, heightFactor, widthFactor, heightFactor);
    }

    public PartRenderPosition(float selectionDepthFactor, float depthFactor, float widthFactor, float heightFactor, float widthFactorSide, float heightFactorSide) {
        this.depthFactor = depthFactor;
        this.widthFactor = widthFactor;
        this.heightFactor = heightFactor;
        this.widthFactorSide = widthFactorSide;
        this.heightFactorSide = heightFactorSide;
        float[][] sidedCableCollisionBoxesRaw = new float[][]{{0.375f, selectionDepthFactor, 0.375f, 0.625f, 0.375f, 0.625f}, {0.375f, 0.625f, 0.375f, 0.625f, 1.0f - selectionDepthFactor, 0.625f}, {0.375f, 0.375f, selectionDepthFactor, 0.625f, 0.625f, 0.375f}, {0.375f, 0.625f, 0.625f, 0.625f, 0.375f, 1.0f - selectionDepthFactor}, {selectionDepthFactor, 0.375f, 0.375f, 0.375f, 0.625f, 0.625f}, {0.625f, 0.375f, 0.375f, 1.0f - selectionDepthFactor, 0.625f, 0.625f}};
        this.sidedCableCollisionBoxes = EnumFacingMap.newMap();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            float[] b = sidedCableCollisionBoxesRaw[side.ordinal()];
            this.sidedCableCollisionBoxes.put((Enum)side, (Object)new AxisAlignedBB((double)b[0], (double)b[1], (double)b[2], (double)b[3], (double)b[4], (double)b[5]));
        }
        float min = (1.0f - widthFactor) / 2.0f + 0.0025f;
        float max = (1.0f - widthFactor) / 2.0f + widthFactor - 0.0025f;
        float[][] collisionBoxesRaw = new float[][]{{min, max}, {0.005f, selectionDepthFactor}, {min, max}};
        this.collisionBoxes = EnumFacingMap.newMap();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            float[][] bounds = new float[collisionBoxesRaw.length][collisionBoxesRaw[0].length];
            for (int i = 0; i < bounds.length; ++i) {
                bounds[i] = Arrays.copyOf(collisionBoxesRaw[i], collisionBoxesRaw[i].length);
            }
            MatrixHelpers.transform((float[][])bounds, (EnumFacing)side);
            this.collisionBoxes.put((Enum)side, (Object)new AxisAlignedBB((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]));
        }
    }

    public float getDepthFactor() {
        return this.depthFactor;
    }

    public float getWidthFactor() {
        return this.widthFactor;
    }

    public float getHeightFactor() {
        return this.heightFactor;
    }

    public AxisAlignedBB getSidedCableBoundingBox(EnumFacing side) {
        return (AxisAlignedBB)this.sidedCableCollisionBoxes.get((Object)side);
    }

    public AxisAlignedBB getBoundingBox(EnumFacing side) {
        return (AxisAlignedBB)this.collisionBoxes.get((Object)side);
    }

    public float getWidthFactorSide() {
        return this.widthFactorSide;
    }

    public float getHeightFactorSide() {
        return this.heightFactorSide;
    }
}

