/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_nanobot.applicator;

import com.valkyrieofnight.et.m_multiblocks.m_nanobot.applicator.IAttributeApplicator;
import com.valkyrieofnight.um.api.attribute.AttributeCache;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class AttributeApplicatorPotion
implements IAttributeApplicator {
    protected AttributeID attributeID;
    protected Potion potion;
    protected int potionDuration;
    protected int maxPotionLevel;
    protected boolean ambient = false;
    protected boolean particles = false;

    public AttributeApplicatorPotion(AttributeID attributeID, Potion potion, int maxPotionDuration, int maxPotionLevel) {
        this.attributeID = attributeID;
        this.potion = potion;
        this.potionDuration = maxPotionDuration;
        this.maxPotionLevel = maxPotionLevel;
    }

    @Override
    public AttributeID getAttributeID() {
        return this.attributeID;
    }

    @Override
    public boolean onDisableAttribute(AttributeCache acache, World world, EntityPlayer player) {
        return true;
    }

    @Override
    public void onUpdateAttribute(AttributeCache acache, World world, EntityPlayer player) {
        if (acache.getAttribute() == this.attributeID) {
            int cachedInt = (Integer)acache.getFinalValue();
            int finalPotionLevel = cachedInt > this.maxPotionLevel ? this.maxPotionLevel : cachedInt;
            Object obj = this.attributeID.getCalculator().calculateModifiedValue((Object)finalPotionLevel, (Object)0);
            PotionEffect effect = new PotionEffect(this.potion, this.potionDuration, (Integer)obj - 1, this.ambient, this.particles);
            player.func_70690_d(effect);
        }
    }

    public void setPotionBools(boolean ambientIn, boolean showParticlesIn) {
        this.ambient = ambientIn;
        this.particles = showParticlesIn;
    }

    @Override
    public boolean onEnableAttribute(AttributeCache acache, World world, EntityPlayer player) {
        this.onUpdateAttribute(acache, world, player);
        return true;
    }
}

