/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.gui.ContainerSplitTank;
import de.maxhenkel.car.gui.GuiBase;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiSplitTank
extends GuiBase {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_split_tank.png");
    private static final int fontColor = 0x404040;
    private IInventory playerInv;
    private TileEntitySplitTank tile;

    public GuiSplitTank(TileEntitySplitTank tile, IInventory playerInv) {
        super(new ContainerSplitTank(tile, playerInv));
        this.playerInv = playerInv;
        this.tile = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        ArrayList<String> list;
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.playerInv.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (mouseX >= this.field_147003_i + 50 && mouseX <= this.field_147003_i + 16 + 50 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList<String>();
            list.add(new TextComponentTranslation("tooltip.mix", new Object[]{this.tile.func_174887_a_(0)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 120 && mouseX <= this.field_147003_i + 16 + 120 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TextComponentTranslation("tooltip.glycerin", new Object[]{this.tile.func_174887_a_(2)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 141 && mouseX <= this.field_147003_i + 16 + 141 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TextComponentTranslation("tooltip.bio_diesel", new Object[]{this.tile.func_174887_a_(1)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 79 && mouseX <= this.field_147003_i + 24 + 79 && mouseY >= this.field_147009_r + 34 && mouseY <= this.field_147009_r + 17 + 34) {
            list = new ArrayList();
            list.add(new TextComponentTranslation("tooltip.progress", new Object[]{(int)(this.getProgress() * 100.0f)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawProgress();
        this.drawMix();
        this.drawBioDiesel();
        this.drawGlycerin();
    }

    public void drawGlycerin() {
        float perc = this.getGlycerin();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 120;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawBioDiesel() {
        float perc = this.getBioDiesel();
        int texX = 208;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 141;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMix() {
        float perc = this.getMix();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 50;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress() {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getMix() {
        return (float)this.tile.func_174887_a_(0) / (float)this.tile.maxMix;
    }

    public float getBioDiesel() {
        return (float)this.tile.func_174887_a_(1) / (float)this.tile.maxBioDiesel;
    }

    public float getGlycerin() {
        return (float)this.tile.func_174887_a_(2) / (float)this.tile.maxGlycerin;
    }

    public float getProgress() {
        if (this.tile.func_174887_a_(3) == 0) {
            return 0.0f;
        }
        int time = this.tile.generatingTime - this.tile.func_174887_a_(3);
        return (float)time / (float)this.tile.generatingTime;
    }
}

