/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car;

import de.maxhenkel.car.entity.car.base.EntityCarNumberPlateBase;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.reciepe.CarBuilderTransporter;
import de.maxhenkel.car.reciepe.ICarbuilder;
import de.maxhenkel.tools.ItemTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class EntityCarTransporter
extends EntityCarNumberPlateBase {
    private static final DataParameter<Boolean> HAS_CONTAINER = EntityDataManager.func_187226_a(EntityCarTransporter.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityCarTransporter.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityCarTransporter(World worldIn) {
        this(worldIn, false, EnumDyeColor.WHITE);
    }

    public EntityCarTransporter(World worldIn, boolean hasContainer, EnumDyeColor color) {
        super(worldIn);
        this.func_70105_a(2.0f, 1.51f);
        this.maxFuel = 2000;
        this.setHasContainer(hasContainer);
        this.setType(color);
        this.externalInventory = hasContainer ? new InventoryBasic(this.getCarName().func_150254_d(), false, 54) : new InventoryBasic(this.getCarName().func_150254_d(), false, 27);
    }

    @Override
    public float getRotationModifier() {
        return 0.25f;
    }

    @Override
    public ITextComponent getCarName() {
        return new TextComponentTranslation("entity.car_transporter.name", new Object[0]);
    }

    @Override
    public float getFrontOffsetForPassenger(int i, Entity passenger) {
        return 0.55f;
    }

    @Override
    public float getSideOffsetForPassenger(int i, Entity passenger) {
        if (i <= 0) {
            return -0.38f;
        }
        return 0.38f;
    }

    @Override
    public int getPassengerSize() {
        return 2;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_CONTAINER, (Object)false);
        this.field_70180_af.func_187214_a(TYPE, (Object)EnumDyeColor.WHITE.func_176765_a());
    }

    private void setHasContainer(boolean has) {
        this.field_70180_af.func_187227_b(HAS_CONTAINER, (Object)has);
    }

    public boolean getHasContainer() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CONTAINER);
    }

    public void setType(EnumDyeColor color) {
        this.field_70180_af.func_187227_b(TYPE, (Object)color.func_176765_a());
    }

    public EnumDyeColor getType() {
        return EnumDyeColor.func_176764_b((int)((Integer)this.field_70180_af.func_187225_a(TYPE)));
    }

    public void addContainer() {
        if (this.getHasContainer()) {
            return;
        }
        IInventory inv = this.externalInventory;
        this.externalInventory = new InventoryBasic(this.getCarName().func_150254_d(), false, 54);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            this.externalInventory.func_70299_a(i, inv.func_70301_a(i));
            inv.func_70299_a(i, ItemTools.EMPTY);
        }
        this.setHasContainer(true);
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        if (player.func_70093_af() && !this.isLocked() && (stack = player.func_184586_b(hand)).func_77973_b().equals((Object)ModItems.CONTAINER)) {
            ItemTools.decrItemStack(stack, player);
            player.func_184611_a(hand, stack);
            this.addContainer();
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("has_container", this.getHasContainer());
        compound.func_74768_a("type", this.getType().func_176765_a());
        super.func_70014_b(compound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        this.setHasContainer(compound.func_74767_n("has_container"));
        this.externalInventory = this.getHasContainer() ? new InventoryBasic(this.getCarName().func_150254_d(), false, 54) : new InventoryBasic(this.getCarName().func_150254_d(), false, 27);
        this.setType(EnumDyeColor.func_176764_b((int)compound.func_74762_e("type")));
        super.func_70037_a(compound);
    }

    @Override
    public ICarbuilder getBuilder() {
        return new CarBuilderTransporter(this.getHasContainer(), this.getType());
    }

    @Override
    public String getID() {
        return "car_transporter";
    }
}

