/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.blocks.BlockFluidExtractor;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.tools.BlockPosList;
import de.maxhenkel.tools.FluidUtils;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidExtractor
extends TileEntityBase
implements ITickable {
    private IFluidHandler extractHandler;
    private final int drainSpeed = Config.fluidExtractorDrainSpeed;
    private ItemStack filter = null;

    @Nullable
    public Fluid getFilterFluid() {
        if (this.filter == null) {
            return null;
        }
        FluidStack stack = FluidUtil.getFluidContained((ItemStack)this.filter);
        if (stack == null || stack.amount <= 0) {
            return null;
        }
        return stack.getFluid();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateExtractHandler();
        if (this.extractHandler == null) {
            return;
        }
        FluidStack drainSimulated = this.getFilterFluid() == null ? this.extractHandler.drain(this.drainSpeed, false) : this.extractHandler.drain(new FluidStack(this.getFilterFluid(), this.drainSpeed), false);
        if (drainSimulated == null || drainSimulated.amount <= 0) {
            return;
        }
        LinkedList<IFluidHandler> handlers = new LinkedList<IFluidHandler>();
        this.getConnectedHandlers(handlers, new BlockPosList(), this.field_174879_c);
        LinkedList<IFluidHandler> fillHandlers = new LinkedList<IFluidHandler>();
        for (IFluidHandler handler : handlers) {
            int amount = handler.fill(drainSimulated, false);
            if (amount <= 0) continue;
            fillHandlers.add(handler);
        }
        if (fillHandlers.isEmpty()) {
            return;
        }
        for (IFluidHandler handler : fillHandlers) {
            if (this.getFilterFluid() == null) {
                FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this.extractHandler, (int)this.drainSpeed, (boolean)true);
                continue;
            }
            FluidUtils.tryFluidTransfer(handler, this.extractHandler, this.drainSpeed, true, this.getFilterFluid());
        }
    }

    public void updateExtractHandler() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!state.func_177230_c().equals((Object)ModBlocks.FLUID_EXTRACTOR)) {
            this.extractHandler = null;
            return;
        }
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)BlockFluidExtractor.FACING);
        this.extractHandler = FluidUtils.getFluidHandler((IBlockAccess)this.field_145850_b, this.field_174879_c, side);
    }

    public void getConnectedHandlers(List<IFluidHandler> handlers, BlockPosList positions, BlockPos pos) {
        for (EnumFacing side : EnumFacing.values()) {
            BlockPos p = pos.func_177972_a(side);
            if (positions.contains(p)) continue;
            IBlockState state = this.field_145850_b.func_180495_p(p);
            if (state.func_177230_c().equals((Object)ModBlocks.FLUID_PIPE) || state.func_177230_c().equals((Object)ModBlocks.FLUID_EXTRACTOR)) {
                positions.add(p);
                this.getConnectedHandlers(handlers, positions, p);
                continue;
            }
            IFluidHandler handler = FluidUtils.getFluidHandler((IBlockAccess)this.field_145850_b, pos, side);
            if (handler == null || handler.equals(this.extractHandler)) continue;
            handlers.add(handler);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.filter != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.filter.func_77955_b(tag);
            compound.func_74782_a("filter", (NBTBase)tag);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("filter")) {
            NBTTagCompound tag = compound.func_74775_l("filter");
            this.filter = new ItemStack(tag);
        } else {
            this.filter = null;
        }
        super.func_145839_a(compound);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.fluid_extractor.name", new Object[0]);
    }

    public ItemStack getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.func_77946_l();
    }

    public void setFilter(ItemStack filter) {
        if (filter == null) {
            this.filter = null;
            this.func_70296_d();
            this.synchronize();
            return;
        }
        this.filter = filter.func_77946_l();
        this.func_70296_d();
        this.synchronize();
    }
}

